/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TrustStoreAssociationStatusEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MutualAuthenticationAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MutualAuthenticationAttributes> {
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mode").getter(MutualAuthenticationAttributes.getter(MutualAuthenticationAttributes::mode)).setter(MutualAuthenticationAttributes.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()}).build();
    private static final SdkField<String> TRUST_STORE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrustStoreArn").getter(MutualAuthenticationAttributes.getter(MutualAuthenticationAttributes::trustStoreArn)).setter(MutualAuthenticationAttributes.setter(Builder::trustStoreArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustStoreArn").build()}).build();
    private static final SdkField<Boolean> IGNORE_CLIENT_CERTIFICATE_EXPIRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IgnoreClientCertificateExpiry").getter(MutualAuthenticationAttributes.getter(MutualAuthenticationAttributes::ignoreClientCertificateExpiry)).setter(MutualAuthenticationAttributes.setter(Builder::ignoreClientCertificateExpiry)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IgnoreClientCertificateExpiry").build()}).build();
    private static final SdkField<String> TRUST_STORE_ASSOCIATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrustStoreAssociationStatus").getter(MutualAuthenticationAttributes.getter(MutualAuthenticationAttributes::trustStoreAssociationStatusAsString)).setter(MutualAuthenticationAttributes.setter(Builder::trustStoreAssociationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustStoreAssociationStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODE_FIELD, TRUST_STORE_ARN_FIELD, IGNORE_CLIENT_CERTIFICATE_EXPIRY_FIELD, TRUST_STORE_ASSOCIATION_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String mode;
    private final String trustStoreArn;
    private final Boolean ignoreClientCertificateExpiry;
    private final String trustStoreAssociationStatus;

    private MutualAuthenticationAttributes(BuilderImpl builder) {
        this.mode = builder.mode;
        this.trustStoreArn = builder.trustStoreArn;
        this.ignoreClientCertificateExpiry = builder.ignoreClientCertificateExpiry;
        this.trustStoreAssociationStatus = builder.trustStoreAssociationStatus;
    }

    public final String mode() {
        return this.mode;
    }

    public final String trustStoreArn() {
        return this.trustStoreArn;
    }

    public final Boolean ignoreClientCertificateExpiry() {
        return this.ignoreClientCertificateExpiry;
    }

    public final TrustStoreAssociationStatusEnum trustStoreAssociationStatus() {
        return TrustStoreAssociationStatusEnum.fromValue(this.trustStoreAssociationStatus);
    }

    public final String trustStoreAssociationStatusAsString() {
        return this.trustStoreAssociationStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mode());
        hashCode = 31 * hashCode + Objects.hashCode(this.trustStoreArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ignoreClientCertificateExpiry());
        hashCode = 31 * hashCode + Objects.hashCode(this.trustStoreAssociationStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MutualAuthenticationAttributes)) {
            return false;
        }
        MutualAuthenticationAttributes other = (MutualAuthenticationAttributes)obj;
        return Objects.equals(this.mode(), other.mode()) && Objects.equals(this.trustStoreArn(), other.trustStoreArn()) && Objects.equals(this.ignoreClientCertificateExpiry(), other.ignoreClientCertificateExpiry()) && Objects.equals(this.trustStoreAssociationStatusAsString(), other.trustStoreAssociationStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"MutualAuthenticationAttributes").add("Mode", (Object)this.mode()).add("TrustStoreArn", (Object)this.trustStoreArn()).add("IgnoreClientCertificateExpiry", (Object)this.ignoreClientCertificateExpiry()).add("TrustStoreAssociationStatus", (Object)this.trustStoreAssociationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.mode()));
            }
            case "TrustStoreArn": {
                return Optional.ofNullable(clazz.cast(this.trustStoreArn()));
            }
            case "IgnoreClientCertificateExpiry": {
                return Optional.ofNullable(clazz.cast(this.ignoreClientCertificateExpiry()));
            }
            case "TrustStoreAssociationStatus": {
                return Optional.ofNullable(clazz.cast(this.trustStoreAssociationStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MutualAuthenticationAttributes, T> g) {
        return obj -> g.apply((MutualAuthenticationAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mode;
        private String trustStoreArn;
        private Boolean ignoreClientCertificateExpiry;
        private String trustStoreAssociationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(MutualAuthenticationAttributes model) {
            this.mode(model.mode);
            this.trustStoreArn(model.trustStoreArn);
            this.ignoreClientCertificateExpiry(model.ignoreClientCertificateExpiry);
            this.trustStoreAssociationStatus(model.trustStoreAssociationStatus);
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        public final String getTrustStoreArn() {
            return this.trustStoreArn;
        }

        public final void setTrustStoreArn(String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
        }

        @Override
        public final Builder trustStoreArn(String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
            return this;
        }

        public final Boolean getIgnoreClientCertificateExpiry() {
            return this.ignoreClientCertificateExpiry;
        }

        public final void setIgnoreClientCertificateExpiry(Boolean ignoreClientCertificateExpiry) {
            this.ignoreClientCertificateExpiry = ignoreClientCertificateExpiry;
        }

        @Override
        public final Builder ignoreClientCertificateExpiry(Boolean ignoreClientCertificateExpiry) {
            this.ignoreClientCertificateExpiry = ignoreClientCertificateExpiry;
            return this;
        }

        public final String getTrustStoreAssociationStatus() {
            return this.trustStoreAssociationStatus;
        }

        public final void setTrustStoreAssociationStatus(String trustStoreAssociationStatus) {
            this.trustStoreAssociationStatus = trustStoreAssociationStatus;
        }

        @Override
        public final Builder trustStoreAssociationStatus(String trustStoreAssociationStatus) {
            this.trustStoreAssociationStatus = trustStoreAssociationStatus;
            return this;
        }

        @Override
        public final Builder trustStoreAssociationStatus(TrustStoreAssociationStatusEnum trustStoreAssociationStatus) {
            this.trustStoreAssociationStatus(trustStoreAssociationStatus == null ? null : trustStoreAssociationStatus.toString());
            return this;
        }

        public MutualAuthenticationAttributes build() {
            return new MutualAuthenticationAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MutualAuthenticationAttributes> {
        public Builder mode(String var1);

        public Builder trustStoreArn(String var1);

        public Builder ignoreClientCertificateExpiry(Boolean var1);

        public Builder trustStoreAssociationStatus(String var1);

        public Builder trustStoreAssociationStatus(TrustStoreAssociationStatusEnum var1);
    }
}

