/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Action;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ActionsCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AlpnPolicyNameCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Certificate;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CertificateListCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Request;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.MutualAuthenticationAttributes;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ProtocolEnum;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Tag;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateListenerRequest
extends ElasticLoadBalancingV2Request
implements ToCopyableBuilder<Builder, CreateListenerRequest> {
    private static final SdkField<String> LOAD_BALANCER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LoadBalancerArn").getter(CreateListenerRequest.getter(CreateListenerRequest::loadBalancerArn)).setter(CreateListenerRequest.setter(Builder::loadBalancerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerArn").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(CreateListenerRequest.getter(CreateListenerRequest::protocolAsString)).setter(CreateListenerRequest.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(CreateListenerRequest.getter(CreateListenerRequest::port)).setter(CreateListenerRequest.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> SSL_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SslPolicy").getter(CreateListenerRequest.getter(CreateListenerRequest::sslPolicy)).setter(CreateListenerRequest.setter(Builder::sslPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SslPolicy").build()}).build();
    private static final SdkField<List<Certificate>> CERTIFICATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Certificates").getter(CreateListenerRequest.getter(CreateListenerRequest::certificates)).setter(CreateListenerRequest.setter(Builder::certificates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Certificate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Action>> DEFAULT_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DefaultActions").getter(CreateListenerRequest.getter(CreateListenerRequest::defaultActions)).setter(CreateListenerRequest.setter(Builder::defaultActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Action::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ALPN_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AlpnPolicy").getter(CreateListenerRequest.getter(CreateListenerRequest::alpnPolicy)).setter(CreateListenerRequest.setter(Builder::alpnPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlpnPolicy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateListenerRequest.getter(CreateListenerRequest::tags)).setter(CreateListenerRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<MutualAuthenticationAttributes> MUTUAL_AUTHENTICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MutualAuthentication").getter(CreateListenerRequest.getter(CreateListenerRequest::mutualAuthentication)).setter(CreateListenerRequest.setter(Builder::mutualAuthentication)).constructor(MutualAuthenticationAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MutualAuthentication").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_ARN_FIELD, PROTOCOL_FIELD, PORT_FIELD, SSL_POLICY_FIELD, CERTIFICATES_FIELD, DEFAULT_ACTIONS_FIELD, ALPN_POLICY_FIELD, TAGS_FIELD, MUTUAL_AUTHENTICATION_FIELD));
    private final String loadBalancerArn;
    private final String protocol;
    private final Integer port;
    private final String sslPolicy;
    private final List<Certificate> certificates;
    private final List<Action> defaultActions;
    private final List<String> alpnPolicy;
    private final List<Tag> tags;
    private final MutualAuthenticationAttributes mutualAuthentication;

    private CreateListenerRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerArn = builder.loadBalancerArn;
        this.protocol = builder.protocol;
        this.port = builder.port;
        this.sslPolicy = builder.sslPolicy;
        this.certificates = builder.certificates;
        this.defaultActions = builder.defaultActions;
        this.alpnPolicy = builder.alpnPolicy;
        this.tags = builder.tags;
        this.mutualAuthentication = builder.mutualAuthentication;
    }

    public final String loadBalancerArn() {
        return this.loadBalancerArn;
    }

    public final ProtocolEnum protocol() {
        return ProtocolEnum.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public final Integer port() {
        return this.port;
    }

    public final String sslPolicy() {
        return this.sslPolicy;
    }

    public final boolean hasCertificates() {
        return this.certificates != null && !(this.certificates instanceof SdkAutoConstructList);
    }

    public final List<Certificate> certificates() {
        return this.certificates;
    }

    public final boolean hasDefaultActions() {
        return this.defaultActions != null && !(this.defaultActions instanceof SdkAutoConstructList);
    }

    public final List<Action> defaultActions() {
        return this.defaultActions;
    }

    public final boolean hasAlpnPolicy() {
        return this.alpnPolicy != null && !(this.alpnPolicy instanceof SdkAutoConstructList);
    }

    public final List<String> alpnPolicy() {
        return this.alpnPolicy;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final MutualAuthenticationAttributes mutualAuthentication() {
        return this.mutualAuthentication;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.sslPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCertificates() ? this.certificates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDefaultActions() ? this.defaultActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAlpnPolicy() ? this.alpnPolicy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.mutualAuthentication());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateListenerRequest)) {
            return false;
        }
        CreateListenerRequest other = (CreateListenerRequest)((Object)obj);
        return Objects.equals(this.loadBalancerArn(), other.loadBalancerArn()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.sslPolicy(), other.sslPolicy()) && this.hasCertificates() == other.hasCertificates() && Objects.equals(this.certificates(), other.certificates()) && this.hasDefaultActions() == other.hasDefaultActions() && Objects.equals(this.defaultActions(), other.defaultActions()) && this.hasAlpnPolicy() == other.hasAlpnPolicy() && Objects.equals(this.alpnPolicy(), other.alpnPolicy()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.mutualAuthentication(), other.mutualAuthentication());
    }

    public final String toString() {
        return ToString.builder((String)"CreateListenerRequest").add("LoadBalancerArn", (Object)this.loadBalancerArn()).add("Protocol", (Object)this.protocolAsString()).add("Port", (Object)this.port()).add("SslPolicy", (Object)this.sslPolicy()).add("Certificates", this.hasCertificates() ? this.certificates() : null).add("DefaultActions", this.hasDefaultActions() ? this.defaultActions() : null).add("AlpnPolicy", this.hasAlpnPolicy() ? this.alpnPolicy() : null).add("Tags", this.hasTags() ? this.tags() : null).add("MutualAuthentication", (Object)this.mutualAuthentication()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoadBalancerArn": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerArn()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "SslPolicy": {
                return Optional.ofNullable(clazz.cast(this.sslPolicy()));
            }
            case "Certificates": {
                return Optional.ofNullable(clazz.cast(this.certificates()));
            }
            case "DefaultActions": {
                return Optional.ofNullable(clazz.cast(this.defaultActions()));
            }
            case "AlpnPolicy": {
                return Optional.ofNullable(clazz.cast(this.alpnPolicy()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "MutualAuthentication": {
                return Optional.ofNullable(clazz.cast(this.mutualAuthentication()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateListenerRequest, T> g) {
        return obj -> g.apply((CreateListenerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingV2Request.BuilderImpl
    implements Builder {
        private String loadBalancerArn;
        private String protocol;
        private Integer port;
        private String sslPolicy;
        private List<Certificate> certificates = DefaultSdkAutoConstructList.getInstance();
        private List<Action> defaultActions = DefaultSdkAutoConstructList.getInstance();
        private List<String> alpnPolicy = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private MutualAuthenticationAttributes mutualAuthentication;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateListenerRequest model) {
            super(model);
            this.loadBalancerArn(model.loadBalancerArn);
            this.protocol(model.protocol);
            this.port(model.port);
            this.sslPolicy(model.sslPolicy);
            this.certificates(model.certificates);
            this.defaultActions(model.defaultActions);
            this.alpnPolicy(model.alpnPolicy);
            this.tags(model.tags);
            this.mutualAuthentication(model.mutualAuthentication);
        }

        public final String getLoadBalancerArn() {
            return this.loadBalancerArn;
        }

        public final void setLoadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
        }

        @Override
        public final Builder loadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(ProtocolEnum protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getSslPolicy() {
            return this.sslPolicy;
        }

        public final void setSslPolicy(String sslPolicy) {
            this.sslPolicy = sslPolicy;
        }

        @Override
        public final Builder sslPolicy(String sslPolicy) {
            this.sslPolicy = sslPolicy;
            return this;
        }

        public final List<Certificate.Builder> getCertificates() {
            List<Certificate.Builder> result = CertificateListCopier.copyToBuilder(this.certificates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCertificates(Collection<Certificate.BuilderImpl> certificates) {
            this.certificates = CertificateListCopier.copyFromBuilder(certificates);
        }

        @Override
        public final Builder certificates(Collection<Certificate> certificates) {
            this.certificates = CertificateListCopier.copy(certificates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificates(Certificate ... certificates) {
            this.certificates(Arrays.asList(certificates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificates(Consumer<Certificate.Builder> ... certificates) {
            this.certificates(Stream.of(certificates).map(c -> (Certificate)((Certificate.Builder)Certificate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Action.Builder> getDefaultActions() {
            List<Action.Builder> result = ActionsCopier.copyToBuilder(this.defaultActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDefaultActions(Collection<Action.BuilderImpl> defaultActions) {
            this.defaultActions = ActionsCopier.copyFromBuilder(defaultActions);
        }

        @Override
        public final Builder defaultActions(Collection<Action> defaultActions) {
            this.defaultActions = ActionsCopier.copy(defaultActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultActions(Action ... defaultActions) {
            this.defaultActions(Arrays.asList(defaultActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultActions(Consumer<Action.Builder> ... defaultActions) {
            this.defaultActions(Stream.of(defaultActions).map(c -> (Action)((Action.Builder)Action.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAlpnPolicy() {
            if (this.alpnPolicy instanceof SdkAutoConstructList) {
                return null;
            }
            return this.alpnPolicy;
        }

        public final void setAlpnPolicy(Collection<String> alpnPolicy) {
            this.alpnPolicy = AlpnPolicyNameCopier.copy(alpnPolicy);
        }

        @Override
        public final Builder alpnPolicy(Collection<String> alpnPolicy) {
            this.alpnPolicy = AlpnPolicyNameCopier.copy(alpnPolicy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alpnPolicy(String ... alpnPolicy) {
            this.alpnPolicy(Arrays.asList(alpnPolicy));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final MutualAuthenticationAttributes.Builder getMutualAuthentication() {
            return this.mutualAuthentication != null ? this.mutualAuthentication.toBuilder() : null;
        }

        public final void setMutualAuthentication(MutualAuthenticationAttributes.BuilderImpl mutualAuthentication) {
            this.mutualAuthentication = mutualAuthentication != null ? mutualAuthentication.build() : null;
        }

        @Override
        public final Builder mutualAuthentication(MutualAuthenticationAttributes mutualAuthentication) {
            this.mutualAuthentication = mutualAuthentication;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateListenerRequest build() {
            return new CreateListenerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateListenerRequest> {
        public Builder loadBalancerArn(String var1);

        public Builder protocol(String var1);

        public Builder protocol(ProtocolEnum var1);

        public Builder port(Integer var1);

        public Builder sslPolicy(String var1);

        public Builder certificates(Collection<Certificate> var1);

        public Builder certificates(Certificate ... var1);

        public Builder certificates(Consumer<Certificate.Builder> ... var1);

        public Builder defaultActions(Collection<Action> var1);

        public Builder defaultActions(Action ... var1);

        public Builder defaultActions(Consumer<Action.Builder> ... var1);

        public Builder alpnPolicy(Collection<String> var1);

        public Builder alpnPolicy(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder mutualAuthentication(MutualAuthenticationAttributes var1);

        default public Builder mutualAuthentication(Consumer<MutualAuthenticationAttributes.Builder> mutualAuthentication) {
            return this.mutualAuthentication((MutualAuthenticationAttributes)((MutualAuthenticationAttributes.Builder)MutualAuthenticationAttributes.builder().applyMutation(mutualAuthentication)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

