/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a revocation file.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RevocationContent implements SdkPojo, Serializable,
        ToCopyableBuilder<RevocationContent.Builder, RevocationContent> {
    private static final SdkField<String> S3_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3Bucket").getter(getter(RevocationContent::s3Bucket)).setter(setter(Builder::s3Bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Bucket").build()).build();

    private static final SdkField<String> S3_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("S3Key")
            .getter(getter(RevocationContent::s3Key)).setter(setter(Builder::s3Key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Key").build()).build();

    private static final SdkField<String> S3_OBJECT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3ObjectVersion").getter(getter(RevocationContent::s3ObjectVersion))
            .setter(setter(Builder::s3ObjectVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ObjectVersion").build()).build();

    private static final SdkField<String> REVOCATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RevocationType").getter(getter(RevocationContent::revocationTypeAsString))
            .setter(setter(Builder::revocationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevocationType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_FIELD, S3_KEY_FIELD,
            S3_OBJECT_VERSION_FIELD, REVOCATION_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String s3Bucket;

    private final String s3Key;

    private final String s3ObjectVersion;

    private final String revocationType;

    private RevocationContent(BuilderImpl builder) {
        this.s3Bucket = builder.s3Bucket;
        this.s3Key = builder.s3Key;
        this.s3ObjectVersion = builder.s3ObjectVersion;
        this.revocationType = builder.revocationType;
    }

    /**
     * <p>
     * The Amazon S3 bucket for the revocation file.
     * </p>
     * 
     * @return The Amazon S3 bucket for the revocation file.
     */
    public final String s3Bucket() {
        return s3Bucket;
    }

    /**
     * <p>
     * The Amazon S3 path for the revocation file.
     * </p>
     * 
     * @return The Amazon S3 path for the revocation file.
     */
    public final String s3Key() {
        return s3Key;
    }

    /**
     * <p>
     * The Amazon S3 object version of the revocation file.
     * </p>
     * 
     * @return The Amazon S3 object version of the revocation file.
     */
    public final String s3ObjectVersion() {
        return s3ObjectVersion;
    }

    /**
     * <p>
     * The type of revocation file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #revocationType}
     * will return {@link RevocationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #revocationTypeAsString}.
     * </p>
     * 
     * @return The type of revocation file.
     * @see RevocationType
     */
    public final RevocationType revocationType() {
        return RevocationType.fromValue(revocationType);
    }

    /**
     * <p>
     * The type of revocation file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #revocationType}
     * will return {@link RevocationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #revocationTypeAsString}.
     * </p>
     * 
     * @return The type of revocation file.
     * @see RevocationType
     */
    public final String revocationTypeAsString() {
        return revocationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(s3Key());
        hashCode = 31 * hashCode + Objects.hashCode(s3ObjectVersion());
        hashCode = 31 * hashCode + Objects.hashCode(revocationTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevocationContent)) {
            return false;
        }
        RevocationContent other = (RevocationContent) obj;
        return Objects.equals(s3Bucket(), other.s3Bucket()) && Objects.equals(s3Key(), other.s3Key())
                && Objects.equals(s3ObjectVersion(), other.s3ObjectVersion())
                && Objects.equals(revocationTypeAsString(), other.revocationTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RevocationContent").add("S3Bucket", s3Bucket()).add("S3Key", s3Key())
                .add("S3ObjectVersion", s3ObjectVersion()).add("RevocationType", revocationTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Bucket":
            return Optional.ofNullable(clazz.cast(s3Bucket()));
        case "S3Key":
            return Optional.ofNullable(clazz.cast(s3Key()));
        case "S3ObjectVersion":
            return Optional.ofNullable(clazz.cast(s3ObjectVersion()));
        case "RevocationType":
            return Optional.ofNullable(clazz.cast(revocationTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RevocationContent, T> g) {
        return obj -> g.apply((RevocationContent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RevocationContent> {
        /**
         * <p>
         * The Amazon S3 bucket for the revocation file.
         * </p>
         * 
         * @param s3Bucket
         *        The Amazon S3 bucket for the revocation file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Bucket(String s3Bucket);

        /**
         * <p>
         * The Amazon S3 path for the revocation file.
         * </p>
         * 
         * @param s3Key
         *        The Amazon S3 path for the revocation file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Key(String s3Key);

        /**
         * <p>
         * The Amazon S3 object version of the revocation file.
         * </p>
         * 
         * @param s3ObjectVersion
         *        The Amazon S3 object version of the revocation file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3ObjectVersion(String s3ObjectVersion);

        /**
         * <p>
         * The type of revocation file.
         * </p>
         * 
         * @param revocationType
         *        The type of revocation file.
         * @see RevocationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RevocationType
         */
        Builder revocationType(String revocationType);

        /**
         * <p>
         * The type of revocation file.
         * </p>
         * 
         * @param revocationType
         *        The type of revocation file.
         * @see RevocationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RevocationType
         */
        Builder revocationType(RevocationType revocationType);
    }

    static final class BuilderImpl implements Builder {
        private String s3Bucket;

        private String s3Key;

        private String s3ObjectVersion;

        private String revocationType;

        private BuilderImpl() {
        }

        private BuilderImpl(RevocationContent model) {
            s3Bucket(model.s3Bucket);
            s3Key(model.s3Key);
            s3ObjectVersion(model.s3ObjectVersion);
            revocationType(model.revocationType);
        }

        public final String getS3Bucket() {
            return s3Bucket;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final String getS3Key() {
            return s3Key;
        }

        public final void setS3Key(String s3Key) {
            this.s3Key = s3Key;
        }

        @Override
        public final Builder s3Key(String s3Key) {
            this.s3Key = s3Key;
            return this;
        }

        public final String getS3ObjectVersion() {
            return s3ObjectVersion;
        }

        public final void setS3ObjectVersion(String s3ObjectVersion) {
            this.s3ObjectVersion = s3ObjectVersion;
        }

        @Override
        public final Builder s3ObjectVersion(String s3ObjectVersion) {
            this.s3ObjectVersion = s3ObjectVersion;
            return this;
        }

        public final String getRevocationType() {
            return revocationType;
        }

        public final void setRevocationType(String revocationType) {
            this.revocationType = revocationType;
        }

        @Override
        public final Builder revocationType(String revocationType) {
            this.revocationType = revocationType;
            return this;
        }

        @Override
        public final Builder revocationType(RevocationType revocationType) {
            this.revocationType(revocationType == null ? null : revocationType.toString());
            return this;
        }

        @Override
        public RevocationContent build() {
            return new RevocationContent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
