/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Response;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SslPoliciesCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SslPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSslPoliciesResponse
extends ElasticLoadBalancingV2Response
implements ToCopyableBuilder<Builder, DescribeSslPoliciesResponse> {
    private static final SdkField<List<SslPolicy>> SSL_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SslPolicies").getter(DescribeSslPoliciesResponse.getter(DescribeSslPoliciesResponse::sslPolicies)).setter(DescribeSslPoliciesResponse.setter(Builder::sslPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SslPolicies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SslPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextMarker").getter(DescribeSslPoliciesResponse.getter(DescribeSslPoliciesResponse::nextMarker)).setter(DescribeSslPoliciesResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SSL_POLICIES_FIELD, NEXT_MARKER_FIELD));
    private final List<SslPolicy> sslPolicies;
    private final String nextMarker;

    private DescribeSslPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.sslPolicies = builder.sslPolicies;
        this.nextMarker = builder.nextMarker;
    }

    public final boolean hasSslPolicies() {
        return this.sslPolicies != null && !(this.sslPolicies instanceof SdkAutoConstructList);
    }

    public final List<SslPolicy> sslPolicies() {
        return this.sslPolicies;
    }

    public final String nextMarker() {
        return this.nextMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSslPolicies() ? this.sslPolicies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSslPoliciesResponse)) {
            return false;
        }
        DescribeSslPoliciesResponse other = (DescribeSslPoliciesResponse)((Object)obj);
        return this.hasSslPolicies() == other.hasSslPolicies() && Objects.equals(this.sslPolicies(), other.sslPolicies()) && Objects.equals(this.nextMarker(), other.nextMarker());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeSslPoliciesResponse").add("SslPolicies", this.hasSslPolicies() ? this.sslPolicies() : null).add("NextMarker", (Object)this.nextMarker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SslPolicies": {
                return Optional.ofNullable(clazz.cast(this.sslPolicies()));
            }
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSslPoliciesResponse, T> g) {
        return obj -> g.apply((DescribeSslPoliciesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingV2Response.BuilderImpl
    implements Builder {
        private List<SslPolicy> sslPolicies = DefaultSdkAutoConstructList.getInstance();
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSslPoliciesResponse model) {
            super(model);
            this.sslPolicies(model.sslPolicies);
            this.nextMarker(model.nextMarker);
        }

        public final List<SslPolicy.Builder> getSslPolicies() {
            List<SslPolicy.Builder> result = SslPoliciesCopier.copyToBuilder(this.sslPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSslPolicies(Collection<SslPolicy.BuilderImpl> sslPolicies) {
            this.sslPolicies = SslPoliciesCopier.copyFromBuilder(sslPolicies);
        }

        @Override
        public final Builder sslPolicies(Collection<SslPolicy> sslPolicies) {
            this.sslPolicies = SslPoliciesCopier.copy(sslPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sslPolicies(SslPolicy ... sslPolicies) {
            this.sslPolicies(Arrays.asList(sslPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sslPolicies(Consumer<SslPolicy.Builder> ... sslPolicies) {
            this.sslPolicies(Stream.of(sslPolicies).map(c -> (SslPolicy)((SslPolicy.Builder)SslPolicy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        @Override
        public DescribeSslPoliciesResponse build() {
            return new DescribeSslPoliciesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSslPoliciesResponse> {
        public Builder sslPolicies(Collection<SslPolicy> var1);

        public Builder sslPolicies(SslPolicy ... var1);

        public Builder sslPolicies(Consumer<SslPolicy.Builder> ... var1);

        public Builder nextMarker(String var1);
    }
}

