/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Cipher;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CiphersCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SslProtocolsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SslPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SslPolicy> {
    private static final SdkField<List<String>> SSL_PROTOCOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SslProtocols").getter(SslPolicy.getter(SslPolicy::sslProtocols)).setter(SslPolicy.setter(Builder::sslProtocols)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SslProtocols").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Cipher>> CIPHERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Ciphers").getter(SslPolicy.getter(SslPolicy::ciphers)).setter(SslPolicy.setter(Builder::ciphers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ciphers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Cipher::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(SslPolicy.getter(SslPolicy::name)).setter(SslPolicy.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SSL_PROTOCOLS_FIELD, CIPHERS_FIELD, NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> sslProtocols;
    private final List<Cipher> ciphers;
    private final String name;

    private SslPolicy(BuilderImpl builder) {
        this.sslProtocols = builder.sslProtocols;
        this.ciphers = builder.ciphers;
        this.name = builder.name;
    }

    public final boolean hasSslProtocols() {
        return this.sslProtocols != null && !(this.sslProtocols instanceof SdkAutoConstructList);
    }

    public final List<String> sslProtocols() {
        return this.sslProtocols;
    }

    public final boolean hasCiphers() {
        return this.ciphers != null && !(this.ciphers instanceof SdkAutoConstructList);
    }

    public final List<Cipher> ciphers() {
        return this.ciphers;
    }

    public final String name() {
        return this.name;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSslProtocols() ? this.sslProtocols() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCiphers() ? this.ciphers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SslPolicy)) {
            return false;
        }
        SslPolicy other = (SslPolicy)obj;
        return this.hasSslProtocols() == other.hasSslProtocols() && Objects.equals(this.sslProtocols(), other.sslProtocols()) && this.hasCiphers() == other.hasCiphers() && Objects.equals(this.ciphers(), other.ciphers()) && Objects.equals(this.name(), other.name());
    }

    public final String toString() {
        return ToString.builder((String)"SslPolicy").add("SslProtocols", this.hasSslProtocols() ? this.sslProtocols() : null).add("Ciphers", this.hasCiphers() ? this.ciphers() : null).add("Name", (Object)this.name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SslProtocols": {
                return Optional.ofNullable(clazz.cast(this.sslProtocols()));
            }
            case "Ciphers": {
                return Optional.ofNullable(clazz.cast(this.ciphers()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SslPolicy, T> g) {
        return obj -> g.apply((SslPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> sslProtocols = DefaultSdkAutoConstructList.getInstance();
        private List<Cipher> ciphers = DefaultSdkAutoConstructList.getInstance();
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(SslPolicy model) {
            this.sslProtocols(model.sslProtocols);
            this.ciphers(model.ciphers);
            this.name(model.name);
        }

        public final Collection<String> getSslProtocols() {
            if (this.sslProtocols instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sslProtocols;
        }

        @Override
        public final Builder sslProtocols(Collection<String> sslProtocols) {
            this.sslProtocols = SslProtocolsCopier.copy(sslProtocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sslProtocols(String ... sslProtocols) {
            this.sslProtocols(Arrays.asList(sslProtocols));
            return this;
        }

        public final void setSslProtocols(Collection<String> sslProtocols) {
            this.sslProtocols = SslProtocolsCopier.copy(sslProtocols);
        }

        public final List<Cipher.Builder> getCiphers() {
            List<Cipher.Builder> result = CiphersCopier.copyToBuilder(this.ciphers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder ciphers(Collection<Cipher> ciphers) {
            this.ciphers = CiphersCopier.copy(ciphers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ciphers(Cipher ... ciphers) {
            this.ciphers(Arrays.asList(ciphers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ciphers(Consumer<Cipher.Builder> ... ciphers) {
            this.ciphers(Stream.of(ciphers).map(c -> (Cipher)((Cipher.Builder)Cipher.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCiphers(Collection<Cipher.BuilderImpl> ciphers) {
            this.ciphers = CiphersCopier.copyFromBuilder(ciphers);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public SslPolicy build() {
            return new SslPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SslPolicy> {
        public Builder sslProtocols(Collection<String> var1);

        public Builder sslProtocols(String ... var1);

        public Builder ciphers(Collection<Cipher> var1);

        public Builder ciphers(Cipher ... var1);

        public Builder ciphers(Consumer<Cipher.Builder> ... var1);

        public Builder name(String var1);
    }
}

