/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteRuleRequest
extends ElasticLoadBalancingV2Request
implements ToCopyableBuilder<Builder, DeleteRuleRequest> {
    private static final SdkField<String> RULE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleArn").getter(DeleteRuleRequest.getter(DeleteRuleRequest::ruleArn)).setter(DeleteRuleRequest.setter(Builder::ruleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_ARN_FIELD));
    private final String ruleArn;

    private DeleteRuleRequest(BuilderImpl builder) {
        super(builder);
        this.ruleArn = builder.ruleArn;
    }

    public final String ruleArn() {
        return this.ruleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRuleRequest)) {
            return false;
        }
        DeleteRuleRequest other = (DeleteRuleRequest)((Object)obj);
        return Objects.equals(this.ruleArn(), other.ruleArn());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteRuleRequest").add("RuleArn", (Object)this.ruleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleArn": {
                return Optional.ofNullable(clazz.cast(this.ruleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteRuleRequest, T> g) {
        return obj -> g.apply((DeleteRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingV2Request.BuilderImpl
    implements Builder {
        private String ruleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRuleRequest model) {
            super(model);
            this.ruleArn(model.ruleArn);
        }

        public final String getRuleArn() {
            return this.ruleArn;
        }

        @Override
        public final Builder ruleArn(String ruleArn) {
            this.ruleArn = ruleArn;
            return this;
        }

        public final void setRuleArn(String ruleArn) {
            this.ruleArn = ruleArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteRuleRequest build() {
            return new DeleteRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteRuleRequest> {
        public Builder ruleArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

