/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Response;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthDescription;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthDescriptionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTargetHealthResponse
extends ElasticLoadBalancingV2Response
implements ToCopyableBuilder<Builder, DescribeTargetHealthResponse> {
    private static final SdkField<List<TargetHealthDescription>> TARGET_HEALTH_DESCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetHealthDescriptions").getter(DescribeTargetHealthResponse.getter(DescribeTargetHealthResponse::targetHealthDescriptions)).setter(DescribeTargetHealthResponse.setter(Builder::targetHealthDescriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetHealthDescriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TargetHealthDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_HEALTH_DESCRIPTIONS_FIELD));
    private final List<TargetHealthDescription> targetHealthDescriptions;

    private DescribeTargetHealthResponse(BuilderImpl builder) {
        super(builder);
        this.targetHealthDescriptions = builder.targetHealthDescriptions;
    }

    public final boolean hasTargetHealthDescriptions() {
        return this.targetHealthDescriptions != null && !(this.targetHealthDescriptions instanceof SdkAutoConstructList);
    }

    public final List<TargetHealthDescription> targetHealthDescriptions() {
        return this.targetHealthDescriptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetHealthDescriptions() ? this.targetHealthDescriptions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTargetHealthResponse)) {
            return false;
        }
        DescribeTargetHealthResponse other = (DescribeTargetHealthResponse)((Object)obj);
        return this.hasTargetHealthDescriptions() == other.hasTargetHealthDescriptions() && Objects.equals(this.targetHealthDescriptions(), other.targetHealthDescriptions());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeTargetHealthResponse").add("TargetHealthDescriptions", this.hasTargetHealthDescriptions() ? this.targetHealthDescriptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetHealthDescriptions": {
                return Optional.ofNullable(clazz.cast(this.targetHealthDescriptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTargetHealthResponse, T> g) {
        return obj -> g.apply((DescribeTargetHealthResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingV2Response.BuilderImpl
    implements Builder {
        private List<TargetHealthDescription> targetHealthDescriptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTargetHealthResponse model) {
            super(model);
            this.targetHealthDescriptions(model.targetHealthDescriptions);
        }

        public final List<TargetHealthDescription.Builder> getTargetHealthDescriptions() {
            List<TargetHealthDescription.Builder> result = TargetHealthDescriptionsCopier.copyToBuilder(this.targetHealthDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder targetHealthDescriptions(Collection<TargetHealthDescription> targetHealthDescriptions) {
            this.targetHealthDescriptions = TargetHealthDescriptionsCopier.copy(targetHealthDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetHealthDescriptions(TargetHealthDescription ... targetHealthDescriptions) {
            this.targetHealthDescriptions(Arrays.asList(targetHealthDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetHealthDescriptions(Consumer<TargetHealthDescription.Builder> ... targetHealthDescriptions) {
            this.targetHealthDescriptions(Stream.of(targetHealthDescriptions).map(c -> (TargetHealthDescription)((TargetHealthDescription.Builder)TargetHealthDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargetHealthDescriptions(Collection<TargetHealthDescription.BuilderImpl> targetHealthDescriptions) {
            this.targetHealthDescriptions = TargetHealthDescriptionsCopier.copyFromBuilder(targetHealthDescriptions);
        }

        @Override
        public DescribeTargetHealthResponse build() {
            return new DescribeTargetHealthResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTargetHealthResponse> {
        public Builder targetHealthDescriptions(Collection<TargetHealthDescription> var1);

        public Builder targetHealthDescriptions(TargetHealthDescription ... var1);

        public Builder targetHealthDescriptions(Consumer<TargetHealthDescription.Builder> ... var1);
    }
}

