/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TargetTypeEnum {
    INSTANCE("instance"),
    IP("ip"),
    LAMBDA("lambda"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TargetTypeEnum> VALUE_MAP;
    private final String value;

    private TargetTypeEnum(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TargetTypeEnum fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TargetTypeEnum> knownValues() {
        EnumSet<TargetTypeEnum> knownValues = EnumSet.allOf(TargetTypeEnum.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TargetTypeEnum.class, TargetTypeEnum::toString);
    }
}

