/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupListCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupStickinessConfig;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupTuple;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ForwardActionConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ForwardActionConfig> {
    private static final SdkField<List<TargetGroupTuple>> TARGET_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetGroups").getter(ForwardActionConfig.getter(ForwardActionConfig::targetGroups)).setter(ForwardActionConfig.setter(Builder::targetGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TargetGroupTuple::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TargetGroupStickinessConfig> TARGET_GROUP_STICKINESS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TargetGroupStickinessConfig").getter(ForwardActionConfig.getter(ForwardActionConfig::targetGroupStickinessConfig)).setter(ForwardActionConfig.setter(Builder::targetGroupStickinessConfig)).constructor(TargetGroupStickinessConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetGroupStickinessConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_GROUPS_FIELD, TARGET_GROUP_STICKINESS_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<TargetGroupTuple> targetGroups;
    private final TargetGroupStickinessConfig targetGroupStickinessConfig;

    private ForwardActionConfig(BuilderImpl builder) {
        this.targetGroups = builder.targetGroups;
        this.targetGroupStickinessConfig = builder.targetGroupStickinessConfig;
    }

    public final boolean hasTargetGroups() {
        return this.targetGroups != null && !(this.targetGroups instanceof SdkAutoConstructList);
    }

    public final List<TargetGroupTuple> targetGroups() {
        return this.targetGroups;
    }

    public final TargetGroupStickinessConfig targetGroupStickinessConfig() {
        return this.targetGroupStickinessConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetGroups() ? this.targetGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.targetGroupStickinessConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ForwardActionConfig)) {
            return false;
        }
        ForwardActionConfig other = (ForwardActionConfig)obj;
        return this.hasTargetGroups() == other.hasTargetGroups() && Objects.equals(this.targetGroups(), other.targetGroups()) && Objects.equals(this.targetGroupStickinessConfig(), other.targetGroupStickinessConfig());
    }

    public final String toString() {
        return ToString.builder((String)"ForwardActionConfig").add("TargetGroups", this.hasTargetGroups() ? this.targetGroups() : null).add("TargetGroupStickinessConfig", (Object)this.targetGroupStickinessConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetGroups": {
                return Optional.ofNullable(clazz.cast(this.targetGroups()));
            }
            case "TargetGroupStickinessConfig": {
                return Optional.ofNullable(clazz.cast(this.targetGroupStickinessConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ForwardActionConfig, T> g) {
        return obj -> g.apply((ForwardActionConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<TargetGroupTuple> targetGroups = DefaultSdkAutoConstructList.getInstance();
        private TargetGroupStickinessConfig targetGroupStickinessConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ForwardActionConfig model) {
            this.targetGroups(model.targetGroups);
            this.targetGroupStickinessConfig(model.targetGroupStickinessConfig);
        }

        public final List<TargetGroupTuple.Builder> getTargetGroups() {
            List<TargetGroupTuple.Builder> result = TargetGroupListCopier.copyToBuilder(this.targetGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder targetGroups(Collection<TargetGroupTuple> targetGroups) {
            this.targetGroups = TargetGroupListCopier.copy(targetGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroups(TargetGroupTuple ... targetGroups) {
            this.targetGroups(Arrays.asList(targetGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroups(Consumer<TargetGroupTuple.Builder> ... targetGroups) {
            this.targetGroups(Stream.of(targetGroups).map(c -> (TargetGroupTuple)((TargetGroupTuple.Builder)TargetGroupTuple.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargetGroups(Collection<TargetGroupTuple.BuilderImpl> targetGroups) {
            this.targetGroups = TargetGroupListCopier.copyFromBuilder(targetGroups);
        }

        public final TargetGroupStickinessConfig.Builder getTargetGroupStickinessConfig() {
            return this.targetGroupStickinessConfig != null ? this.targetGroupStickinessConfig.toBuilder() : null;
        }

        @Override
        public final Builder targetGroupStickinessConfig(TargetGroupStickinessConfig targetGroupStickinessConfig) {
            this.targetGroupStickinessConfig = targetGroupStickinessConfig;
            return this;
        }

        public final void setTargetGroupStickinessConfig(TargetGroupStickinessConfig.BuilderImpl targetGroupStickinessConfig) {
            this.targetGroupStickinessConfig = targetGroupStickinessConfig != null ? targetGroupStickinessConfig.build() : null;
        }

        public ForwardActionConfig build() {
            return new ForwardActionConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ForwardActionConfig> {
        public Builder targetGroups(Collection<TargetGroupTuple> var1);

        public Builder targetGroups(TargetGroupTuple ... var1);

        public Builder targetGroups(Consumer<TargetGroupTuple.Builder> ... var1);

        public Builder targetGroupStickinessConfig(TargetGroupStickinessConfig var1);

        default public Builder targetGroupStickinessConfig(Consumer<TargetGroupStickinessConfig.Builder> targetGroupStickinessConfig) {
            return this.targetGroupStickinessConfig((TargetGroupStickinessConfig)((TargetGroupStickinessConfig.Builder)TargetGroupStickinessConfig.builder().applyMutation(targetGroupStickinessConfig)).build());
        }
    }
}

