/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ListOfStringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HttpHeaderConditionConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HttpHeaderConditionConfig> {
    private static final SdkField<String> HTTP_HEADER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HttpHeaderName").getter(HttpHeaderConditionConfig.getter(HttpHeaderConditionConfig::httpHeaderName)).setter(HttpHeaderConditionConfig.setter(Builder::httpHeaderName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpHeaderName").build()}).build();
    private static final SdkField<List<String>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Values").getter(HttpHeaderConditionConfig.getter(HttpHeaderConditionConfig::values)).setter(HttpHeaderConditionConfig.setter(Builder::values)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HTTP_HEADER_NAME_FIELD, VALUES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String httpHeaderName;
    private final List<String> values;

    private HttpHeaderConditionConfig(BuilderImpl builder) {
        this.httpHeaderName = builder.httpHeaderName;
        this.values = builder.values;
    }

    public final String httpHeaderName() {
        return this.httpHeaderName;
    }

    public final boolean hasValues() {
        return this.values != null && !(this.values instanceof SdkAutoConstructList);
    }

    public final List<String> values() {
        return this.values;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.httpHeaderName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValues() ? this.values() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpHeaderConditionConfig)) {
            return false;
        }
        HttpHeaderConditionConfig other = (HttpHeaderConditionConfig)obj;
        return Objects.equals(this.httpHeaderName(), other.httpHeaderName()) && this.hasValues() == other.hasValues() && Objects.equals(this.values(), other.values());
    }

    public final String toString() {
        return ToString.builder((String)"HttpHeaderConditionConfig").add("HttpHeaderName", (Object)this.httpHeaderName()).add("Values", this.hasValues() ? this.values() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HttpHeaderName": {
                return Optional.ofNullable(clazz.cast(this.httpHeaderName()));
            }
            case "Values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HttpHeaderConditionConfig, T> g) {
        return obj -> g.apply((HttpHeaderConditionConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String httpHeaderName;
        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HttpHeaderConditionConfig model) {
            this.httpHeaderName(model.httpHeaderName);
            this.values(model.values);
        }

        public final String getHttpHeaderName() {
            return this.httpHeaderName;
        }

        @Override
        public final Builder httpHeaderName(String httpHeaderName) {
            this.httpHeaderName = httpHeaderName;
            return this;
        }

        public final void setHttpHeaderName(String httpHeaderName) {
            this.httpHeaderName = httpHeaderName;
        }

        public final Collection<String> getValues() {
            if (this.values instanceof SdkAutoConstructList) {
                return null;
            }
            return this.values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = ListOfStringCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = ListOfStringCopier.copy(values);
        }

        public HttpHeaderConditionConfig build() {
            return new HttpHeaderConditionConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HttpHeaderConditionConfig> {
        public Builder httpHeaderName(String var1);

        public Builder values(Collection<String> var1);

        public Builder values(String ... var1);
    }
}

