/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Request;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ResourceArnsCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TagKeysCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RemoveTagsRequest
extends ElasticLoadBalancingV2Request
implements ToCopyableBuilder<Builder, RemoveTagsRequest> {
    private static final SdkField<List<String>> RESOURCE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceArns").getter(RemoveTagsRequest.getter(RemoveTagsRequest::resourceArns)).setter(RemoveTagsRequest.setter(Builder::resourceArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TAG_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagKeys").getter(RemoveTagsRequest.getter(RemoveTagsRequest::tagKeys)).setter(RemoveTagsRequest.setter(Builder::tagKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARNS_FIELD, TAG_KEYS_FIELD));
    private final List<String> resourceArns;
    private final List<String> tagKeys;

    private RemoveTagsRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArns = builder.resourceArns;
        this.tagKeys = builder.tagKeys;
    }

    public boolean hasResourceArns() {
        return this.resourceArns != null && !(this.resourceArns instanceof SdkAutoConstructList);
    }

    public List<String> resourceArns() {
        return this.resourceArns;
    }

    public boolean hasTagKeys() {
        return this.tagKeys != null && !(this.tagKeys instanceof SdkAutoConstructList);
    }

    public List<String> tagKeys() {
        return this.tagKeys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArns());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagKeys());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveTagsRequest)) {
            return false;
        }
        RemoveTagsRequest other = (RemoveTagsRequest)((Object)obj);
        return Objects.equals(this.resourceArns(), other.resourceArns()) && Objects.equals(this.tagKeys(), other.tagKeys());
    }

    public String toString() {
        return ToString.builder((String)"RemoveTagsRequest").add("ResourceArns", this.resourceArns()).add("TagKeys", this.tagKeys()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceArns": {
                return Optional.ofNullable(clazz.cast(this.resourceArns()));
            }
            case "TagKeys": {
                return Optional.ofNullable(clazz.cast(this.tagKeys()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemoveTagsRequest, T> g) {
        return obj -> g.apply((RemoveTagsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingV2Request.BuilderImpl
    implements Builder {
        private List<String> resourceArns = DefaultSdkAutoConstructList.getInstance();
        private List<String> tagKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveTagsRequest model) {
            super(model);
            this.resourceArns(model.resourceArns);
            this.tagKeys(model.tagKeys);
        }

        public final Collection<String> getResourceArns() {
            return this.resourceArns;
        }

        @Override
        public final Builder resourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceArnsCopier.copy(resourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceArns(String ... resourceArns) {
            this.resourceArns(Arrays.asList(resourceArns));
            return this;
        }

        public final void setResourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceArnsCopier.copy(resourceArns);
        }

        public final Collection<String> getTagKeys() {
            return this.tagKeys;
        }

        @Override
        public final Builder tagKeys(Collection<String> tagKeys) {
            this.tagKeys = TagKeysCopier.copy(tagKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagKeys(String ... tagKeys) {
            this.tagKeys(Arrays.asList(tagKeys));
            return this;
        }

        public final void setTagKeys(Collection<String> tagKeys) {
            this.tagKeys = TagKeysCopier.copy(tagKeys);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RemoveTagsRequest build() {
            return new RemoveTagsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RemoveTagsRequest> {
        public Builder resourceArns(Collection<String> var1);

        public Builder resourceArns(String ... var1);

        public Builder tagKeys(Collection<String> var1);

        public Builder tagKeys(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

