/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Response;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TagDescription;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TagDescriptionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTagsResponse
extends ElasticLoadBalancingV2Response
implements ToCopyableBuilder<Builder, DescribeTagsResponse> {
    private static final SdkField<List<TagDescription>> TAG_DESCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeTagsResponse.getter(DescribeTagsResponse::tagDescriptions)).setter(DescribeTagsResponse.setter(Builder::tagDescriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagDescriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAG_DESCRIPTIONS_FIELD));
    private final List<TagDescription> tagDescriptions;

    private DescribeTagsResponse(BuilderImpl builder) {
        super(builder);
        this.tagDescriptions = builder.tagDescriptions;
    }

    public boolean hasTagDescriptions() {
        return this.tagDescriptions != null && !(this.tagDescriptions instanceof SdkAutoConstructList);
    }

    public List<TagDescription> tagDescriptions() {
        return this.tagDescriptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.tagDescriptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTagsResponse)) {
            return false;
        }
        DescribeTagsResponse other = (DescribeTagsResponse)((Object)obj);
        return Objects.equals(this.tagDescriptions(), other.tagDescriptions());
    }

    public String toString() {
        return ToString.builder((String)"DescribeTagsResponse").add("TagDescriptions", this.tagDescriptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TagDescriptions": {
                return Optional.ofNullable(clazz.cast(this.tagDescriptions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTagsResponse, T> g) {
        return obj -> g.apply((DescribeTagsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingV2Response.BuilderImpl
    implements Builder {
        private List<TagDescription> tagDescriptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTagsResponse model) {
            super(model);
            this.tagDescriptions(model.tagDescriptions);
        }

        public final Collection<TagDescription.Builder> getTagDescriptions() {
            return this.tagDescriptions != null ? (Collection)this.tagDescriptions.stream().map(TagDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagDescriptions(Collection<TagDescription> tagDescriptions) {
            this.tagDescriptions = TagDescriptionsCopier.copy(tagDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagDescriptions(TagDescription ... tagDescriptions) {
            this.tagDescriptions(Arrays.asList(tagDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagDescriptions(Consumer<TagDescription.Builder> ... tagDescriptions) {
            this.tagDescriptions(Stream.of(tagDescriptions).map(c -> (TagDescription)((TagDescription.Builder)TagDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTagDescriptions(Collection<TagDescription.BuilderImpl> tagDescriptions) {
            this.tagDescriptions = TagDescriptionsCopier.copyFromBuilder(tagDescriptions);
        }

        @Override
        public DescribeTagsResponse build() {
            return new DescribeTagsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTagsResponse> {
        public Builder tagDescriptions(Collection<TagDescription> var1);

        public Builder tagDescriptions(TagDescription ... var1);

        public Builder tagDescriptions(Consumer<TagDescription.Builder> ... var1);
    }
}

