/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.services.elasticloadbalancingv2.ElasticLoadBalancingV2Client;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AddListenerCertificatesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AddListenerCertificatesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AddTagsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AddTagsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AllocationIdNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AvailabilityZoneNotSupportedException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CertificateNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateListenerRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateListenerResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateRuleRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateRuleResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateTargetGroupRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateTargetGroupResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteListenerRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteListenerResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteRuleRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteRuleResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteTargetGroupRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteTargetGroupResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeregisterTargetsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeregisterTargetsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeAccountLimitsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeAccountLimitsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenerCertificatesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenerCertificatesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeSslPoliciesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeSslPoliciesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTagsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTagsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupAttributesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupAttributesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetHealthRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetHealthResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DuplicateListenerException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DuplicateLoadBalancerNameException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DuplicateTagKeysException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DuplicateTargetGroupNameException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Exception;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Request;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.HealthUnavailableException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.IncompatibleProtocolsException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.InvalidConfigurationRequestException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.InvalidLoadBalancerActionException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.InvalidSchemeException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.InvalidSecurityGroupException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.InvalidSubnetException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.InvalidTargetException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ListenerNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyListenerRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyListenerResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyRuleRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyRuleResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupAttributesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupAttributesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.OperationNotPermittedException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.PriorityInUseException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RegisterTargetsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RegisterTargetsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveListenerCertificatesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveListenerCertificatesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveTagsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveTagsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ResourceInUseException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RuleNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetIpAddressTypeRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetIpAddressTypeResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetRulePrioritiesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetRulePrioritiesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSecurityGroupsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSecurityGroupsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSubnetsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSubnetsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SslPolicyNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SubnetNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupAssociationLimitException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyActionsException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyCertificatesException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyListenersException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyLoadBalancersException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyRegistrationsForTargetIdException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyRulesException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyTagsException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyTargetGroupsException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyTargetsException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyUniqueTargetGroupsPerLoadBalancerException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.UnsupportedProtocolException;
import software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeListenersIterable;
import software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeLoadBalancersIterable;
import software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeTargetGroupsIterable;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.AddListenerCertificatesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.AddTagsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.CreateListenerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.CreateLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.CreateRuleRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.CreateTargetGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DeleteListenerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DeleteLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DeleteRuleRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DeleteTargetGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DeregisterTargetsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeAccountLimitsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeListenerCertificatesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeListenersRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeLoadBalancerAttributesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeLoadBalancersRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeRulesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeSslPoliciesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeTagsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeTargetGroupAttributesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeTargetGroupsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeTargetHealthRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.ModifyListenerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.ModifyLoadBalancerAttributesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.ModifyRuleRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.ModifyTargetGroupAttributesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.ModifyTargetGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.RegisterTargetsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.RemoveListenerCertificatesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.RemoveTagsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.SetIpAddressTypeRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.SetRulePrioritiesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.SetSecurityGroupsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.SetSubnetsRequestMarshaller;

@SdkInternalApi
final class DefaultElasticLoadBalancingV2Client
implements ElasticLoadBalancingV2Client {
    private final SyncClientHandler clientHandler;
    private final AwsQueryProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultElasticLoadBalancingV2Client(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init();
    }

    public final String serviceName() {
        return "elasticloadbalancing";
    }

    @Override
    public AddListenerCertificatesResponse addListenerCertificates(AddListenerCertificatesRequest addListenerCertificatesRequest) throws ListenerNotFoundException, TooManyCertificatesException, CertificateNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AddListenerCertificatesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (AddListenerCertificatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddListenerCertificates").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addListenerCertificatesRequest).withMarshaller((Marshaller)new AddListenerCertificatesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public AddTagsResponse addTags(AddTagsRequest addTagsRequest) throws DuplicateTagKeysException, TooManyTagsException, LoadBalancerNotFoundException, TargetGroupNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AddTagsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (AddTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addTagsRequest).withMarshaller((Marshaller)new AddTagsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateListenerResponse createListener(CreateListenerRequest createListenerRequest) throws DuplicateListenerException, TooManyListenersException, TooManyCertificatesException, LoadBalancerNotFoundException, TargetGroupNotFoundException, TargetGroupAssociationLimitException, InvalidConfigurationRequestException, IncompatibleProtocolsException, SslPolicyNotFoundException, CertificateNotFoundException, UnsupportedProtocolException, TooManyRegistrationsForTargetIdException, TooManyTargetsException, TooManyActionsException, InvalidLoadBalancerActionException, TooManyUniqueTargetGroupsPerLoadBalancerException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateListenerResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateListenerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateListener").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createListenerRequest).withMarshaller((Marshaller)new CreateListenerRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateLoadBalancerResponse createLoadBalancer(CreateLoadBalancerRequest createLoadBalancerRequest) throws DuplicateLoadBalancerNameException, TooManyLoadBalancersException, InvalidConfigurationRequestException, SubnetNotFoundException, InvalidSubnetException, InvalidSecurityGroupException, InvalidSchemeException, TooManyTagsException, DuplicateTagKeysException, ResourceInUseException, AllocationIdNotFoundException, AvailabilityZoneNotSupportedException, OperationNotPermittedException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateLoadBalancerResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateLoadBalancerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLoadBalancer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createLoadBalancerRequest).withMarshaller((Marshaller)new CreateLoadBalancerRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateRuleResponse createRule(CreateRuleRequest createRuleRequest) throws PriorityInUseException, TooManyTargetGroupsException, TooManyRulesException, TargetGroupAssociationLimitException, IncompatibleProtocolsException, ListenerNotFoundException, TargetGroupNotFoundException, InvalidConfigurationRequestException, TooManyRegistrationsForTargetIdException, TooManyTargetsException, UnsupportedProtocolException, TooManyActionsException, InvalidLoadBalancerActionException, TooManyUniqueTargetGroupsPerLoadBalancerException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateRuleResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRule").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createRuleRequest).withMarshaller((Marshaller)new CreateRuleRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateTargetGroupResponse createTargetGroup(CreateTargetGroupRequest createTargetGroupRequest) throws DuplicateTargetGroupNameException, TooManyTargetGroupsException, InvalidConfigurationRequestException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateTargetGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateTargetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTargetGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createTargetGroupRequest).withMarshaller((Marshaller)new CreateTargetGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteListenerResponse deleteListener(DeleteListenerRequest deleteListenerRequest) throws ListenerNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteListenerResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteListenerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteListener").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteListenerRequest).withMarshaller((Marshaller)new DeleteListenerRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteLoadBalancerResponse deleteLoadBalancer(DeleteLoadBalancerRequest deleteLoadBalancerRequest) throws LoadBalancerNotFoundException, OperationNotPermittedException, ResourceInUseException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteLoadBalancerResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteLoadBalancerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLoadBalancer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteLoadBalancerRequest).withMarshaller((Marshaller)new DeleteLoadBalancerRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteRuleResponse deleteRule(DeleteRuleRequest deleteRuleRequest) throws RuleNotFoundException, OperationNotPermittedException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteRuleResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRule").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteRuleRequest).withMarshaller((Marshaller)new DeleteRuleRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteTargetGroupResponse deleteTargetGroup(DeleteTargetGroupRequest deleteTargetGroupRequest) throws ResourceInUseException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteTargetGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteTargetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTargetGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteTargetGroupRequest).withMarshaller((Marshaller)new DeleteTargetGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeregisterTargetsResponse deregisterTargets(DeregisterTargetsRequest deregisterTargetsRequest) throws TargetGroupNotFoundException, InvalidTargetException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeregisterTargetsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeregisterTargetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterTargets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deregisterTargetsRequest).withMarshaller((Marshaller)new DeregisterTargetsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeAccountLimitsResponse describeAccountLimits(DescribeAccountLimitsRequest describeAccountLimitsRequest) throws AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeAccountLimitsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeAccountLimitsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAccountLimits").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAccountLimitsRequest).withMarshaller((Marshaller)new DescribeAccountLimitsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeListenerCertificatesResponse describeListenerCertificates(DescribeListenerCertificatesRequest describeListenerCertificatesRequest) throws ListenerNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeListenerCertificatesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeListenerCertificatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeListenerCertificates").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeListenerCertificatesRequest).withMarshaller((Marshaller)new DescribeListenerCertificatesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeListenersResponse describeListeners(DescribeListenersRequest describeListenersRequest) throws ListenerNotFoundException, LoadBalancerNotFoundException, UnsupportedProtocolException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeListenersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeListenersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeListeners").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeListenersRequest).withMarshaller((Marshaller)new DescribeListenersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeListenersIterable describeListenersPaginator(DescribeListenersRequest describeListenersRequest) throws ListenerNotFoundException, LoadBalancerNotFoundException, UnsupportedProtocolException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        return new DescribeListenersIterable(this, this.applyPaginatorUserAgent(describeListenersRequest));
    }

    @Override
    public DescribeLoadBalancerAttributesResponse describeLoadBalancerAttributes(DescribeLoadBalancerAttributesRequest describeLoadBalancerAttributesRequest) throws LoadBalancerNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeLoadBalancerAttributesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeLoadBalancerAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLoadBalancerAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeLoadBalancerAttributesRequest).withMarshaller((Marshaller)new DescribeLoadBalancerAttributesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeLoadBalancersResponse describeLoadBalancers(DescribeLoadBalancersRequest describeLoadBalancersRequest) throws LoadBalancerNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeLoadBalancersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeLoadBalancersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLoadBalancers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeLoadBalancersRequest).withMarshaller((Marshaller)new DescribeLoadBalancersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeLoadBalancersIterable describeLoadBalancersPaginator(DescribeLoadBalancersRequest describeLoadBalancersRequest) throws LoadBalancerNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        return new DescribeLoadBalancersIterable(this, this.applyPaginatorUserAgent(describeLoadBalancersRequest));
    }

    @Override
    public DescribeRulesResponse describeRules(DescribeRulesRequest describeRulesRequest) throws ListenerNotFoundException, RuleNotFoundException, UnsupportedProtocolException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeRulesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeRulesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRules").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeRulesRequest).withMarshaller((Marshaller)new DescribeRulesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeSslPoliciesResponse describeSSLPolicies(DescribeSslPoliciesRequest describeSslPoliciesRequest) throws SslPolicyNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeSslPoliciesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeSslPoliciesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSSLPolicies").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeSslPoliciesRequest).withMarshaller((Marshaller)new DescribeSslPoliciesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeTagsResponse describeTags(DescribeTagsRequest describeTagsRequest) throws LoadBalancerNotFoundException, TargetGroupNotFoundException, ListenerNotFoundException, RuleNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeTagsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeTagsRequest).withMarshaller((Marshaller)new DescribeTagsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeTargetGroupAttributesResponse describeTargetGroupAttributes(DescribeTargetGroupAttributesRequest describeTargetGroupAttributesRequest) throws TargetGroupNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeTargetGroupAttributesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeTargetGroupAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTargetGroupAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeTargetGroupAttributesRequest).withMarshaller((Marshaller)new DescribeTargetGroupAttributesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeTargetGroupsResponse describeTargetGroups(DescribeTargetGroupsRequest describeTargetGroupsRequest) throws LoadBalancerNotFoundException, TargetGroupNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeTargetGroupsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeTargetGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTargetGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeTargetGroupsRequest).withMarshaller((Marshaller)new DescribeTargetGroupsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeTargetGroupsIterable describeTargetGroupsPaginator(DescribeTargetGroupsRequest describeTargetGroupsRequest) throws LoadBalancerNotFoundException, TargetGroupNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        return new DescribeTargetGroupsIterable(this, this.applyPaginatorUserAgent(describeTargetGroupsRequest));
    }

    @Override
    public DescribeTargetHealthResponse describeTargetHealth(DescribeTargetHealthRequest describeTargetHealthRequest) throws InvalidTargetException, TargetGroupNotFoundException, HealthUnavailableException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeTargetHealthResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeTargetHealthResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTargetHealth").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeTargetHealthRequest).withMarshaller((Marshaller)new DescribeTargetHealthRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ModifyListenerResponse modifyListener(ModifyListenerRequest modifyListenerRequest) throws DuplicateListenerException, TooManyListenersException, TooManyCertificatesException, ListenerNotFoundException, TargetGroupNotFoundException, TargetGroupAssociationLimitException, IncompatibleProtocolsException, SslPolicyNotFoundException, CertificateNotFoundException, InvalidConfigurationRequestException, UnsupportedProtocolException, TooManyRegistrationsForTargetIdException, TooManyTargetsException, TooManyActionsException, InvalidLoadBalancerActionException, TooManyUniqueTargetGroupsPerLoadBalancerException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyListenerResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ModifyListenerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyListener").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyListenerRequest).withMarshaller((Marshaller)new ModifyListenerRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ModifyLoadBalancerAttributesResponse modifyLoadBalancerAttributes(ModifyLoadBalancerAttributesRequest modifyLoadBalancerAttributesRequest) throws LoadBalancerNotFoundException, InvalidConfigurationRequestException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyLoadBalancerAttributesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ModifyLoadBalancerAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyLoadBalancerAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyLoadBalancerAttributesRequest).withMarshaller((Marshaller)new ModifyLoadBalancerAttributesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ModifyRuleResponse modifyRule(ModifyRuleRequest modifyRuleRequest) throws TargetGroupAssociationLimitException, IncompatibleProtocolsException, RuleNotFoundException, OperationNotPermittedException, TooManyRegistrationsForTargetIdException, TooManyTargetsException, TargetGroupNotFoundException, UnsupportedProtocolException, TooManyActionsException, InvalidLoadBalancerActionException, TooManyUniqueTargetGroupsPerLoadBalancerException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyRuleResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ModifyRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyRule").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyRuleRequest).withMarshaller((Marshaller)new ModifyRuleRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ModifyTargetGroupResponse modifyTargetGroup(ModifyTargetGroupRequest modifyTargetGroupRequest) throws TargetGroupNotFoundException, InvalidConfigurationRequestException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyTargetGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ModifyTargetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyTargetGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyTargetGroupRequest).withMarshaller((Marshaller)new ModifyTargetGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ModifyTargetGroupAttributesResponse modifyTargetGroupAttributes(ModifyTargetGroupAttributesRequest modifyTargetGroupAttributesRequest) throws TargetGroupNotFoundException, InvalidConfigurationRequestException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyTargetGroupAttributesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ModifyTargetGroupAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyTargetGroupAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyTargetGroupAttributesRequest).withMarshaller((Marshaller)new ModifyTargetGroupAttributesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RegisterTargetsResponse registerTargets(RegisterTargetsRequest registerTargetsRequest) throws TargetGroupNotFoundException, TooManyTargetsException, InvalidTargetException, TooManyRegistrationsForTargetIdException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RegisterTargetsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (RegisterTargetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterTargets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)registerTargetsRequest).withMarshaller((Marshaller)new RegisterTargetsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RemoveListenerCertificatesResponse removeListenerCertificates(RemoveListenerCertificatesRequest removeListenerCertificatesRequest) throws ListenerNotFoundException, OperationNotPermittedException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RemoveListenerCertificatesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (RemoveListenerCertificatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveListenerCertificates").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removeListenerCertificatesRequest).withMarshaller((Marshaller)new RemoveListenerCertificatesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RemoveTagsResponse removeTags(RemoveTagsRequest removeTagsRequest) throws LoadBalancerNotFoundException, TargetGroupNotFoundException, ListenerNotFoundException, RuleNotFoundException, TooManyTagsException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RemoveTagsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (RemoveTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removeTagsRequest).withMarshaller((Marshaller)new RemoveTagsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SetIpAddressTypeResponse setIpAddressType(SetIpAddressTypeRequest setIpAddressTypeRequest) throws LoadBalancerNotFoundException, InvalidConfigurationRequestException, InvalidSubnetException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetIpAddressTypeResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (SetIpAddressTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetIpAddressType").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setIpAddressTypeRequest).withMarshaller((Marshaller)new SetIpAddressTypeRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SetRulePrioritiesResponse setRulePriorities(SetRulePrioritiesRequest setRulePrioritiesRequest) throws RuleNotFoundException, PriorityInUseException, OperationNotPermittedException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetRulePrioritiesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (SetRulePrioritiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetRulePriorities").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setRulePrioritiesRequest).withMarshaller((Marshaller)new SetRulePrioritiesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SetSecurityGroupsResponse setSecurityGroups(SetSecurityGroupsRequest setSecurityGroupsRequest) throws LoadBalancerNotFoundException, InvalidConfigurationRequestException, InvalidSecurityGroupException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetSecurityGroupsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (SetSecurityGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetSecurityGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setSecurityGroupsRequest).withMarshaller((Marshaller)new SetSecurityGroupsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SetSubnetsResponse setSubnets(SetSubnetsRequest setSubnetsRequest) throws LoadBalancerNotFoundException, InvalidConfigurationRequestException, SubnetNotFoundException, InvalidSubnetException, AllocationIdNotFoundException, AvailabilityZoneNotSupportedException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetSubnetsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (SetSubnetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetSubnets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setSubnetsRequest).withMarshaller((Marshaller)new SetSubnetsRequestMarshaller(this.protocolFactory)));
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedProtocol").exceptionBuilderSupplier(UnsupportedProtocolException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyUniqueTargetGroupsPerLoadBalancer").exceptionBuilderSupplier(TooManyUniqueTargetGroupsPerLoadBalancerException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AllocationIdNotFound").exceptionBuilderSupplier(AllocationIdNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceInUse").exceptionBuilderSupplier(ResourceInUseException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicateTargetGroupName").exceptionBuilderSupplier(DuplicateTargetGroupNameException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyRules").exceptionBuilderSupplier(TooManyRulesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyCertificates").exceptionBuilderSupplier(TooManyCertificatesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LoadBalancerNotFound").exceptionBuilderSupplier(LoadBalancerNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTargetGroups").exceptionBuilderSupplier(TooManyTargetGroupsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyLoadBalancers").exceptionBuilderSupplier(TooManyLoadBalancersException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidConfigurationRequest").exceptionBuilderSupplier(InvalidConfigurationRequestException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TargetGroupAssociationLimit").exceptionBuilderSupplier(TargetGroupAssociationLimitException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSecurityGroup").exceptionBuilderSupplier(InvalidSecurityGroupException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IncompatibleProtocols").exceptionBuilderSupplier(IncompatibleProtocolsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyActions").exceptionBuilderSupplier(TooManyActionsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyListeners").exceptionBuilderSupplier(TooManyListenersException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicateLoadBalancerName").exceptionBuilderSupplier(DuplicateLoadBalancerNameException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OperationNotPermitted").exceptionBuilderSupplier(OperationNotPermittedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerAction").exceptionBuilderSupplier(InvalidLoadBalancerActionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CertificateNotFound").exceptionBuilderSupplier(CertificateNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicateTagKeys").exceptionBuilderSupplier(DuplicateTagKeysException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTags").exceptionBuilderSupplier(TooManyTagsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TargetGroupNotFound").exceptionBuilderSupplier(TargetGroupNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyRegistrationsForTargetId").exceptionBuilderSupplier(TooManyRegistrationsForTargetIdException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ListenerNotFound").exceptionBuilderSupplier(ListenerNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PriorityInUse").exceptionBuilderSupplier(PriorityInUseException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTarget").exceptionBuilderSupplier(InvalidTargetException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SubnetNotFound").exceptionBuilderSupplier(SubnetNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AvailabilityZoneNotSupported").exceptionBuilderSupplier(AvailabilityZoneNotSupportedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RuleNotFound").exceptionBuilderSupplier(RuleNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SSLPolicyNotFound").exceptionBuilderSupplier(SslPolicyNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicateListener").exceptionBuilderSupplier(DuplicateListenerException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidScheme").exceptionBuilderSupplier(InvalidSchemeException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HealthUnavailable").exceptionBuilderSupplier(HealthUnavailableException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSubnet").exceptionBuilderSupplier(InvalidSubnetException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTargets").exceptionBuilderSupplier(TooManyTargetsException::builder).httpStatusCode(Integer.valueOf(400)).build()).clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(ElasticLoadBalancingV2Exception::builder).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends ElasticLoadBalancingV2Request> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.11.13").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((ElasticLoadBalancingV2Request)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

