/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeTargetGroupsRequestMarshaller
implements Marshaller<Request<DescribeTargetGroupsRequest>, DescribeTargetGroupsRequest> {
    public Request<DescribeTargetGroupsRequest> marshall(DescribeTargetGroupsRequest describeTargetGroupsRequest) {
        List<String> namesList;
        List<String> targetGroupArnsList;
        if (describeTargetGroupsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeTargetGroupsRequest, "ElasticLoadBalancingv2Client");
        request.addParameter("Action", "DescribeTargetGroups");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeTargetGroupsRequest.loadBalancerArn() != null) {
            request.addParameter("LoadBalancerArn", StringUtils.fromString((String)describeTargetGroupsRequest.loadBalancerArn()));
        }
        if ((targetGroupArnsList = describeTargetGroupsRequest.targetGroupArns()) != null) {
            if (!targetGroupArnsList.isEmpty()) {
                int targetGroupArnsListIndex = 1;
                for (String targetGroupArnsListValue : targetGroupArnsList) {
                    if (targetGroupArnsListValue != null) {
                        request.addParameter("TargetGroupArns.member." + targetGroupArnsListIndex, StringUtils.fromString((String)targetGroupArnsListValue));
                    }
                    ++targetGroupArnsListIndex;
                }
            } else {
                request.addParameter("TargetGroupArns", "");
            }
        }
        if ((namesList = describeTargetGroupsRequest.names()) != null) {
            if (!namesList.isEmpty()) {
                int namesListIndex = 1;
                for (String namesListValue : namesList) {
                    if (namesListValue != null) {
                        request.addParameter("Names.member." + namesListIndex, StringUtils.fromString((String)namesListValue));
                    }
                    ++namesListIndex;
                }
            } else {
                request.addParameter("Names", "");
            }
        }
        if (describeTargetGroupsRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeTargetGroupsRequest.marker()));
        }
        if (describeTargetGroupsRequest.pageSize() != null) {
            request.addParameter("PageSize", StringUtils.fromInteger((Integer)describeTargetGroupsRequest.pageSize()));
        }
        return request;
    }
}

