/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroup;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyTargetGroupResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ModifyTargetGroupResponse> {
    private final List<TargetGroup> targetGroups;

    private ModifyTargetGroupResponse(BuilderImpl builder) {
        this.targetGroups = builder.targetGroups;
    }

    public List<TargetGroup> targetGroups() {
        return this.targetGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.targetGroups() == null ? 0 : this.targetGroups().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyTargetGroupResponse)) {
            return false;
        }
        ModifyTargetGroupResponse other = (ModifyTargetGroupResponse)((Object)obj);
        if (other.targetGroups() == null ^ this.targetGroups() == null) {
            return false;
        }
        return other.targetGroups() == null || other.targetGroups().equals(this.targetGroups());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.targetGroups() != null) {
            sb.append("TargetGroups: ").append(this.targetGroups()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<TargetGroup> targetGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyTargetGroupResponse model) {
            this.setTargetGroups(model.targetGroups);
        }

        public final Collection<TargetGroup> getTargetGroups() {
            return this.targetGroups;
        }

        @Override
        public final Builder targetGroups(Collection<TargetGroup> targetGroups) {
            this.targetGroups = TargetGroupsCopier.copy(targetGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroups(TargetGroup ... targetGroups) {
            this.targetGroups(Arrays.asList(targetGroups));
            return this;
        }

        public final void setTargetGroups(Collection<TargetGroup> targetGroups) {
            this.targetGroups = TargetGroupsCopier.copy(targetGroups);
        }

        public ModifyTargetGroupResponse build() {
            return new ModifyTargetGroupResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ModifyTargetGroupResponse> {
        public Builder targetGroups(Collection<TargetGroup> var1);

        public Builder targetGroups(TargetGroup ... var1);
    }
}

