/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Cipher
implements ToCopyableBuilder<Builder, Cipher> {
    private final String name;
    private final Integer priority;

    private Cipher(BuilderImpl builder) {
        this.name = builder.name;
        this.priority = builder.priority;
    }

    public String name() {
        return this.name;
    }

    public Integer priority() {
        return this.priority;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.priority() == null ? 0 : this.priority().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cipher)) {
            return false;
        }
        Cipher other = (Cipher)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.priority() == null ^ this.priority() == null) {
            return false;
        }
        return other.priority() == null || other.priority().equals(this.priority());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.priority() != null) {
            sb.append("Priority: ").append(this.priority()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private Integer priority;

        private BuilderImpl() {
        }

        private BuilderImpl(Cipher model) {
            this.setName(model.name);
            this.setPriority(model.priority);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public Cipher build() {
            return new Cipher(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Cipher> {
        public Builder name(String var1);

        public Builder priority(Integer var1);
    }
}

