/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancing.model.ElasticLoadBalancingRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.Instance;
import software.amazon.awssdk.services.elasticloadbalancing.model.InstancesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeregisterInstancesFromLoadBalancerRequest
extends ElasticLoadBalancingRequest
implements ToCopyableBuilder<Builder, DeregisterInstancesFromLoadBalancerRequest> {
    private static final SdkField<String> LOAD_BALANCER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeregisterInstancesFromLoadBalancerRequest.getter(DeregisterInstancesFromLoadBalancerRequest::loadBalancerName)).setter(DeregisterInstancesFromLoadBalancerRequest.setter(Builder::loadBalancerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerName").build()}).build();
    private static final SdkField<List<Instance>> INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DeregisterInstancesFromLoadBalancerRequest.getter(DeregisterInstancesFromLoadBalancerRequest::instances)).setter(DeregisterInstancesFromLoadBalancerRequest.setter(Builder::instances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Instances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Instance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_NAME_FIELD, INSTANCES_FIELD));
    private final String loadBalancerName;
    private final List<Instance> instances;

    private DeregisterInstancesFromLoadBalancerRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerName = builder.loadBalancerName;
        this.instances = builder.instances;
    }

    public String loadBalancerName() {
        return this.loadBalancerName;
    }

    public List<Instance> instances() {
        return this.instances;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.instances());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeregisterInstancesFromLoadBalancerRequest)) {
            return false;
        }
        DeregisterInstancesFromLoadBalancerRequest other = (DeregisterInstancesFromLoadBalancerRequest)((Object)obj);
        return Objects.equals(this.loadBalancerName(), other.loadBalancerName()) && Objects.equals(this.instances(), other.instances());
    }

    public String toString() {
        return ToString.builder((String)"DeregisterInstancesFromLoadBalancerRequest").add("LoadBalancerName", (Object)this.loadBalancerName()).add("Instances", this.instances()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoadBalancerName": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerName()));
            }
            case "Instances": {
                return Optional.ofNullable(clazz.cast(this.instances()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeregisterInstancesFromLoadBalancerRequest, T> g) {
        return obj -> g.apply((DeregisterInstancesFromLoadBalancerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingRequest.BuilderImpl
    implements Builder {
        private String loadBalancerName;
        private List<Instance> instances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeregisterInstancesFromLoadBalancerRequest model) {
            super(model);
            this.loadBalancerName(model.loadBalancerName);
            this.instances(model.instances);
        }

        public final String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        public final Collection<Instance.Builder> getInstances() {
            return this.instances != null ? (Collection)this.instances.stream().map(Instance::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instances(Collection<Instance> instances) {
            this.instances = InstancesCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Instance ... instances) {
            this.instances(Arrays.asList(instances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Consumer<Instance.Builder> ... instances) {
            this.instances(Stream.of(instances).map(c -> (Instance)((Instance.Builder)Instance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstances(Collection<Instance.BuilderImpl> instances) {
            this.instances = InstancesCopier.copyFromBuilder(instances);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeregisterInstancesFromLoadBalancerRequest build() {
            return new DeregisterInstancesFromLoadBalancerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeregisterInstancesFromLoadBalancerRequest> {
        public Builder loadBalancerName(String var1);

        public Builder instances(Collection<Instance> var1);

        public Builder instances(Instance ... var1);

        public Builder instances(Consumer<Instance.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

