/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.services.elasticloadbalancing.ElasticLoadBalancingAsyncClient;
import software.amazon.awssdk.services.elasticloadbalancing.model.AddTagsRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.AddTagsResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.AttachLoadBalancerToSubnetsRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.AttachLoadBalancerToSubnetsResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.CertificateNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancing.model.ConfigureHealthCheckRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.ConfigureHealthCheckResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateAppCookieStickinessPolicyRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateAppCookieStickinessPolicyResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateLbCookieStickinessPolicyRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateLbCookieStickinessPolicyResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerListenersRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerListenersResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerPolicyRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerPolicyResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerListenersRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerListenersResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerPolicyRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerPolicyResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DependencyThrottleException;
import software.amazon.awssdk.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeAccountLimitsRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeAccountLimitsResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeInstanceHealthRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeInstanceHealthResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerAttributesRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerAttributesResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerPoliciesRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerPoliciesResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancersRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancersResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeTagsRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeTagsResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DuplicateListenerException;
import software.amazon.awssdk.services.elasticloadbalancing.model.DuplicateLoadBalancerNameException;
import software.amazon.awssdk.services.elasticloadbalancing.model.DuplicatePolicyNameException;
import software.amazon.awssdk.services.elasticloadbalancing.model.DuplicateTagKeysException;
import software.amazon.awssdk.services.elasticloadbalancing.model.ElasticLoadBalancingException;
import software.amazon.awssdk.services.elasticloadbalancing.model.ElasticLoadBalancingRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.InvalidConfigurationRequestException;
import software.amazon.awssdk.services.elasticloadbalancing.model.InvalidInstanceException;
import software.amazon.awssdk.services.elasticloadbalancing.model.InvalidSchemeException;
import software.amazon.awssdk.services.elasticloadbalancing.model.InvalidSecurityGroupException;
import software.amazon.awssdk.services.elasticloadbalancing.model.InvalidSubnetException;
import software.amazon.awssdk.services.elasticloadbalancing.model.ListenerNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerAttributeNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.OperationNotPermittedException;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyTypeNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.RemoveTagsRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.RemoveTagsResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerListenerSslCertificateRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerListenerSslCertificateResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.SubnetNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancing.model.TooManyLoadBalancersException;
import software.amazon.awssdk.services.elasticloadbalancing.model.TooManyPoliciesException;
import software.amazon.awssdk.services.elasticloadbalancing.model.TooManyTagsException;
import software.amazon.awssdk.services.elasticloadbalancing.model.UnsupportedProtocolException;
import software.amazon.awssdk.services.elasticloadbalancing.paginators.DescribeLoadBalancersPublisher;
import software.amazon.awssdk.services.elasticloadbalancing.transform.AddTagsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.ApplySecurityGroupsToLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.AttachLoadBalancerToSubnetsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.ConfigureHealthCheckRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.CreateAppCookieStickinessPolicyRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.CreateLbCookieStickinessPolicyRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.CreateLoadBalancerListenersRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.CreateLoadBalancerPolicyRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.CreateLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DeleteLoadBalancerListenersRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DeleteLoadBalancerPolicyRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DeleteLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DeregisterInstancesFromLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DescribeAccountLimitsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DescribeInstanceHealthRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DescribeLoadBalancerAttributesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DescribeLoadBalancerPoliciesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DescribeLoadBalancerPolicyTypesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DescribeLoadBalancersRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DescribeTagsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DetachLoadBalancerFromSubnetsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DisableAvailabilityZonesForLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.EnableAvailabilityZonesForLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.ModifyLoadBalancerAttributesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.RegisterInstancesWithLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.RemoveTagsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.SetLoadBalancerListenerSslCertificateRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.SetLoadBalancerPoliciesForBackendServerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.SetLoadBalancerPoliciesOfListenerRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultElasticLoadBalancingAsyncClient
implements ElasticLoadBalancingAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultElasticLoadBalancingAsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final AwsQueryProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultElasticLoadBalancingAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init();
    }

    public final String serviceName() {
        return "elasticloadbalancing";
    }

    @Override
    public CompletableFuture<AddTagsResponse> addTags(AddTagsRequest addTagsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AddTagsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddTags").withMarshaller((Marshaller)new AddTagsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addTagsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ApplySecurityGroupsToLoadBalancerResponse> applySecurityGroupsToLoadBalancer(ApplySecurityGroupsToLoadBalancerRequest applySecurityGroupsToLoadBalancerRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ApplySecurityGroupsToLoadBalancerResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ApplySecurityGroupsToLoadBalancer").withMarshaller((Marshaller)new ApplySecurityGroupsToLoadBalancerRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)applySecurityGroupsToLoadBalancerRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AttachLoadBalancerToSubnetsResponse> attachLoadBalancerToSubnets(AttachLoadBalancerToSubnetsRequest attachLoadBalancerToSubnetsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AttachLoadBalancerToSubnetsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("AttachLoadBalancerToSubnets").withMarshaller((Marshaller)new AttachLoadBalancerToSubnetsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)attachLoadBalancerToSubnetsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ConfigureHealthCheckResponse> configureHealthCheck(ConfigureHealthCheckRequest configureHealthCheckRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ConfigureHealthCheckResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ConfigureHealthCheck").withMarshaller((Marshaller)new ConfigureHealthCheckRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)configureHealthCheckRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateAppCookieStickinessPolicyResponse> createAppCookieStickinessPolicy(CreateAppCookieStickinessPolicyRequest createAppCookieStickinessPolicyRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateAppCookieStickinessPolicyResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAppCookieStickinessPolicy").withMarshaller((Marshaller)new CreateAppCookieStickinessPolicyRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createAppCookieStickinessPolicyRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateLbCookieStickinessPolicyResponse> createLBCookieStickinessPolicy(CreateLbCookieStickinessPolicyRequest createLbCookieStickinessPolicyRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateLbCookieStickinessPolicyResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLBCookieStickinessPolicy").withMarshaller((Marshaller)new CreateLbCookieStickinessPolicyRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createLbCookieStickinessPolicyRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateLoadBalancerResponse> createLoadBalancer(CreateLoadBalancerRequest createLoadBalancerRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateLoadBalancerResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLoadBalancer").withMarshaller((Marshaller)new CreateLoadBalancerRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createLoadBalancerRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateLoadBalancerListenersResponse> createLoadBalancerListeners(CreateLoadBalancerListenersRequest createLoadBalancerListenersRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateLoadBalancerListenersResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLoadBalancerListeners").withMarshaller((Marshaller)new CreateLoadBalancerListenersRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createLoadBalancerListenersRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateLoadBalancerPolicyResponse> createLoadBalancerPolicy(CreateLoadBalancerPolicyRequest createLoadBalancerPolicyRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateLoadBalancerPolicyResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLoadBalancerPolicy").withMarshaller((Marshaller)new CreateLoadBalancerPolicyRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createLoadBalancerPolicyRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteLoadBalancerResponse> deleteLoadBalancer(DeleteLoadBalancerRequest deleteLoadBalancerRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteLoadBalancerResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLoadBalancer").withMarshaller((Marshaller)new DeleteLoadBalancerRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteLoadBalancerRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteLoadBalancerListenersResponse> deleteLoadBalancerListeners(DeleteLoadBalancerListenersRequest deleteLoadBalancerListenersRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteLoadBalancerListenersResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLoadBalancerListeners").withMarshaller((Marshaller)new DeleteLoadBalancerListenersRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteLoadBalancerListenersRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteLoadBalancerPolicyResponse> deleteLoadBalancerPolicy(DeleteLoadBalancerPolicyRequest deleteLoadBalancerPolicyRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteLoadBalancerPolicyResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLoadBalancerPolicy").withMarshaller((Marshaller)new DeleteLoadBalancerPolicyRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteLoadBalancerPolicyRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeregisterInstancesFromLoadBalancerResponse> deregisterInstancesFromLoadBalancer(DeregisterInstancesFromLoadBalancerRequest deregisterInstancesFromLoadBalancerRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeregisterInstancesFromLoadBalancerResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterInstancesFromLoadBalancer").withMarshaller((Marshaller)new DeregisterInstancesFromLoadBalancerRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deregisterInstancesFromLoadBalancerRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeAccountLimitsResponse> describeAccountLimits(DescribeAccountLimitsRequest describeAccountLimitsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeAccountLimitsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAccountLimits").withMarshaller((Marshaller)new DescribeAccountLimitsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAccountLimitsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeInstanceHealthResponse> describeInstanceHealth(DescribeInstanceHealthRequest describeInstanceHealthRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeInstanceHealthResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeInstanceHealth").withMarshaller((Marshaller)new DescribeInstanceHealthRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeInstanceHealthRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeLoadBalancerAttributesResponse> describeLoadBalancerAttributes(DescribeLoadBalancerAttributesRequest describeLoadBalancerAttributesRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeLoadBalancerAttributesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLoadBalancerAttributes").withMarshaller((Marshaller)new DescribeLoadBalancerAttributesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeLoadBalancerAttributesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeLoadBalancerPoliciesResponse> describeLoadBalancerPolicies(DescribeLoadBalancerPoliciesRequest describeLoadBalancerPoliciesRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeLoadBalancerPoliciesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLoadBalancerPolicies").withMarshaller((Marshaller)new DescribeLoadBalancerPoliciesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeLoadBalancerPoliciesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeLoadBalancerPolicyTypesResponse> describeLoadBalancerPolicyTypes(DescribeLoadBalancerPolicyTypesRequest describeLoadBalancerPolicyTypesRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeLoadBalancerPolicyTypesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLoadBalancerPolicyTypes").withMarshaller((Marshaller)new DescribeLoadBalancerPolicyTypesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeLoadBalancerPolicyTypesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeLoadBalancersResponse> describeLoadBalancers(DescribeLoadBalancersRequest describeLoadBalancersRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeLoadBalancersResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLoadBalancers").withMarshaller((Marshaller)new DescribeLoadBalancersRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeLoadBalancersRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeLoadBalancersPublisher describeLoadBalancersPaginator(DescribeLoadBalancersRequest describeLoadBalancersRequest) {
        return new DescribeLoadBalancersPublisher(this, this.applyPaginatorUserAgent(describeLoadBalancersRequest));
    }

    @Override
    public CompletableFuture<DescribeTagsResponse> describeTags(DescribeTagsRequest describeTagsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeTagsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTags").withMarshaller((Marshaller)new DescribeTagsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeTagsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DetachLoadBalancerFromSubnetsResponse> detachLoadBalancerFromSubnets(DetachLoadBalancerFromSubnetsRequest detachLoadBalancerFromSubnetsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DetachLoadBalancerFromSubnetsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetachLoadBalancerFromSubnets").withMarshaller((Marshaller)new DetachLoadBalancerFromSubnetsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)detachLoadBalancerFromSubnetsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisableAvailabilityZonesForLoadBalancerResponse> disableAvailabilityZonesForLoadBalancer(DisableAvailabilityZonesForLoadBalancerRequest disableAvailabilityZonesForLoadBalancerRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DisableAvailabilityZonesForLoadBalancerResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableAvailabilityZonesForLoadBalancer").withMarshaller((Marshaller)new DisableAvailabilityZonesForLoadBalancerRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disableAvailabilityZonesForLoadBalancerRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<EnableAvailabilityZonesForLoadBalancerResponse> enableAvailabilityZonesForLoadBalancer(EnableAvailabilityZonesForLoadBalancerRequest enableAvailabilityZonesForLoadBalancerRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(EnableAvailabilityZonesForLoadBalancerResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableAvailabilityZonesForLoadBalancer").withMarshaller((Marshaller)new EnableAvailabilityZonesForLoadBalancerRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)enableAvailabilityZonesForLoadBalancerRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyLoadBalancerAttributesResponse> modifyLoadBalancerAttributes(ModifyLoadBalancerAttributesRequest modifyLoadBalancerAttributesRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyLoadBalancerAttributesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyLoadBalancerAttributes").withMarshaller((Marshaller)new ModifyLoadBalancerAttributesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyLoadBalancerAttributesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RegisterInstancesWithLoadBalancerResponse> registerInstancesWithLoadBalancer(RegisterInstancesWithLoadBalancerRequest registerInstancesWithLoadBalancerRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RegisterInstancesWithLoadBalancerResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterInstancesWithLoadBalancer").withMarshaller((Marshaller)new RegisterInstancesWithLoadBalancerRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)registerInstancesWithLoadBalancerRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RemoveTagsResponse> removeTags(RemoveTagsRequest removeTagsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RemoveTagsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveTags").withMarshaller((Marshaller)new RemoveTagsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removeTagsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SetLoadBalancerListenerSslCertificateResponse> setLoadBalancerListenerSSLCertificate(SetLoadBalancerListenerSslCertificateRequest setLoadBalancerListenerSslCertificateRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetLoadBalancerListenerSslCertificateResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetLoadBalancerListenerSSLCertificate").withMarshaller((Marshaller)new SetLoadBalancerListenerSslCertificateRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setLoadBalancerListenerSslCertificateRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SetLoadBalancerPoliciesForBackendServerResponse> setLoadBalancerPoliciesForBackendServer(SetLoadBalancerPoliciesForBackendServerRequest setLoadBalancerPoliciesForBackendServerRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetLoadBalancerPoliciesForBackendServerResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetLoadBalancerPoliciesForBackendServer").withMarshaller((Marshaller)new SetLoadBalancerPoliciesForBackendServerRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setLoadBalancerPoliciesForBackendServerRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SetLoadBalancerPoliciesOfListenerResponse> setLoadBalancerPoliciesOfListener(SetLoadBalancerPoliciesOfListenerRequest setLoadBalancerPoliciesOfListenerRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetLoadBalancerPoliciesOfListenerResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetLoadBalancerPoliciesOfListener").withMarshaller((Marshaller)new SetLoadBalancerPoliciesOfListenerRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setLoadBalancerPoliciesOfListenerRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    public void close() {
        this.clientHandler.close();
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedProtocol").exceptionBuilderSupplier(UnsupportedProtocolException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LoadBalancerAttributeNotFound").exceptionBuilderSupplier(LoadBalancerAttributeNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LoadBalancerNotFound").exceptionBuilderSupplier(LoadBalancerNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyLoadBalancers").exceptionBuilderSupplier(TooManyLoadBalancersException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidConfigurationRequest").exceptionBuilderSupplier(InvalidConfigurationRequestException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSecurityGroup").exceptionBuilderSupplier(InvalidSecurityGroupException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicateLoadBalancerName").exceptionBuilderSupplier(DuplicateLoadBalancerNameException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DependencyThrottle").exceptionBuilderSupplier(DependencyThrottleException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OperationNotPermitted").exceptionBuilderSupplier(OperationNotPermittedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PolicyNotFound").exceptionBuilderSupplier(PolicyNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CertificateNotFound").exceptionBuilderSupplier(CertificateNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicateTagKeys").exceptionBuilderSupplier(DuplicateTagKeysException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTags").exceptionBuilderSupplier(TooManyTagsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ListenerNotFound").exceptionBuilderSupplier(ListenerNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyPolicies").exceptionBuilderSupplier(TooManyPoliciesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicatePolicyName").exceptionBuilderSupplier(DuplicatePolicyNameException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SubnetNotFound").exceptionBuilderSupplier(SubnetNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicateListener").exceptionBuilderSupplier(DuplicateListenerException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidScheme").exceptionBuilderSupplier(InvalidSchemeException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PolicyTypeNotFound").exceptionBuilderSupplier(PolicyTypeNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSubnet").exceptionBuilderSupplier(InvalidSubnetException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidInstance").exceptionBuilderSupplier(InvalidInstanceException::builder).httpStatusCode(Integer.valueOf(400)).build()).clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(ElasticLoadBalancingException::builder).build();
    }

    private <T extends ElasticLoadBalancingRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.5.17").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((ElasticLoadBalancingRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

