/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticloadbalancing.model.ElasticLoadBalancingRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerAttributes;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyLoadBalancerAttributesRequest
extends ElasticLoadBalancingRequest
implements ToCopyableBuilder<Builder, ModifyLoadBalancerAttributesRequest> {
    private static final SdkField<String> LOAD_BALANCER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LoadBalancerName").getter(ModifyLoadBalancerAttributesRequest.getter(ModifyLoadBalancerAttributesRequest::loadBalancerName)).setter(ModifyLoadBalancerAttributesRequest.setter(Builder::loadBalancerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerName").build()}).build();
    private static final SdkField<LoadBalancerAttributes> LOAD_BALANCER_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LoadBalancerAttributes").getter(ModifyLoadBalancerAttributesRequest.getter(ModifyLoadBalancerAttributesRequest::loadBalancerAttributes)).setter(ModifyLoadBalancerAttributesRequest.setter(Builder::loadBalancerAttributes)).constructor(LoadBalancerAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerAttributes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_NAME_FIELD, LOAD_BALANCER_ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyLoadBalancerAttributesRequest.memberNameToFieldInitializer();
    private final String loadBalancerName;
    private final LoadBalancerAttributes loadBalancerAttributes;

    private ModifyLoadBalancerAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerName = builder.loadBalancerName;
        this.loadBalancerAttributes = builder.loadBalancerAttributes;
    }

    public final String loadBalancerName() {
        return this.loadBalancerName;
    }

    public final LoadBalancerAttributes loadBalancerAttributes() {
        return this.loadBalancerAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerAttributes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyLoadBalancerAttributesRequest)) {
            return false;
        }
        ModifyLoadBalancerAttributesRequest other = (ModifyLoadBalancerAttributesRequest)((Object)obj);
        return Objects.equals(this.loadBalancerName(), other.loadBalancerName()) && Objects.equals(this.loadBalancerAttributes(), other.loadBalancerAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyLoadBalancerAttributesRequest").add("LoadBalancerName", (Object)this.loadBalancerName()).add("LoadBalancerAttributes", (Object)this.loadBalancerAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoadBalancerName": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerName()));
            }
            case "LoadBalancerAttributes": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LoadBalancerName", LOAD_BALANCER_NAME_FIELD);
        map.put("LoadBalancerAttributes", LOAD_BALANCER_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyLoadBalancerAttributesRequest, T> g) {
        return obj -> g.apply((ModifyLoadBalancerAttributesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingRequest.BuilderImpl
    implements Builder {
        private String loadBalancerName;
        private LoadBalancerAttributes loadBalancerAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyLoadBalancerAttributesRequest model) {
            super(model);
            this.loadBalancerName(model.loadBalancerName);
            this.loadBalancerAttributes(model.loadBalancerAttributes);
        }

        public final String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final LoadBalancerAttributes.Builder getLoadBalancerAttributes() {
            return this.loadBalancerAttributes != null ? this.loadBalancerAttributes.toBuilder() : null;
        }

        public final void setLoadBalancerAttributes(LoadBalancerAttributes.BuilderImpl loadBalancerAttributes) {
            this.loadBalancerAttributes = loadBalancerAttributes != null ? loadBalancerAttributes.build() : null;
        }

        @Override
        public final Builder loadBalancerAttributes(LoadBalancerAttributes loadBalancerAttributes) {
            this.loadBalancerAttributes = loadBalancerAttributes;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyLoadBalancerAttributesRequest build() {
            return new ModifyLoadBalancerAttributesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyLoadBalancerAttributesRequest> {
        public Builder loadBalancerName(String var1);

        public Builder loadBalancerAttributes(LoadBalancerAttributes var1);

        default public Builder loadBalancerAttributes(Consumer<LoadBalancerAttributes.Builder> loadBalancerAttributes) {
            return this.loadBalancerAttributes((LoadBalancerAttributes)((LoadBalancerAttributes.Builder)LoadBalancerAttributes.builder().applyMutation(loadBalancerAttributes)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

