/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancing.model.AvailabilityZonesCopier;
import software.amazon.awssdk.services.elasticloadbalancing.model.ElasticLoadBalancingResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnableAvailabilityZonesForLoadBalancerResponse
extends ElasticLoadBalancingResponse
implements ToCopyableBuilder<Builder, EnableAvailabilityZonesForLoadBalancerResponse> {
    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AvailabilityZones").getter(EnableAvailabilityZonesForLoadBalancerResponse.getter(EnableAvailabilityZonesForLoadBalancerResponse::availabilityZones)).setter(EnableAvailabilityZonesForLoadBalancerResponse.setter(Builder::availabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AvailabilityZones", AVAILABILITY_ZONES_FIELD);
        }
    });
    private final List<String> availabilityZones;

    private EnableAvailabilityZonesForLoadBalancerResponse(BuilderImpl builder) {
        super(builder);
        this.availabilityZones = builder.availabilityZones;
    }

    public final boolean hasAvailabilityZones() {
        return this.availabilityZones != null && !(this.availabilityZones instanceof SdkAutoConstructList);
    }

    public final List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailabilityZones() ? this.availabilityZones() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableAvailabilityZonesForLoadBalancerResponse)) {
            return false;
        }
        EnableAvailabilityZonesForLoadBalancerResponse other = (EnableAvailabilityZonesForLoadBalancerResponse)((Object)obj);
        return this.hasAvailabilityZones() == other.hasAvailabilityZones() && Objects.equals(this.availabilityZones(), other.availabilityZones());
    }

    public final String toString() {
        return ToString.builder((String)"EnableAvailabilityZonesForLoadBalancerResponse").add("AvailabilityZones", this.hasAvailabilityZones() ? this.availabilityZones() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.availabilityZones()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EnableAvailabilityZonesForLoadBalancerResponse, T> g) {
        return obj -> g.apply((EnableAvailabilityZonesForLoadBalancerResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingResponse.BuilderImpl
    implements Builder {
        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EnableAvailabilityZonesForLoadBalancerResponse model) {
            super(model);
            this.availabilityZones(model.availabilityZones);
        }

        public final Collection<String> getAvailabilityZones() {
            if (this.availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return this.availabilityZones;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        @Override
        public EnableAvailabilityZonesForLoadBalancerResponse build() {
            return new EnableAvailabilityZonesForLoadBalancerResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, EnableAvailabilityZonesForLoadBalancerResponse> {
        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);
    }
}

