/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancing.model.ElasticLoadBalancingResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.TagDescription;
import software.amazon.awssdk.services.elasticloadbalancing.model.TagDescriptionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTagsResponse
extends ElasticLoadBalancingResponse
implements ToCopyableBuilder<Builder, DescribeTagsResponse> {
    private static final SdkField<List<TagDescription>> TAG_DESCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagDescriptions").getter(DescribeTagsResponse.getter(DescribeTagsResponse::tagDescriptions)).setter(DescribeTagsResponse.setter(Builder::tagDescriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagDescriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAG_DESCRIPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TagDescriptions", TAG_DESCRIPTIONS_FIELD);
        }
    });
    private final List<TagDescription> tagDescriptions;

    private DescribeTagsResponse(BuilderImpl builder) {
        super(builder);
        this.tagDescriptions = builder.tagDescriptions;
    }

    public final boolean hasTagDescriptions() {
        return this.tagDescriptions != null && !(this.tagDescriptions instanceof SdkAutoConstructList);
    }

    public final List<TagDescription> tagDescriptions() {
        return this.tagDescriptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagDescriptions() ? this.tagDescriptions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTagsResponse)) {
            return false;
        }
        DescribeTagsResponse other = (DescribeTagsResponse)((Object)obj);
        return this.hasTagDescriptions() == other.hasTagDescriptions() && Objects.equals(this.tagDescriptions(), other.tagDescriptions());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeTagsResponse").add("TagDescriptions", this.hasTagDescriptions() ? this.tagDescriptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TagDescriptions": {
                return Optional.ofNullable(clazz.cast(this.tagDescriptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTagsResponse, T> g) {
        return obj -> g.apply((DescribeTagsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingResponse.BuilderImpl
    implements Builder {
        private List<TagDescription> tagDescriptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTagsResponse model) {
            super(model);
            this.tagDescriptions(model.tagDescriptions);
        }

        public final List<TagDescription.Builder> getTagDescriptions() {
            List<TagDescription.Builder> result = TagDescriptionsCopier.copyToBuilder(this.tagDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagDescriptions(Collection<TagDescription.BuilderImpl> tagDescriptions) {
            this.tagDescriptions = TagDescriptionsCopier.copyFromBuilder(tagDescriptions);
        }

        @Override
        public final Builder tagDescriptions(Collection<TagDescription> tagDescriptions) {
            this.tagDescriptions = TagDescriptionsCopier.copy(tagDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagDescriptions(TagDescription ... tagDescriptions) {
            this.tagDescriptions(Arrays.asList(tagDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagDescriptions(Consumer<TagDescription.Builder> ... tagDescriptions) {
            this.tagDescriptions(Stream.of(tagDescriptions).map(c -> (TagDescription)((TagDescription.Builder)TagDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeTagsResponse build() {
            return new DescribeTagsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTagsResponse> {
        public Builder tagDescriptions(Collection<TagDescription> var1);

        public Builder tagDescriptions(TagDescription ... var1);

        public Builder tagDescriptions(Consumer<TagDescription.Builder> ... var1);
    }
}

