/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.elasticloadbalancing.DefaultElasticLoadBalancingBaseClientBuilder;
import software.amazon.awssdk.services.elasticloadbalancing.DefaultElasticLoadBalancingClient;
import software.amazon.awssdk.services.elasticloadbalancing.ElasticLoadBalancingClient;
import software.amazon.awssdk.services.elasticloadbalancing.ElasticLoadBalancingClientBuilder;
import software.amazon.awssdk.services.elasticloadbalancing.ElasticLoadBalancingServiceClientConfiguration;
import software.amazon.awssdk.services.elasticloadbalancing.endpoints.ElasticLoadBalancingEndpointProvider;

@SdkInternalApi
final class DefaultElasticLoadBalancingClientBuilder
extends DefaultElasticLoadBalancingBaseClientBuilder<ElasticLoadBalancingClientBuilder, ElasticLoadBalancingClient>
implements ElasticLoadBalancingClientBuilder {
    DefaultElasticLoadBalancingClientBuilder() {
    }

    @Override
    public DefaultElasticLoadBalancingClientBuilder endpointProvider(ElasticLoadBalancingEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ElasticLoadBalancingClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultElasticLoadBalancingClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        ElasticLoadBalancingServiceClientConfiguration serviceClientConfiguration = ElasticLoadBalancingServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultElasticLoadBalancingClient(serviceClientConfiguration, clientConfiguration);
    }
}

