/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticloadbalancing.ElasticLoadBalancingClient;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancersRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancersResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerDescription;

public class DescribeLoadBalancersIterable
implements SdkIterable<DescribeLoadBalancersResponse> {
    private final ElasticLoadBalancingClient client;
    private final DescribeLoadBalancersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeLoadBalancersIterable(ElasticLoadBalancingClient client, DescribeLoadBalancersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeLoadBalancersResponseFetcher();
    }

    public Iterator<DescribeLoadBalancersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<LoadBalancerDescription> loadBalancerDescriptions() {
        Function<DescribeLoadBalancersResponse, Iterator> getIterator = response -> {
            if (response != null && response.loadBalancerDescriptions() != null) {
                return response.loadBalancerDescriptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeLoadBalancersResponseFetcher
    implements SyncPageFetcher<DescribeLoadBalancersResponse> {
        private DescribeLoadBalancersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeLoadBalancersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public DescribeLoadBalancersResponse nextPage(DescribeLoadBalancersResponse previousPage) {
            if (previousPage == null) {
                return DescribeLoadBalancersIterable.this.client.describeLoadBalancers(DescribeLoadBalancersIterable.this.firstRequest);
            }
            return DescribeLoadBalancersIterable.this.client.describeLoadBalancers((DescribeLoadBalancersRequest)((Object)DescribeLoadBalancersIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

