/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancing.model.ElasticLoadBalancingRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyTypeNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLoadBalancerPolicyTypesRequest
extends ElasticLoadBalancingRequest
implements ToCopyableBuilder<Builder, DescribeLoadBalancerPolicyTypesRequest> {
    private static final SdkField<List<String>> POLICY_TYPE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PolicyTypeNames").getter(DescribeLoadBalancerPolicyTypesRequest.getter(DescribeLoadBalancerPolicyTypesRequest::policyTypeNames)).setter(DescribeLoadBalancerPolicyTypesRequest.setter(Builder::policyTypeNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyTypeNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_TYPE_NAMES_FIELD));
    private final List<String> policyTypeNames;

    private DescribeLoadBalancerPolicyTypesRequest(BuilderImpl builder) {
        super(builder);
        this.policyTypeNames = builder.policyTypeNames;
    }

    public final boolean hasPolicyTypeNames() {
        return this.policyTypeNames != null && !(this.policyTypeNames instanceof SdkAutoConstructList);
    }

    public final List<String> policyTypeNames() {
        return this.policyTypeNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolicyTypeNames() ? this.policyTypeNames() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLoadBalancerPolicyTypesRequest)) {
            return false;
        }
        DescribeLoadBalancerPolicyTypesRequest other = (DescribeLoadBalancerPolicyTypesRequest)((Object)obj);
        return this.hasPolicyTypeNames() == other.hasPolicyTypeNames() && Objects.equals(this.policyTypeNames(), other.policyTypeNames());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeLoadBalancerPolicyTypesRequest").add("PolicyTypeNames", this.hasPolicyTypeNames() ? this.policyTypeNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyTypeNames": {
                return Optional.ofNullable(clazz.cast(this.policyTypeNames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLoadBalancerPolicyTypesRequest, T> g) {
        return obj -> g.apply((DescribeLoadBalancerPolicyTypesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingRequest.BuilderImpl
    implements Builder {
        private List<String> policyTypeNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLoadBalancerPolicyTypesRequest model) {
            super(model);
            this.policyTypeNames(model.policyTypeNames);
        }

        public final Collection<String> getPolicyTypeNames() {
            if (this.policyTypeNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.policyTypeNames;
        }

        public final void setPolicyTypeNames(Collection<String> policyTypeNames) {
            this.policyTypeNames = PolicyTypeNamesCopier.copy(policyTypeNames);
        }

        @Override
        @Transient
        public final Builder policyTypeNames(Collection<String> policyTypeNames) {
            this.policyTypeNames = PolicyTypeNamesCopier.copy(policyTypeNames);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder policyTypeNames(String ... policyTypeNames) {
            this.policyTypeNames(Arrays.asList(policyTypeNames));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeLoadBalancerPolicyTypesRequest build() {
            return new DescribeLoadBalancerPolicyTypesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeLoadBalancerPolicyTypesRequest> {
        public Builder policyTypeNames(Collection<String> var1);

        public Builder policyTypeNames(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

