/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancing.model.ElasticLoadBalancingResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyDescription;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyDescriptionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLoadBalancerPoliciesResponse
extends ElasticLoadBalancingResponse
implements ToCopyableBuilder<Builder, DescribeLoadBalancerPoliciesResponse> {
    private static final SdkField<List<PolicyDescription>> POLICY_DESCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PolicyDescriptions").getter(DescribeLoadBalancerPoliciesResponse.getter(DescribeLoadBalancerPoliciesResponse::policyDescriptions)).setter(DescribeLoadBalancerPoliciesResponse.setter(Builder::policyDescriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyDescriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PolicyDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_DESCRIPTIONS_FIELD));
    private final List<PolicyDescription> policyDescriptions;

    private DescribeLoadBalancerPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.policyDescriptions = builder.policyDescriptions;
    }

    public final boolean hasPolicyDescriptions() {
        return this.policyDescriptions != null && !(this.policyDescriptions instanceof SdkAutoConstructList);
    }

    public final List<PolicyDescription> policyDescriptions() {
        return this.policyDescriptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolicyDescriptions() ? this.policyDescriptions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLoadBalancerPoliciesResponse)) {
            return false;
        }
        DescribeLoadBalancerPoliciesResponse other = (DescribeLoadBalancerPoliciesResponse)((Object)obj);
        return this.hasPolicyDescriptions() == other.hasPolicyDescriptions() && Objects.equals(this.policyDescriptions(), other.policyDescriptions());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeLoadBalancerPoliciesResponse").add("PolicyDescriptions", this.hasPolicyDescriptions() ? this.policyDescriptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyDescriptions": {
                return Optional.ofNullable(clazz.cast(this.policyDescriptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLoadBalancerPoliciesResponse, T> g) {
        return obj -> g.apply((DescribeLoadBalancerPoliciesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingResponse.BuilderImpl
    implements Builder {
        private List<PolicyDescription> policyDescriptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLoadBalancerPoliciesResponse model) {
            super(model);
            this.policyDescriptions(model.policyDescriptions);
        }

        public final List<PolicyDescription.Builder> getPolicyDescriptions() {
            List<PolicyDescription.Builder> result = PolicyDescriptionsCopier.copyToBuilder(this.policyDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPolicyDescriptions(Collection<PolicyDescription.BuilderImpl> policyDescriptions) {
            this.policyDescriptions = PolicyDescriptionsCopier.copyFromBuilder(policyDescriptions);
        }

        @Override
        @Transient
        public final Builder policyDescriptions(Collection<PolicyDescription> policyDescriptions) {
            this.policyDescriptions = PolicyDescriptionsCopier.copy(policyDescriptions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder policyDescriptions(PolicyDescription ... policyDescriptions) {
            this.policyDescriptions(Arrays.asList(policyDescriptions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder policyDescriptions(Consumer<PolicyDescription.Builder> ... policyDescriptions) {
            this.policyDescriptions(Stream.of(policyDescriptions).map(c -> (PolicyDescription)((PolicyDescription.Builder)PolicyDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeLoadBalancerPoliciesResponse build() {
            return new DescribeLoadBalancerPoliciesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeLoadBalancerPoliciesResponse> {
        public Builder policyDescriptions(Collection<PolicyDescription> var1);

        public Builder policyDescriptions(PolicyDescription ... var1);

        public Builder policyDescriptions(Consumer<PolicyDescription.Builder> ... var1);
    }
}

