/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancing.model.ElasticLoadBalancingRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyAttribute;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyAttributesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLoadBalancerPolicyRequest
extends ElasticLoadBalancingRequest
implements ToCopyableBuilder<Builder, CreateLoadBalancerPolicyRequest> {
    private static final SdkField<String> LOAD_BALANCER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LoadBalancerName").getter(CreateLoadBalancerPolicyRequest.getter(CreateLoadBalancerPolicyRequest::loadBalancerName)).setter(CreateLoadBalancerPolicyRequest.setter(Builder::loadBalancerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerName").build()}).build();
    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyName").getter(CreateLoadBalancerPolicyRequest.getter(CreateLoadBalancerPolicyRequest::policyName)).setter(CreateLoadBalancerPolicyRequest.setter(Builder::policyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyName").build()}).build();
    private static final SdkField<String> POLICY_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyTypeName").getter(CreateLoadBalancerPolicyRequest.getter(CreateLoadBalancerPolicyRequest::policyTypeName)).setter(CreateLoadBalancerPolicyRequest.setter(Builder::policyTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyTypeName").build()}).build();
    private static final SdkField<List<PolicyAttribute>> POLICY_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PolicyAttributes").getter(CreateLoadBalancerPolicyRequest.getter(CreateLoadBalancerPolicyRequest::policyAttributes)).setter(CreateLoadBalancerPolicyRequest.setter(Builder::policyAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PolicyAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_NAME_FIELD, POLICY_NAME_FIELD, POLICY_TYPE_NAME_FIELD, POLICY_ATTRIBUTES_FIELD));
    private final String loadBalancerName;
    private final String policyName;
    private final String policyTypeName;
    private final List<PolicyAttribute> policyAttributes;

    private CreateLoadBalancerPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerName = builder.loadBalancerName;
        this.policyName = builder.policyName;
        this.policyTypeName = builder.policyTypeName;
        this.policyAttributes = builder.policyAttributes;
    }

    public final String loadBalancerName() {
        return this.loadBalancerName;
    }

    public final String policyName() {
        return this.policyName;
    }

    public final String policyTypeName() {
        return this.policyTypeName;
    }

    public final boolean hasPolicyAttributes() {
        return this.policyAttributes != null && !(this.policyAttributes instanceof SdkAutoConstructList);
    }

    public final List<PolicyAttribute> policyAttributes() {
        return this.policyAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolicyAttributes() ? this.policyAttributes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLoadBalancerPolicyRequest)) {
            return false;
        }
        CreateLoadBalancerPolicyRequest other = (CreateLoadBalancerPolicyRequest)((Object)obj);
        return Objects.equals(this.loadBalancerName(), other.loadBalancerName()) && Objects.equals(this.policyName(), other.policyName()) && Objects.equals(this.policyTypeName(), other.policyTypeName()) && this.hasPolicyAttributes() == other.hasPolicyAttributes() && Objects.equals(this.policyAttributes(), other.policyAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"CreateLoadBalancerPolicyRequest").add("LoadBalancerName", (Object)this.loadBalancerName()).add("PolicyName", (Object)this.policyName()).add("PolicyTypeName", (Object)this.policyTypeName()).add("PolicyAttributes", this.hasPolicyAttributes() ? this.policyAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoadBalancerName": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerName()));
            }
            case "PolicyName": {
                return Optional.ofNullable(clazz.cast(this.policyName()));
            }
            case "PolicyTypeName": {
                return Optional.ofNullable(clazz.cast(this.policyTypeName()));
            }
            case "PolicyAttributes": {
                return Optional.ofNullable(clazz.cast(this.policyAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLoadBalancerPolicyRequest, T> g) {
        return obj -> g.apply((CreateLoadBalancerPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingRequest.BuilderImpl
    implements Builder {
        private String loadBalancerName;
        private String policyName;
        private String policyTypeName;
        private List<PolicyAttribute> policyAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLoadBalancerPolicyRequest model) {
            super(model);
            this.loadBalancerName(model.loadBalancerName);
            this.policyName(model.policyName);
            this.policyTypeName(model.policyTypeName);
            this.policyAttributes(model.policyAttributes);
        }

        public final String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getPolicyTypeName() {
            return this.policyTypeName;
        }

        @Override
        public final Builder policyTypeName(String policyTypeName) {
            this.policyTypeName = policyTypeName;
            return this;
        }

        public final void setPolicyTypeName(String policyTypeName) {
            this.policyTypeName = policyTypeName;
        }

        public final List<PolicyAttribute.Builder> getPolicyAttributes() {
            List<PolicyAttribute.Builder> result = PolicyAttributesCopier.copyToBuilder(this.policyAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder policyAttributes(Collection<PolicyAttribute> policyAttributes) {
            this.policyAttributes = PolicyAttributesCopier.copy(policyAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyAttributes(PolicyAttribute ... policyAttributes) {
            this.policyAttributes(Arrays.asList(policyAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyAttributes(Consumer<PolicyAttribute.Builder> ... policyAttributes) {
            this.policyAttributes(Stream.of(policyAttributes).map(c -> (PolicyAttribute)((PolicyAttribute.Builder)PolicyAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPolicyAttributes(Collection<PolicyAttribute.BuilderImpl> policyAttributes) {
            this.policyAttributes = PolicyAttributesCopier.copyFromBuilder(policyAttributes);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLoadBalancerPolicyRequest build() {
            return new CreateLoadBalancerPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLoadBalancerPolicyRequest> {
        public Builder loadBalancerName(String var1);

        public Builder policyName(String var1);

        public Builder policyTypeName(String var1);

        public Builder policyAttributes(Collection<PolicyAttribute> var1);

        public Builder policyAttributes(PolicyAttribute ... var1);

        public Builder policyAttributes(Consumer<PolicyAttribute.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

