/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AppCookieStickinessPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AppCookieStickinessPolicy> {
    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyName").getter(AppCookieStickinessPolicy.getter(AppCookieStickinessPolicy::policyName)).setter(AppCookieStickinessPolicy.setter(Builder::policyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyName").build()}).build();
    private static final SdkField<String> COOKIE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CookieName").getter(AppCookieStickinessPolicy.getter(AppCookieStickinessPolicy::cookieName)).setter(AppCookieStickinessPolicy.setter(Builder::cookieName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CookieName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_NAME_FIELD, COOKIE_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String policyName;
    private final String cookieName;

    private AppCookieStickinessPolicy(BuilderImpl builder) {
        this.policyName = builder.policyName;
        this.cookieName = builder.cookieName;
    }

    public final String policyName() {
        return this.policyName;
    }

    public final String cookieName() {
        return this.cookieName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.cookieName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppCookieStickinessPolicy)) {
            return false;
        }
        AppCookieStickinessPolicy other = (AppCookieStickinessPolicy)obj;
        return Objects.equals(this.policyName(), other.policyName()) && Objects.equals(this.cookieName(), other.cookieName());
    }

    public final String toString() {
        return ToString.builder((String)"AppCookieStickinessPolicy").add("PolicyName", (Object)this.policyName()).add("CookieName", (Object)this.cookieName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyName": {
                return Optional.ofNullable(clazz.cast(this.policyName()));
            }
            case "CookieName": {
                return Optional.ofNullable(clazz.cast(this.cookieName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AppCookieStickinessPolicy, T> g) {
        return obj -> g.apply((AppCookieStickinessPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String policyName;
        private String cookieName;

        private BuilderImpl() {
        }

        private BuilderImpl(AppCookieStickinessPolicy model) {
            this.policyName(model.policyName);
            this.cookieName(model.cookieName);
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getCookieName() {
            return this.cookieName;
        }

        @Override
        public final Builder cookieName(String cookieName) {
            this.cookieName = cookieName;
            return this;
        }

        public final void setCookieName(String cookieName) {
            this.cookieName = cookieName;
        }

        public AppCookieStickinessPolicy build() {
            return new AppCookieStickinessPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AppCookieStickinessPolicy> {
        public Builder policyName(String var1);

        public Builder cookieName(String var1);
    }
}

