/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticloadbalancing.model.ElasticLoadBalancingRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SetLoadBalancerListenerSslCertificateRequest
extends ElasticLoadBalancingRequest
implements ToCopyableBuilder<Builder, SetLoadBalancerListenerSslCertificateRequest> {
    private static final SdkField<String> LOAD_BALANCER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LoadBalancerName").getter(SetLoadBalancerListenerSslCertificateRequest.getter(SetLoadBalancerListenerSslCertificateRequest::loadBalancerName)).setter(SetLoadBalancerListenerSslCertificateRequest.setter(Builder::loadBalancerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerName").build()}).build();
    private static final SdkField<Integer> LOAD_BALANCER_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("LoadBalancerPort").getter(SetLoadBalancerListenerSslCertificateRequest.getter(SetLoadBalancerListenerSslCertificateRequest::loadBalancerPort)).setter(SetLoadBalancerListenerSslCertificateRequest.setter(Builder::loadBalancerPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerPort").build()}).build();
    private static final SdkField<String> SSL_CERTIFICATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SSLCertificateId").getter(SetLoadBalancerListenerSslCertificateRequest.getter(SetLoadBalancerListenerSslCertificateRequest::sslCertificateId)).setter(SetLoadBalancerListenerSslCertificateRequest.setter(Builder::sslCertificateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSLCertificateId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_NAME_FIELD, LOAD_BALANCER_PORT_FIELD, SSL_CERTIFICATE_ID_FIELD));
    private final String loadBalancerName;
    private final Integer loadBalancerPort;
    private final String sslCertificateId;

    private SetLoadBalancerListenerSslCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerName = builder.loadBalancerName;
        this.loadBalancerPort = builder.loadBalancerPort;
        this.sslCertificateId = builder.sslCertificateId;
    }

    public final String loadBalancerName() {
        return this.loadBalancerName;
    }

    public final Integer loadBalancerPort() {
        return this.loadBalancerPort;
    }

    public final String sslCertificateId() {
        return this.sslCertificateId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.sslCertificateId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetLoadBalancerListenerSslCertificateRequest)) {
            return false;
        }
        SetLoadBalancerListenerSslCertificateRequest other = (SetLoadBalancerListenerSslCertificateRequest)((Object)obj);
        return Objects.equals(this.loadBalancerName(), other.loadBalancerName()) && Objects.equals(this.loadBalancerPort(), other.loadBalancerPort()) && Objects.equals(this.sslCertificateId(), other.sslCertificateId());
    }

    public final String toString() {
        return ToString.builder((String)"SetLoadBalancerListenerSslCertificateRequest").add("LoadBalancerName", (Object)this.loadBalancerName()).add("LoadBalancerPort", (Object)this.loadBalancerPort()).add("SSLCertificateId", (Object)this.sslCertificateId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoadBalancerName": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerName()));
            }
            case "LoadBalancerPort": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerPort()));
            }
            case "SSLCertificateId": {
                return Optional.ofNullable(clazz.cast(this.sslCertificateId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetLoadBalancerListenerSslCertificateRequest, T> g) {
        return obj -> g.apply((SetLoadBalancerListenerSslCertificateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingRequest.BuilderImpl
    implements Builder {
        private String loadBalancerName;
        private Integer loadBalancerPort;
        private String sslCertificateId;

        private BuilderImpl() {
        }

        private BuilderImpl(SetLoadBalancerListenerSslCertificateRequest model) {
            super(model);
            this.loadBalancerName(model.loadBalancerName);
            this.loadBalancerPort(model.loadBalancerPort);
            this.sslCertificateId(model.sslCertificateId);
        }

        public final String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        public final Integer getLoadBalancerPort() {
            return this.loadBalancerPort;
        }

        @Override
        public final Builder loadBalancerPort(Integer loadBalancerPort) {
            this.loadBalancerPort = loadBalancerPort;
            return this;
        }

        public final void setLoadBalancerPort(Integer loadBalancerPort) {
            this.loadBalancerPort = loadBalancerPort;
        }

        public final String getSslCertificateId() {
            return this.sslCertificateId;
        }

        @Override
        public final Builder sslCertificateId(String sslCertificateId) {
            this.sslCertificateId = sslCertificateId;
            return this;
        }

        public final void setSslCertificateId(String sslCertificateId) {
            this.sslCertificateId = sslCertificateId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetLoadBalancerListenerSslCertificateRequest build() {
            return new SetLoadBalancerListenerSslCertificateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SetLoadBalancerListenerSslCertificateRequest> {
        public Builder loadBalancerName(String var1);

        public Builder loadBalancerPort(Integer var1);

        public Builder sslCertificateId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

