/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancing.model.ElasticLoadBalancingRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLoadBalancersRequest
extends ElasticLoadBalancingRequest
implements ToCopyableBuilder<Builder, DescribeLoadBalancersRequest> {
    private static final SdkField<List<String>> LOAD_BALANCER_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LoadBalancerNames").getter(DescribeLoadBalancersRequest.getter(DescribeLoadBalancersRequest::loadBalancerNames)).setter(DescribeLoadBalancersRequest.setter(Builder::loadBalancerNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeLoadBalancersRequest.getter(DescribeLoadBalancersRequest::marker)).setter(DescribeLoadBalancersRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PageSize").getter(DescribeLoadBalancersRequest.getter(DescribeLoadBalancersRequest::pageSize)).setter(DescribeLoadBalancersRequest.setter(Builder::pageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_NAMES_FIELD, MARKER_FIELD, PAGE_SIZE_FIELD));
    private final List<String> loadBalancerNames;
    private final String marker;
    private final Integer pageSize;

    private DescribeLoadBalancersRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerNames = builder.loadBalancerNames;
        this.marker = builder.marker;
        this.pageSize = builder.pageSize;
    }

    public boolean hasLoadBalancerNames() {
        return this.loadBalancerNames != null && !(this.loadBalancerNames instanceof SdkAutoConstructList);
    }

    public List<String> loadBalancerNames() {
        return this.loadBalancerNames;
    }

    public String marker() {
        return this.marker;
    }

    public Integer pageSize() {
        return this.pageSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLoadBalancersRequest)) {
            return false;
        }
        DescribeLoadBalancersRequest other = (DescribeLoadBalancersRequest)((Object)obj);
        return Objects.equals(this.loadBalancerNames(), other.loadBalancerNames()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.pageSize(), other.pageSize());
    }

    public String toString() {
        return ToString.builder((String)"DescribeLoadBalancersRequest").add("LoadBalancerNames", this.loadBalancerNames()).add("Marker", (Object)this.marker()).add("PageSize", (Object)this.pageSize()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoadBalancerNames": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerNames()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "PageSize": {
                return Optional.ofNullable(clazz.cast(this.pageSize()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLoadBalancersRequest, T> g) {
        return obj -> g.apply((DescribeLoadBalancersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingRequest.BuilderImpl
    implements Builder {
        private List<String> loadBalancerNames = DefaultSdkAutoConstructList.getInstance();
        private String marker;
        private Integer pageSize;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLoadBalancersRequest model) {
            super(model);
            this.loadBalancerNames(model.loadBalancerNames);
            this.marker(model.marker);
            this.pageSize(model.pageSize);
        }

        public final Collection<String> getLoadBalancerNames() {
            return this.loadBalancerNames;
        }

        @Override
        public final Builder loadBalancerNames(Collection<String> loadBalancerNames) {
            this.loadBalancerNames = LoadBalancerNamesCopier.copy(loadBalancerNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerNames(String ... loadBalancerNames) {
            this.loadBalancerNames(Arrays.asList(loadBalancerNames));
            return this;
        }

        public final void setLoadBalancerNames(Collection<String> loadBalancerNames) {
            this.loadBalancerNames = LoadBalancerNamesCopier.copy(loadBalancerNames);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeLoadBalancersRequest build() {
            return new DescribeLoadBalancersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeLoadBalancersRequest> {
        public Builder loadBalancerNames(Collection<String> var1);

        public Builder loadBalancerNames(String ... var1);

        public Builder marker(String var1);

        public Builder pageSize(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

