/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.services.elasticloadbalancing.ElasticLoadBalancingClient;
import software.amazon.awssdk.services.elasticloadbalancing.model.AddTagsRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.AddTagsResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.AttachLoadBalancerToSubnetsRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.AttachLoadBalancerToSubnetsResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.CertificateNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancing.model.ConfigureHealthCheckRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.ConfigureHealthCheckResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateAppCookieStickinessPolicyRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateAppCookieStickinessPolicyResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateLbCookieStickinessPolicyRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateLbCookieStickinessPolicyResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerListenersRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerListenersResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerPolicyRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerPolicyResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerListenersRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerListenersResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerPolicyRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerPolicyResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DependencyThrottleException;
import software.amazon.awssdk.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeAccountLimitsRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeAccountLimitsResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeInstanceHealthRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeInstanceHealthResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerAttributesRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerAttributesResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerPoliciesRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerPoliciesResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancersRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancersResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeTagsRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeTagsResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DuplicateListenerException;
import software.amazon.awssdk.services.elasticloadbalancing.model.DuplicateLoadBalancerNameException;
import software.amazon.awssdk.services.elasticloadbalancing.model.DuplicatePolicyNameException;
import software.amazon.awssdk.services.elasticloadbalancing.model.DuplicateTagKeysException;
import software.amazon.awssdk.services.elasticloadbalancing.model.ElasticLoadBalancingException;
import software.amazon.awssdk.services.elasticloadbalancing.model.ElasticLoadBalancingRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.InvalidConfigurationRequestException;
import software.amazon.awssdk.services.elasticloadbalancing.model.InvalidInstanceException;
import software.amazon.awssdk.services.elasticloadbalancing.model.InvalidSchemeException;
import software.amazon.awssdk.services.elasticloadbalancing.model.InvalidSecurityGroupException;
import software.amazon.awssdk.services.elasticloadbalancing.model.InvalidSubnetException;
import software.amazon.awssdk.services.elasticloadbalancing.model.ListenerNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerAttributeNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.OperationNotPermittedException;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyTypeNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.RemoveTagsRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.RemoveTagsResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerListenerSslCertificateRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerListenerSslCertificateResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.SubnetNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancing.model.TooManyLoadBalancersException;
import software.amazon.awssdk.services.elasticloadbalancing.model.TooManyPoliciesException;
import software.amazon.awssdk.services.elasticloadbalancing.model.TooManyTagsException;
import software.amazon.awssdk.services.elasticloadbalancing.model.UnsupportedProtocolException;
import software.amazon.awssdk.services.elasticloadbalancing.paginators.DescribeLoadBalancersIterable;
import software.amazon.awssdk.services.elasticloadbalancing.transform.AddTagsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.ApplySecurityGroupsToLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.AttachLoadBalancerToSubnetsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.ConfigureHealthCheckRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.CreateAppCookieStickinessPolicyRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.CreateLbCookieStickinessPolicyRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.CreateLoadBalancerListenersRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.CreateLoadBalancerPolicyRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.CreateLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DeleteLoadBalancerListenersRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DeleteLoadBalancerPolicyRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DeleteLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DeregisterInstancesFromLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DescribeAccountLimitsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DescribeInstanceHealthRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DescribeLoadBalancerAttributesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DescribeLoadBalancerPoliciesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DescribeLoadBalancerPolicyTypesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DescribeLoadBalancersRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DescribeTagsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DetachLoadBalancerFromSubnetsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DisableAvailabilityZonesForLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.EnableAvailabilityZonesForLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.ModifyLoadBalancerAttributesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.RegisterInstancesWithLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.RemoveTagsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.SetLoadBalancerListenerSslCertificateRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.SetLoadBalancerPoliciesForBackendServerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.SetLoadBalancerPoliciesOfListenerRequestMarshaller;

@SdkInternalApi
final class DefaultElasticLoadBalancingClient
implements ElasticLoadBalancingClient {
    private final SyncClientHandler clientHandler;
    private final AwsQueryProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultElasticLoadBalancingClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init();
    }

    public final String serviceName() {
        return "elasticloadbalancing";
    }

    @Override
    public AddTagsResponse addTags(AddTagsRequest addTagsRequest) throws LoadBalancerNotFoundException, TooManyTagsException, DuplicateTagKeysException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AddTagsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (AddTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addTagsRequest).withMarshaller((Marshaller)new AddTagsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ApplySecurityGroupsToLoadBalancerResponse applySecurityGroupsToLoadBalancer(ApplySecurityGroupsToLoadBalancerRequest applySecurityGroupsToLoadBalancerRequest) throws LoadBalancerNotFoundException, InvalidConfigurationRequestException, InvalidSecurityGroupException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ApplySecurityGroupsToLoadBalancerResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ApplySecurityGroupsToLoadBalancerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ApplySecurityGroupsToLoadBalancer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)applySecurityGroupsToLoadBalancerRequest).withMarshaller((Marshaller)new ApplySecurityGroupsToLoadBalancerRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public AttachLoadBalancerToSubnetsResponse attachLoadBalancerToSubnets(AttachLoadBalancerToSubnetsRequest attachLoadBalancerToSubnetsRequest) throws LoadBalancerNotFoundException, InvalidConfigurationRequestException, SubnetNotFoundException, InvalidSubnetException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AttachLoadBalancerToSubnetsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (AttachLoadBalancerToSubnetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AttachLoadBalancerToSubnets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)attachLoadBalancerToSubnetsRequest).withMarshaller((Marshaller)new AttachLoadBalancerToSubnetsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ConfigureHealthCheckResponse configureHealthCheck(ConfigureHealthCheckRequest configureHealthCheckRequest) throws LoadBalancerNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ConfigureHealthCheckResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ConfigureHealthCheckResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ConfigureHealthCheck").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)configureHealthCheckRequest).withMarshaller((Marshaller)new ConfigureHealthCheckRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateAppCookieStickinessPolicyResponse createAppCookieStickinessPolicy(CreateAppCookieStickinessPolicyRequest createAppCookieStickinessPolicyRequest) throws LoadBalancerNotFoundException, DuplicatePolicyNameException, TooManyPoliciesException, InvalidConfigurationRequestException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateAppCookieStickinessPolicyResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateAppCookieStickinessPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAppCookieStickinessPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createAppCookieStickinessPolicyRequest).withMarshaller((Marshaller)new CreateAppCookieStickinessPolicyRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateLbCookieStickinessPolicyResponse createLBCookieStickinessPolicy(CreateLbCookieStickinessPolicyRequest createLbCookieStickinessPolicyRequest) throws LoadBalancerNotFoundException, DuplicatePolicyNameException, TooManyPoliciesException, InvalidConfigurationRequestException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateLbCookieStickinessPolicyResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateLbCookieStickinessPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLBCookieStickinessPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createLbCookieStickinessPolicyRequest).withMarshaller((Marshaller)new CreateLbCookieStickinessPolicyRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateLoadBalancerResponse createLoadBalancer(CreateLoadBalancerRequest createLoadBalancerRequest) throws DuplicateLoadBalancerNameException, TooManyLoadBalancersException, CertificateNotFoundException, InvalidConfigurationRequestException, SubnetNotFoundException, InvalidSubnetException, InvalidSecurityGroupException, InvalidSchemeException, TooManyTagsException, DuplicateTagKeysException, UnsupportedProtocolException, OperationNotPermittedException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateLoadBalancerResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateLoadBalancerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLoadBalancer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createLoadBalancerRequest).withMarshaller((Marshaller)new CreateLoadBalancerRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateLoadBalancerListenersResponse createLoadBalancerListeners(CreateLoadBalancerListenersRequest createLoadBalancerListenersRequest) throws LoadBalancerNotFoundException, DuplicateListenerException, CertificateNotFoundException, InvalidConfigurationRequestException, UnsupportedProtocolException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateLoadBalancerListenersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateLoadBalancerListenersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLoadBalancerListeners").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createLoadBalancerListenersRequest).withMarshaller((Marshaller)new CreateLoadBalancerListenersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateLoadBalancerPolicyResponse createLoadBalancerPolicy(CreateLoadBalancerPolicyRequest createLoadBalancerPolicyRequest) throws LoadBalancerNotFoundException, PolicyTypeNotFoundException, DuplicatePolicyNameException, TooManyPoliciesException, InvalidConfigurationRequestException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateLoadBalancerPolicyResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateLoadBalancerPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLoadBalancerPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createLoadBalancerPolicyRequest).withMarshaller((Marshaller)new CreateLoadBalancerPolicyRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteLoadBalancerResponse deleteLoadBalancer(DeleteLoadBalancerRequest deleteLoadBalancerRequest) throws AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteLoadBalancerResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteLoadBalancerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLoadBalancer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteLoadBalancerRequest).withMarshaller((Marshaller)new DeleteLoadBalancerRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteLoadBalancerListenersResponse deleteLoadBalancerListeners(DeleteLoadBalancerListenersRequest deleteLoadBalancerListenersRequest) throws LoadBalancerNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteLoadBalancerListenersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteLoadBalancerListenersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLoadBalancerListeners").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteLoadBalancerListenersRequest).withMarshaller((Marshaller)new DeleteLoadBalancerListenersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteLoadBalancerPolicyResponse deleteLoadBalancerPolicy(DeleteLoadBalancerPolicyRequest deleteLoadBalancerPolicyRequest) throws LoadBalancerNotFoundException, InvalidConfigurationRequestException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteLoadBalancerPolicyResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteLoadBalancerPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLoadBalancerPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteLoadBalancerPolicyRequest).withMarshaller((Marshaller)new DeleteLoadBalancerPolicyRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeregisterInstancesFromLoadBalancerResponse deregisterInstancesFromLoadBalancer(DeregisterInstancesFromLoadBalancerRequest deregisterInstancesFromLoadBalancerRequest) throws LoadBalancerNotFoundException, InvalidInstanceException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeregisterInstancesFromLoadBalancerResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeregisterInstancesFromLoadBalancerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterInstancesFromLoadBalancer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deregisterInstancesFromLoadBalancerRequest).withMarshaller((Marshaller)new DeregisterInstancesFromLoadBalancerRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeAccountLimitsResponse describeAccountLimits(DescribeAccountLimitsRequest describeAccountLimitsRequest) throws AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeAccountLimitsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeAccountLimitsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAccountLimits").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAccountLimitsRequest).withMarshaller((Marshaller)new DescribeAccountLimitsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeInstanceHealthResponse describeInstanceHealth(DescribeInstanceHealthRequest describeInstanceHealthRequest) throws LoadBalancerNotFoundException, InvalidInstanceException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeInstanceHealthResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeInstanceHealthResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeInstanceHealth").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeInstanceHealthRequest).withMarshaller((Marshaller)new DescribeInstanceHealthRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeLoadBalancerAttributesResponse describeLoadBalancerAttributes(DescribeLoadBalancerAttributesRequest describeLoadBalancerAttributesRequest) throws LoadBalancerNotFoundException, LoadBalancerAttributeNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeLoadBalancerAttributesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeLoadBalancerAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLoadBalancerAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeLoadBalancerAttributesRequest).withMarshaller((Marshaller)new DescribeLoadBalancerAttributesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeLoadBalancerPoliciesResponse describeLoadBalancerPolicies(DescribeLoadBalancerPoliciesRequest describeLoadBalancerPoliciesRequest) throws LoadBalancerNotFoundException, PolicyNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeLoadBalancerPoliciesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeLoadBalancerPoliciesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLoadBalancerPolicies").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeLoadBalancerPoliciesRequest).withMarshaller((Marshaller)new DescribeLoadBalancerPoliciesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeLoadBalancerPolicyTypesResponse describeLoadBalancerPolicyTypes(DescribeLoadBalancerPolicyTypesRequest describeLoadBalancerPolicyTypesRequest) throws PolicyTypeNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeLoadBalancerPolicyTypesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeLoadBalancerPolicyTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLoadBalancerPolicyTypes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeLoadBalancerPolicyTypesRequest).withMarshaller((Marshaller)new DescribeLoadBalancerPolicyTypesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeLoadBalancersResponse describeLoadBalancers(DescribeLoadBalancersRequest describeLoadBalancersRequest) throws LoadBalancerNotFoundException, DependencyThrottleException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeLoadBalancersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeLoadBalancersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLoadBalancers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeLoadBalancersRequest).withMarshaller((Marshaller)new DescribeLoadBalancersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeLoadBalancersIterable describeLoadBalancersPaginator(DescribeLoadBalancersRequest describeLoadBalancersRequest) throws LoadBalancerNotFoundException, DependencyThrottleException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        return new DescribeLoadBalancersIterable(this, this.applyPaginatorUserAgent(describeLoadBalancersRequest));
    }

    @Override
    public DescribeTagsResponse describeTags(DescribeTagsRequest describeTagsRequest) throws LoadBalancerNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeTagsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeTagsRequest).withMarshaller((Marshaller)new DescribeTagsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DetachLoadBalancerFromSubnetsResponse detachLoadBalancerFromSubnets(DetachLoadBalancerFromSubnetsRequest detachLoadBalancerFromSubnetsRequest) throws LoadBalancerNotFoundException, InvalidConfigurationRequestException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DetachLoadBalancerFromSubnetsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DetachLoadBalancerFromSubnetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetachLoadBalancerFromSubnets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)detachLoadBalancerFromSubnetsRequest).withMarshaller((Marshaller)new DetachLoadBalancerFromSubnetsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DisableAvailabilityZonesForLoadBalancerResponse disableAvailabilityZonesForLoadBalancer(DisableAvailabilityZonesForLoadBalancerRequest disableAvailabilityZonesForLoadBalancerRequest) throws LoadBalancerNotFoundException, InvalidConfigurationRequestException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DisableAvailabilityZonesForLoadBalancerResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DisableAvailabilityZonesForLoadBalancerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableAvailabilityZonesForLoadBalancer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disableAvailabilityZonesForLoadBalancerRequest).withMarshaller((Marshaller)new DisableAvailabilityZonesForLoadBalancerRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public EnableAvailabilityZonesForLoadBalancerResponse enableAvailabilityZonesForLoadBalancer(EnableAvailabilityZonesForLoadBalancerRequest enableAvailabilityZonesForLoadBalancerRequest) throws LoadBalancerNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(EnableAvailabilityZonesForLoadBalancerResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (EnableAvailabilityZonesForLoadBalancerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableAvailabilityZonesForLoadBalancer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)enableAvailabilityZonesForLoadBalancerRequest).withMarshaller((Marshaller)new EnableAvailabilityZonesForLoadBalancerRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ModifyLoadBalancerAttributesResponse modifyLoadBalancerAttributes(ModifyLoadBalancerAttributesRequest modifyLoadBalancerAttributesRequest) throws LoadBalancerNotFoundException, LoadBalancerAttributeNotFoundException, InvalidConfigurationRequestException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyLoadBalancerAttributesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ModifyLoadBalancerAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyLoadBalancerAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyLoadBalancerAttributesRequest).withMarshaller((Marshaller)new ModifyLoadBalancerAttributesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RegisterInstancesWithLoadBalancerResponse registerInstancesWithLoadBalancer(RegisterInstancesWithLoadBalancerRequest registerInstancesWithLoadBalancerRequest) throws LoadBalancerNotFoundException, InvalidInstanceException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RegisterInstancesWithLoadBalancerResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (RegisterInstancesWithLoadBalancerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterInstancesWithLoadBalancer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)registerInstancesWithLoadBalancerRequest).withMarshaller((Marshaller)new RegisterInstancesWithLoadBalancerRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RemoveTagsResponse removeTags(RemoveTagsRequest removeTagsRequest) throws LoadBalancerNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RemoveTagsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (RemoveTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removeTagsRequest).withMarshaller((Marshaller)new RemoveTagsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SetLoadBalancerListenerSslCertificateResponse setLoadBalancerListenerSSLCertificate(SetLoadBalancerListenerSslCertificateRequest setLoadBalancerListenerSslCertificateRequest) throws CertificateNotFoundException, LoadBalancerNotFoundException, ListenerNotFoundException, InvalidConfigurationRequestException, UnsupportedProtocolException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetLoadBalancerListenerSslCertificateResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (SetLoadBalancerListenerSslCertificateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetLoadBalancerListenerSSLCertificate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setLoadBalancerListenerSslCertificateRequest).withMarshaller((Marshaller)new SetLoadBalancerListenerSslCertificateRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SetLoadBalancerPoliciesForBackendServerResponse setLoadBalancerPoliciesForBackendServer(SetLoadBalancerPoliciesForBackendServerRequest setLoadBalancerPoliciesForBackendServerRequest) throws LoadBalancerNotFoundException, PolicyNotFoundException, InvalidConfigurationRequestException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetLoadBalancerPoliciesForBackendServerResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (SetLoadBalancerPoliciesForBackendServerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetLoadBalancerPoliciesForBackendServer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setLoadBalancerPoliciesForBackendServerRequest).withMarshaller((Marshaller)new SetLoadBalancerPoliciesForBackendServerRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SetLoadBalancerPoliciesOfListenerResponse setLoadBalancerPoliciesOfListener(SetLoadBalancerPoliciesOfListenerRequest setLoadBalancerPoliciesOfListenerRequest) throws LoadBalancerNotFoundException, PolicyNotFoundException, ListenerNotFoundException, InvalidConfigurationRequestException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetLoadBalancerPoliciesOfListenerResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (SetLoadBalancerPoliciesOfListenerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetLoadBalancerPoliciesOfListener").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setLoadBalancerPoliciesOfListenerRequest).withMarshaller((Marshaller)new SetLoadBalancerPoliciesOfListenerRequestMarshaller(this.protocolFactory)));
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedProtocol").exceptionBuilderSupplier(UnsupportedProtocolException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LoadBalancerAttributeNotFound").exceptionBuilderSupplier(LoadBalancerAttributeNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LoadBalancerNotFound").exceptionBuilderSupplier(LoadBalancerNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyLoadBalancers").exceptionBuilderSupplier(TooManyLoadBalancersException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidConfigurationRequest").exceptionBuilderSupplier(InvalidConfigurationRequestException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSecurityGroup").exceptionBuilderSupplier(InvalidSecurityGroupException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicateLoadBalancerName").exceptionBuilderSupplier(DuplicateLoadBalancerNameException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DependencyThrottle").exceptionBuilderSupplier(DependencyThrottleException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OperationNotPermitted").exceptionBuilderSupplier(OperationNotPermittedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PolicyNotFound").exceptionBuilderSupplier(PolicyNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CertificateNotFound").exceptionBuilderSupplier(CertificateNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicateTagKeys").exceptionBuilderSupplier(DuplicateTagKeysException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTags").exceptionBuilderSupplier(TooManyTagsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ListenerNotFound").exceptionBuilderSupplier(ListenerNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyPolicies").exceptionBuilderSupplier(TooManyPoliciesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicatePolicyName").exceptionBuilderSupplier(DuplicatePolicyNameException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SubnetNotFound").exceptionBuilderSupplier(SubnetNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicateListener").exceptionBuilderSupplier(DuplicateListenerException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidScheme").exceptionBuilderSupplier(InvalidSchemeException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PolicyTypeNotFound").exceptionBuilderSupplier(PolicyTypeNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSubnet").exceptionBuilderSupplier(InvalidSubnetException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidInstance").exceptionBuilderSupplier(InvalidInstanceException::builder).httpStatusCode(Integer.valueOf(400)).build()).clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(ElasticLoadBalancingException::builder).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends ElasticLoadBalancingRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.13.30").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((ElasticLoadBalancingRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

