/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for RemoveTags.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RemoveTagsRequest extends ElasticLoadBalancingRequest implements
        ToCopyableBuilder<RemoveTagsRequest.Builder, RemoveTagsRequest> {
    private static final SdkField<List<String>> LOAD_BALANCER_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(RemoveTagsRequest::loadBalancerNames))
            .setter(setter(Builder::loadBalancerNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<TagKeyOnly>> TAGS_FIELD = SdkField
            .<List<TagKeyOnly>> builder(MarshallingType.LIST)
            .getter(getter(RemoveTagsRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TagKeyOnly> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagKeyOnly::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_NAMES_FIELD,
            TAGS_FIELD));

    private final List<String> loadBalancerNames;

    private final List<TagKeyOnly> tags;

    private RemoveTagsRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerNames = builder.loadBalancerNames;
        this.tags = builder.tags;
    }

    /**
     * Returns true if the LoadBalancerNames property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasLoadBalancerNames() {
        return loadBalancerNames != null && !(loadBalancerNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name of the load balancer. You can specify a maximum of one load balancer name.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLoadBalancerNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The name of the load balancer. You can specify a maximum of one load balancer name.
     */
    public List<String> loadBalancerNames() {
        return loadBalancerNames;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of tag keys to remove.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of tag keys to remove.
     */
    public List<TagKeyOnly> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerNames());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveTagsRequest)) {
            return false;
        }
        RemoveTagsRequest other = (RemoveTagsRequest) obj;
        return Objects.equals(loadBalancerNames(), other.loadBalancerNames()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RemoveTagsRequest").add("LoadBalancerNames", loadBalancerNames()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LoadBalancerNames":
            return Optional.ofNullable(clazz.cast(loadBalancerNames()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemoveTagsRequest, T> g) {
        return obj -> g.apply((RemoveTagsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticLoadBalancingRequest.Builder, SdkPojo, CopyableBuilder<Builder, RemoveTagsRequest> {
        /**
         * <p>
         * The name of the load balancer. You can specify a maximum of one load balancer name.
         * </p>
         * 
         * @param loadBalancerNames
         *        The name of the load balancer. You can specify a maximum of one load balancer name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerNames(Collection<String> loadBalancerNames);

        /**
         * <p>
         * The name of the load balancer. You can specify a maximum of one load balancer name.
         * </p>
         * 
         * @param loadBalancerNames
         *        The name of the load balancer. You can specify a maximum of one load balancer name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerNames(String... loadBalancerNames);

        /**
         * <p>
         * The list of tag keys to remove.
         * </p>
         * 
         * @param tags
         *        The list of tag keys to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<TagKeyOnly> tags);

        /**
         * <p>
         * The list of tag keys to remove.
         * </p>
         * 
         * @param tags
         *        The list of tag keys to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(TagKeyOnly... tags);

        /**
         * <p>
         * The list of tag keys to remove.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TagKeyOnly>.Builder} avoiding the need to
         * create one manually via {@link List<TagKeyOnly>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TagKeyOnly>.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<TagKeyOnly>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<TagKeyOnly>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<TagKeyOnly>)
         */
        Builder tags(Consumer<TagKeyOnly.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticLoadBalancingRequest.BuilderImpl implements Builder {
        private List<String> loadBalancerNames = DefaultSdkAutoConstructList.getInstance();

        private List<TagKeyOnly> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveTagsRequest model) {
            super(model);
            loadBalancerNames(model.loadBalancerNames);
            tags(model.tags);
        }

        public final Collection<String> getLoadBalancerNames() {
            return loadBalancerNames;
        }

        @Override
        public final Builder loadBalancerNames(Collection<String> loadBalancerNames) {
            this.loadBalancerNames = LoadBalancerNamesCopier.copy(loadBalancerNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerNames(String... loadBalancerNames) {
            loadBalancerNames(Arrays.asList(loadBalancerNames));
            return this;
        }

        public final void setLoadBalancerNames(Collection<String> loadBalancerNames) {
            this.loadBalancerNames = LoadBalancerNamesCopier.copy(loadBalancerNames);
        }

        public final Collection<TagKeyOnly.Builder> getTags() {
            return tags != null ? tags.stream().map(TagKeyOnly::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<TagKeyOnly> tags) {
            this.tags = TagKeyListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(TagKeyOnly... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<TagKeyOnly.Builder>... tags) {
            tags(Stream.of(tags).map(c -> TagKeyOnly.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<TagKeyOnly.BuilderImpl> tags) {
            this.tags = TagKeyListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RemoveTagsRequest build() {
            return new RemoveTagsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
