/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeLoadBalancers.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLoadBalancersResponse extends ElasticLoadBalancingResponse implements
        ToCopyableBuilder<DescribeLoadBalancersResponse.Builder, DescribeLoadBalancersResponse> {
    private static final SdkField<List<LoadBalancerDescription>> LOAD_BALANCER_DESCRIPTIONS_FIELD = SdkField
            .<List<LoadBalancerDescription>> builder(MarshallingType.LIST)
            .getter(getter(DescribeLoadBalancersResponse::loadBalancerDescriptions))
            .setter(setter(Builder::loadBalancerDescriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerDescriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LoadBalancerDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(LoadBalancerDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeLoadBalancersResponse::nextMarker)).setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LOAD_BALANCER_DESCRIPTIONS_FIELD, NEXT_MARKER_FIELD));

    private final List<LoadBalancerDescription> loadBalancerDescriptions;

    private final String nextMarker;

    private DescribeLoadBalancersResponse(BuilderImpl builder) {
        super(builder);
        this.loadBalancerDescriptions = builder.loadBalancerDescriptions;
        this.nextMarker = builder.nextMarker;
    }

    /**
     * Returns true if the LoadBalancerDescriptions property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasLoadBalancerDescriptions() {
        return loadBalancerDescriptions != null && !(loadBalancerDescriptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the load balancers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLoadBalancerDescriptions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the load balancers.
     */
    public List<LoadBalancerDescription> loadBalancerDescriptions() {
        return loadBalancerDescriptions;
    }

    /**
     * <p>
     * The marker to use when requesting the next set of results. If there are no additional results, the string is
     * empty.
     * </p>
     * 
     * @return The marker to use when requesting the next set of results. If there are no additional results, the string
     *         is empty.
     */
    public String nextMarker() {
        return nextMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerDescriptions());
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLoadBalancersResponse)) {
            return false;
        }
        DescribeLoadBalancersResponse other = (DescribeLoadBalancersResponse) obj;
        return Objects.equals(loadBalancerDescriptions(), other.loadBalancerDescriptions())
                && Objects.equals(nextMarker(), other.nextMarker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeLoadBalancersResponse").add("LoadBalancerDescriptions", loadBalancerDescriptions())
                .add("NextMarker", nextMarker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LoadBalancerDescriptions":
            return Optional.ofNullable(clazz.cast(loadBalancerDescriptions()));
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLoadBalancersResponse, T> g) {
        return obj -> g.apply((DescribeLoadBalancersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticLoadBalancingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeLoadBalancersResponse> {
        /**
         * <p>
         * Information about the load balancers.
         * </p>
         * 
         * @param loadBalancerDescriptions
         *        Information about the load balancers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerDescriptions(Collection<LoadBalancerDescription> loadBalancerDescriptions);

        /**
         * <p>
         * Information about the load balancers.
         * </p>
         * 
         * @param loadBalancerDescriptions
         *        Information about the load balancers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerDescriptions(LoadBalancerDescription... loadBalancerDescriptions);

        /**
         * <p>
         * Information about the load balancers.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LoadBalancerDescription>.Builder} avoiding
         * the need to create one manually via {@link List<LoadBalancerDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LoadBalancerDescription>.Builder#build()} is called
         * immediately and its result is passed to {@link #loadBalancerDescriptions(List<LoadBalancerDescription>)}.
         * 
         * @param loadBalancerDescriptions
         *        a consumer that will call methods on {@link List<LoadBalancerDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loadBalancerDescriptions(List<LoadBalancerDescription>)
         */
        Builder loadBalancerDescriptions(Consumer<LoadBalancerDescription.Builder>... loadBalancerDescriptions);

        /**
         * <p>
         * The marker to use when requesting the next set of results. If there are no additional results, the string is
         * empty.
         * </p>
         * 
         * @param nextMarker
         *        The marker to use when requesting the next set of results. If there are no additional results, the
         *        string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);
    }

    static final class BuilderImpl extends ElasticLoadBalancingResponse.BuilderImpl implements Builder {
        private List<LoadBalancerDescription> loadBalancerDescriptions = DefaultSdkAutoConstructList.getInstance();

        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLoadBalancersResponse model) {
            super(model);
            loadBalancerDescriptions(model.loadBalancerDescriptions);
            nextMarker(model.nextMarker);
        }

        public final Collection<LoadBalancerDescription.Builder> getLoadBalancerDescriptions() {
            return loadBalancerDescriptions != null ? loadBalancerDescriptions.stream().map(LoadBalancerDescription::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder loadBalancerDescriptions(Collection<LoadBalancerDescription> loadBalancerDescriptions) {
            this.loadBalancerDescriptions = LoadBalancerDescriptionsCopier.copy(loadBalancerDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerDescriptions(LoadBalancerDescription... loadBalancerDescriptions) {
            loadBalancerDescriptions(Arrays.asList(loadBalancerDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerDescriptions(Consumer<LoadBalancerDescription.Builder>... loadBalancerDescriptions) {
            loadBalancerDescriptions(Stream.of(loadBalancerDescriptions)
                    .map(c -> LoadBalancerDescription.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLoadBalancerDescriptions(Collection<LoadBalancerDescription.BuilderImpl> loadBalancerDescriptions) {
            this.loadBalancerDescriptions = LoadBalancerDescriptionsCopier.copyFromBuilder(loadBalancerDescriptions);
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public DescribeLoadBalancersResponse build() {
            return new DescribeLoadBalancersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
