/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the <code>ConnectionSettings</code> attribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectionSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectionSettings.Builder, ConnectionSettings> {
    private static final SdkField<Integer> IDLE_TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ConnectionSettings::idleTimeout)).setter(setter(Builder::idleTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdleTimeout").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDLE_TIMEOUT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer idleTimeout;

    private ConnectionSettings(BuilderImpl builder) {
        this.idleTimeout = builder.idleTimeout;
    }

    /**
     * <p>
     * The time, in seconds, that the connection is allowed to be idle (no data has been sent over the connection)
     * before it is closed by the load balancer.
     * </p>
     * 
     * @return The time, in seconds, that the connection is allowed to be idle (no data has been sent over the
     *         connection) before it is closed by the load balancer.
     */
    public Integer idleTimeout() {
        return idleTimeout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(idleTimeout());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionSettings)) {
            return false;
        }
        ConnectionSettings other = (ConnectionSettings) obj;
        return Objects.equals(idleTimeout(), other.idleTimeout());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ConnectionSettings").add("IdleTimeout", idleTimeout()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdleTimeout":
            return Optional.ofNullable(clazz.cast(idleTimeout()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectionSettings, T> g) {
        return obj -> g.apply((ConnectionSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectionSettings> {
        /**
         * <p>
         * The time, in seconds, that the connection is allowed to be idle (no data has been sent over the connection)
         * before it is closed by the load balancer.
         * </p>
         * 
         * @param idleTimeout
         *        The time, in seconds, that the connection is allowed to be idle (no data has been sent over the
         *        connection) before it is closed by the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idleTimeout(Integer idleTimeout);
    }

    static final class BuilderImpl implements Builder {
        private Integer idleTimeout;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionSettings model) {
            idleTimeout(model.idleTimeout);
        }

        public final Integer getIdleTimeout() {
            return idleTimeout;
        }

        @Override
        public final Builder idleTimeout(Integer idleTimeout) {
            this.idleTimeout = idleTimeout;
            return this;
        }

        public final void setIdleTimeout(Integer idleTimeout) {
            this.idleTimeout = idleTimeout;
        }

        @Override
        public ConnectionSettings build() {
            return new ConnectionSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
