/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the <code>AccessLog</code> attribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccessLog implements SdkPojo, Serializable, ToCopyableBuilder<AccessLog.Builder, AccessLog> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(AccessLog::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AccessLog::s3BucketName)).setter(setter(Builder::s3BucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName").build()).build();

    private static final SdkField<Integer> EMIT_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(AccessLog::emitInterval)).setter(setter(Builder::emitInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmitInterval").build()).build();

    private static final SdkField<String> S3_BUCKET_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AccessLog::s3BucketPrefix)).setter(setter(Builder::s3BucketPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketPrefix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            S3_BUCKET_NAME_FIELD, EMIT_INTERVAL_FIELD, S3_BUCKET_PREFIX_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final String s3BucketName;

    private final Integer emitInterval;

    private final String s3BucketPrefix;

    private AccessLog(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.s3BucketName = builder.s3BucketName;
        this.emitInterval = builder.emitInterval;
        this.s3BucketPrefix = builder.s3BucketPrefix;
    }

    /**
     * <p>
     * Specifies whether access logs are enabled for the load balancer.
     * </p>
     * 
     * @return Specifies whether access logs are enabled for the load balancer.
     */
    public Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The name of the Amazon S3 bucket where the access logs are stored.
     * </p>
     * 
     * @return The name of the Amazon S3 bucket where the access logs are stored.
     */
    public String s3BucketName() {
        return s3BucketName;
    }

    /**
     * <p>
     * The interval for publishing the access logs. You can specify an interval of either 5 minutes or 60 minutes.
     * </p>
     * <p>
     * Default: 60 minutes
     * </p>
     * 
     * @return The interval for publishing the access logs. You can specify an interval of either 5 minutes or 60
     *         minutes.</p>
     *         <p>
     *         Default: 60 minutes
     */
    public Integer emitInterval() {
        return emitInterval;
    }

    /**
     * <p>
     * The logical hierarchy you created for your Amazon S3 bucket, for example <code>my-bucket-prefix/prod</code>. If
     * the prefix is not provided, the log is placed at the root level of the bucket.
     * </p>
     * 
     * @return The logical hierarchy you created for your Amazon S3 bucket, for example
     *         <code>my-bucket-prefix/prod</code>. If the prefix is not provided, the log is placed at the root level of
     *         the bucket.
     */
    public String s3BucketPrefix() {
        return s3BucketPrefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(emitInterval());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketPrefix());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessLog)) {
            return false;
        }
        AccessLog other = (AccessLog) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(s3BucketName(), other.s3BucketName())
                && Objects.equals(emitInterval(), other.emitInterval())
                && Objects.equals(s3BucketPrefix(), other.s3BucketPrefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AccessLog").add("Enabled", enabled()).add("S3BucketName", s3BucketName())
                .add("EmitInterval", emitInterval()).add("S3BucketPrefix", s3BucketPrefix()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "S3BucketName":
            return Optional.ofNullable(clazz.cast(s3BucketName()));
        case "EmitInterval":
            return Optional.ofNullable(clazz.cast(emitInterval()));
        case "S3BucketPrefix":
            return Optional.ofNullable(clazz.cast(s3BucketPrefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccessLog, T> g) {
        return obj -> g.apply((AccessLog) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccessLog> {
        /**
         * <p>
         * Specifies whether access logs are enabled for the load balancer.
         * </p>
         * 
         * @param enabled
         *        Specifies whether access logs are enabled for the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The name of the Amazon S3 bucket where the access logs are stored.
         * </p>
         * 
         * @param s3BucketName
         *        The name of the Amazon S3 bucket where the access logs are stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketName(String s3BucketName);

        /**
         * <p>
         * The interval for publishing the access logs. You can specify an interval of either 5 minutes or 60 minutes.
         * </p>
         * <p>
         * Default: 60 minutes
         * </p>
         * 
         * @param emitInterval
         *        The interval for publishing the access logs. You can specify an interval of either 5 minutes or 60
         *        minutes.</p>
         *        <p>
         *        Default: 60 minutes
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emitInterval(Integer emitInterval);

        /**
         * <p>
         * The logical hierarchy you created for your Amazon S3 bucket, for example <code>my-bucket-prefix/prod</code>.
         * If the prefix is not provided, the log is placed at the root level of the bucket.
         * </p>
         * 
         * @param s3BucketPrefix
         *        The logical hierarchy you created for your Amazon S3 bucket, for example
         *        <code>my-bucket-prefix/prod</code>. If the prefix is not provided, the log is placed at the root level
         *        of the bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketPrefix(String s3BucketPrefix);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private String s3BucketName;

        private Integer emitInterval;

        private String s3BucketPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessLog model) {
            enabled(model.enabled);
            s3BucketName(model.s3BucketName);
            emitInterval(model.emitInterval);
            s3BucketPrefix(model.s3BucketPrefix);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getS3BucketName() {
            return s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        public final Integer getEmitInterval() {
            return emitInterval;
        }

        @Override
        public final Builder emitInterval(Integer emitInterval) {
            this.emitInterval = emitInterval;
            return this;
        }

        public final void setEmitInterval(Integer emitInterval) {
            this.emitInterval = emitInterval;
        }

        public final String getS3BucketPrefix() {
            return s3BucketPrefix;
        }

        @Override
        public final Builder s3BucketPrefix(String s3BucketPrefix) {
            this.s3BucketPrefix = s3BucketPrefix;
            return this;
        }

        public final void setS3BucketPrefix(String s3BucketPrefix) {
            this.s3BucketPrefix = s3BucketPrefix;
        }

        @Override
        public AccessLog build() {
            return new AccessLog(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
