/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeLoadBalancerPolicies.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLoadBalancerPoliciesResponse extends ElasticLoadBalancingResponse implements
        ToCopyableBuilder<DescribeLoadBalancerPoliciesResponse.Builder, DescribeLoadBalancerPoliciesResponse> {
    private static final SdkField<List<PolicyDescription>> POLICY_DESCRIPTIONS_FIELD = SdkField
            .<List<PolicyDescription>> builder(MarshallingType.LIST)
            .getter(getter(DescribeLoadBalancerPoliciesResponse::policyDescriptions))
            .setter(setter(Builder::policyDescriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyDescriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PolicyDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(PolicyDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_DESCRIPTIONS_FIELD));

    private final List<PolicyDescription> policyDescriptions;

    private DescribeLoadBalancerPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.policyDescriptions = builder.policyDescriptions;
    }

    /**
     * Returns true if the PolicyDescriptions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasPolicyDescriptions() {
        return policyDescriptions != null && !(policyDescriptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the policies.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPolicyDescriptions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the policies.
     */
    public List<PolicyDescription> policyDescriptions() {
        return policyDescriptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyDescriptions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLoadBalancerPoliciesResponse)) {
            return false;
        }
        DescribeLoadBalancerPoliciesResponse other = (DescribeLoadBalancerPoliciesResponse) obj;
        return Objects.equals(policyDescriptions(), other.policyDescriptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeLoadBalancerPoliciesResponse").add("PolicyDescriptions", policyDescriptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyDescriptions":
            return Optional.ofNullable(clazz.cast(policyDescriptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLoadBalancerPoliciesResponse, T> g) {
        return obj -> g.apply((DescribeLoadBalancerPoliciesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticLoadBalancingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeLoadBalancerPoliciesResponse> {
        /**
         * <p>
         * Information about the policies.
         * </p>
         * 
         * @param policyDescriptions
         *        Information about the policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDescriptions(Collection<PolicyDescription> policyDescriptions);

        /**
         * <p>
         * Information about the policies.
         * </p>
         * 
         * @param policyDescriptions
         *        Information about the policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDescriptions(PolicyDescription... policyDescriptions);

        /**
         * <p>
         * Information about the policies.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PolicyDescription>.Builder} avoiding the
         * need to create one manually via {@link List<PolicyDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PolicyDescription>.Builder#build()} is called immediately
         * and its result is passed to {@link #policyDescriptions(List<PolicyDescription>)}.
         * 
         * @param policyDescriptions
         *        a consumer that will call methods on {@link List<PolicyDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policyDescriptions(List<PolicyDescription>)
         */
        Builder policyDescriptions(Consumer<PolicyDescription.Builder>... policyDescriptions);
    }

    static final class BuilderImpl extends ElasticLoadBalancingResponse.BuilderImpl implements Builder {
        private List<PolicyDescription> policyDescriptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLoadBalancerPoliciesResponse model) {
            super(model);
            policyDescriptions(model.policyDescriptions);
        }

        public final Collection<PolicyDescription.Builder> getPolicyDescriptions() {
            return policyDescriptions != null ? policyDescriptions.stream().map(PolicyDescription::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder policyDescriptions(Collection<PolicyDescription> policyDescriptions) {
            this.policyDescriptions = PolicyDescriptionsCopier.copy(policyDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyDescriptions(PolicyDescription... policyDescriptions) {
            policyDescriptions(Arrays.asList(policyDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyDescriptions(Consumer<PolicyDescription.Builder>... policyDescriptions) {
            policyDescriptions(Stream.of(policyDescriptions).map(c -> PolicyDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPolicyDescriptions(Collection<PolicyDescription.BuilderImpl> policyDescriptions) {
            this.policyDescriptions = PolicyDescriptionsCopier.copyFromBuilder(policyDescriptions);
        }

        @Override
        public DescribeLoadBalancerPoliciesResponse build() {
            return new DescribeLoadBalancerPoliciesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
