/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.model.AppCookieStickinessPolicy;
import software.amazon.awssdk.services.elasticloadbalancing.model.LBCookieStickinessPolicy;
import software.amazon.awssdk.services.elasticloadbalancing.model.Policies;
import software.amazon.awssdk.services.elasticloadbalancing.transform.AppCookieStickinessPolicyUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.LBCookieStickinessPolicyUnmarshaller;

public class PoliciesUnmarshaller
implements Unmarshaller<Policies, StaxUnmarshallerContext> {
    private static final PoliciesUnmarshaller INSTANCE = new PoliciesUnmarshaller();

    public Policies unmarshall(StaxUnmarshallerContext context) throws Exception {
        Policies.Builder policies;
        block9: {
            policies = Policies.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<AppCookieStickinessPolicy> appCookieStickinessPolicies = null;
            ArrayList<LBCookieStickinessPolicy> lbCookieStickinessPolicies = null;
            ArrayList<String> otherPolicies = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    policies.appCookieStickinessPolicies(appCookieStickinessPolicies);
                    policies.lbCookieStickinessPolicies(lbCookieStickinessPolicies);
                    policies.otherPolicies(otherPolicies);
                    break block9;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("AppCookieStickinessPolicies", targetDepth)) {
                        appCookieStickinessPolicies = new ArrayList<AppCookieStickinessPolicy>();
                        continue;
                    }
                    if (context.testExpression("AppCookieStickinessPolicies/member", targetDepth)) {
                        appCookieStickinessPolicies.add(AppCookieStickinessPolicyUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("LBCookieStickinessPolicies", targetDepth)) {
                        lbCookieStickinessPolicies = new ArrayList<LBCookieStickinessPolicy>();
                        continue;
                    }
                    if (context.testExpression("LBCookieStickinessPolicies/member", targetDepth)) {
                        lbCookieStickinessPolicies.add(LBCookieStickinessPolicyUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("OtherPolicies", targetDepth)) {
                        otherPolicies = new ArrayList<String>();
                        continue;
                    }
                    if (!context.testExpression("OtherPolicies/member", targetDepth)) continue;
                    otherPolicies.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            policies.appCookieStickinessPolicies(appCookieStickinessPolicies);
            policies.lbCookieStickinessPolicies(lbCookieStickinessPolicies);
            policies.otherPolicies(otherPolicies);
        }
        return (Policies)policies.build();
    }

    public static PoliciesUnmarshaller getInstance() {
        return INSTANCE;
    }
}

