/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerPolicyRequest;
import software.amazon.awssdk.util.StringUtils;

public class DeleteLoadBalancerPolicyRequestMarshaller
implements Marshaller<Request<DeleteLoadBalancerPolicyRequest>, DeleteLoadBalancerPolicyRequest> {
    public Request<DeleteLoadBalancerPolicyRequest> marshall(DeleteLoadBalancerPolicyRequest deleteLoadBalancerPolicyRequest) {
        if (deleteLoadBalancerPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteLoadBalancerPolicyRequest, "ElasticLoadBalancingClient");
        request.addParameter("Action", "DeleteLoadBalancerPolicy");
        request.addParameter("Version", "2012-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteLoadBalancerPolicyRequest.loadBalancerName() != null) {
            request.addParameter("LoadBalancerName", StringUtils.fromString((String)deleteLoadBalancerPolicyRequest.loadBalancerName()));
        }
        if (deleteLoadBalancerPolicyRequest.policyName() != null) {
            request.addParameter("PolicyName", StringUtils.fromString((String)deleteLoadBalancerPolicyRequest.policyName()));
        }
        return request;
    }
}

