/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.elasticloadbalancing.model.AvailabilityZonesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DisableAvailabilityZonesForLoadBalancerResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DisableAvailabilityZonesForLoadBalancerResponse> {
    private final List<String> availabilityZones;

    private DisableAvailabilityZonesForLoadBalancerResponse(BuilderImpl builder) {
        this.availabilityZones = builder.availabilityZones;
    }

    public List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.availabilityZones() == null ? 0 : this.availabilityZones().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisableAvailabilityZonesForLoadBalancerResponse)) {
            return false;
        }
        DisableAvailabilityZonesForLoadBalancerResponse other = (DisableAvailabilityZonesForLoadBalancerResponse)((Object)obj);
        if (other.availabilityZones() == null ^ this.availabilityZones() == null) {
            return false;
        }
        return other.availabilityZones() == null || other.availabilityZones().equals(this.availabilityZones());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.availabilityZones() != null) {
            sb.append("AvailabilityZones: ").append(this.availabilityZones()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> availabilityZones;

        private BuilderImpl() {
        }

        private BuilderImpl(DisableAvailabilityZonesForLoadBalancerResponse model) {
            this.setAvailabilityZones(model.availabilityZones);
        }

        public final Collection<String> getAvailabilityZones() {
            return this.availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
        }

        public DisableAvailabilityZonesForLoadBalancerResponse build() {
            return new DisableAvailabilityZonesForLoadBalancerResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DisableAvailabilityZonesForLoadBalancerResponse> {
        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);
    }
}

