/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyTypeDescription;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyTypeDescriptionsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeLoadBalancerPolicyTypesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeLoadBalancerPolicyTypesResponse> {
    private final List<PolicyTypeDescription> policyTypeDescriptions;

    private DescribeLoadBalancerPolicyTypesResponse(BuilderImpl builder) {
        this.policyTypeDescriptions = builder.policyTypeDescriptions;
    }

    public List<PolicyTypeDescription> policyTypeDescriptions() {
        return this.policyTypeDescriptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.policyTypeDescriptions() == null ? 0 : this.policyTypeDescriptions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLoadBalancerPolicyTypesResponse)) {
            return false;
        }
        DescribeLoadBalancerPolicyTypesResponse other = (DescribeLoadBalancerPolicyTypesResponse)((Object)obj);
        if (other.policyTypeDescriptions() == null ^ this.policyTypeDescriptions() == null) {
            return false;
        }
        return other.policyTypeDescriptions() == null || other.policyTypeDescriptions().equals(this.policyTypeDescriptions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.policyTypeDescriptions() != null) {
            sb.append("PolicyTypeDescriptions: ").append(this.policyTypeDescriptions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<PolicyTypeDescription> policyTypeDescriptions;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLoadBalancerPolicyTypesResponse model) {
            this.setPolicyTypeDescriptions(model.policyTypeDescriptions);
        }

        public final Collection<PolicyTypeDescription> getPolicyTypeDescriptions() {
            return this.policyTypeDescriptions;
        }

        @Override
        public final Builder policyTypeDescriptions(Collection<PolicyTypeDescription> policyTypeDescriptions) {
            this.policyTypeDescriptions = PolicyTypeDescriptionsCopier.copy(policyTypeDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyTypeDescriptions(PolicyTypeDescription ... policyTypeDescriptions) {
            this.policyTypeDescriptions(Arrays.asList(policyTypeDescriptions));
            return this;
        }

        public final void setPolicyTypeDescriptions(Collection<PolicyTypeDescription> policyTypeDescriptions) {
            this.policyTypeDescriptions = PolicyTypeDescriptionsCopier.copy(policyTypeDescriptions);
        }

        public DescribeLoadBalancerPolicyTypesResponse build() {
            return new DescribeLoadBalancerPolicyTypesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeLoadBalancerPolicyTypesResponse> {
        public Builder policyTypeDescriptions(Collection<PolicyTypeDescription> var1);

        public Builder policyTypeDescriptions(PolicyTypeDescription ... var1);
    }
}

