/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.SecurityGroupsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ApplySecurityGroupsToLoadBalancerRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ApplySecurityGroupsToLoadBalancerRequest> {
    private final String loadBalancerName;
    private final List<String> securityGroups;

    private ApplySecurityGroupsToLoadBalancerRequest(BuilderImpl builder) {
        this.loadBalancerName = builder.loadBalancerName;
        this.securityGroups = builder.securityGroups;
    }

    public String loadBalancerName() {
        return this.loadBalancerName;
    }

    public List<String> securityGroups() {
        return this.securityGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.loadBalancerName() == null ? 0 : this.loadBalancerName().hashCode());
        hashCode = 31 * hashCode + (this.securityGroups() == null ? 0 : this.securityGroups().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplySecurityGroupsToLoadBalancerRequest)) {
            return false;
        }
        ApplySecurityGroupsToLoadBalancerRequest other = (ApplySecurityGroupsToLoadBalancerRequest)((Object)obj);
        if (other.loadBalancerName() == null ^ this.loadBalancerName() == null) {
            return false;
        }
        if (other.loadBalancerName() != null && !other.loadBalancerName().equals(this.loadBalancerName())) {
            return false;
        }
        if (other.securityGroups() == null ^ this.securityGroups() == null) {
            return false;
        }
        return other.securityGroups() == null || other.securityGroups().equals(this.securityGroups());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.loadBalancerName() != null) {
            sb.append("LoadBalancerName: ").append(this.loadBalancerName()).append(",");
        }
        if (this.securityGroups() != null) {
            sb.append("SecurityGroups: ").append(this.securityGroups()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String loadBalancerName;
        private List<String> securityGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplySecurityGroupsToLoadBalancerRequest model) {
            this.setLoadBalancerName(model.loadBalancerName);
            this.setSecurityGroups(model.securityGroups);
        }

        public final String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        public final Collection<String> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
        }

        public ApplySecurityGroupsToLoadBalancerRequest build() {
            return new ApplySecurityGroupsToLoadBalancerRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ApplySecurityGroupsToLoadBalancerRequest> {
        public Builder loadBalancerName(String var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);
    }
}

