/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyAttribute;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyAttributesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateLoadBalancerPolicyRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateLoadBalancerPolicyRequest> {
    private final String loadBalancerName;
    private final String policyName;
    private final String policyTypeName;
    private final List<PolicyAttribute> policyAttributes;

    private CreateLoadBalancerPolicyRequest(BuilderImpl builder) {
        this.loadBalancerName = builder.loadBalancerName;
        this.policyName = builder.policyName;
        this.policyTypeName = builder.policyTypeName;
        this.policyAttributes = builder.policyAttributes;
    }

    public String loadBalancerName() {
        return this.loadBalancerName;
    }

    public String policyName() {
        return this.policyName;
    }

    public String policyTypeName() {
        return this.policyTypeName;
    }

    public List<PolicyAttribute> policyAttributes() {
        return this.policyAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.loadBalancerName() == null ? 0 : this.loadBalancerName().hashCode());
        hashCode = 31 * hashCode + (this.policyName() == null ? 0 : this.policyName().hashCode());
        hashCode = 31 * hashCode + (this.policyTypeName() == null ? 0 : this.policyTypeName().hashCode());
        hashCode = 31 * hashCode + (this.policyAttributes() == null ? 0 : this.policyAttributes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLoadBalancerPolicyRequest)) {
            return false;
        }
        CreateLoadBalancerPolicyRequest other = (CreateLoadBalancerPolicyRequest)((Object)obj);
        if (other.loadBalancerName() == null ^ this.loadBalancerName() == null) {
            return false;
        }
        if (other.loadBalancerName() != null && !other.loadBalancerName().equals(this.loadBalancerName())) {
            return false;
        }
        if (other.policyName() == null ^ this.policyName() == null) {
            return false;
        }
        if (other.policyName() != null && !other.policyName().equals(this.policyName())) {
            return false;
        }
        if (other.policyTypeName() == null ^ this.policyTypeName() == null) {
            return false;
        }
        if (other.policyTypeName() != null && !other.policyTypeName().equals(this.policyTypeName())) {
            return false;
        }
        if (other.policyAttributes() == null ^ this.policyAttributes() == null) {
            return false;
        }
        return other.policyAttributes() == null || other.policyAttributes().equals(this.policyAttributes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.loadBalancerName() != null) {
            sb.append("LoadBalancerName: ").append(this.loadBalancerName()).append(",");
        }
        if (this.policyName() != null) {
            sb.append("PolicyName: ").append(this.policyName()).append(",");
        }
        if (this.policyTypeName() != null) {
            sb.append("PolicyTypeName: ").append(this.policyTypeName()).append(",");
        }
        if (this.policyAttributes() != null) {
            sb.append("PolicyAttributes: ").append(this.policyAttributes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String loadBalancerName;
        private String policyName;
        private String policyTypeName;
        private List<PolicyAttribute> policyAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLoadBalancerPolicyRequest model) {
            this.setLoadBalancerName(model.loadBalancerName);
            this.setPolicyName(model.policyName);
            this.setPolicyTypeName(model.policyTypeName);
            this.setPolicyAttributes(model.policyAttributes);
        }

        public final String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getPolicyTypeName() {
            return this.policyTypeName;
        }

        @Override
        public final Builder policyTypeName(String policyTypeName) {
            this.policyTypeName = policyTypeName;
            return this;
        }

        public final void setPolicyTypeName(String policyTypeName) {
            this.policyTypeName = policyTypeName;
        }

        public final Collection<PolicyAttribute> getPolicyAttributes() {
            return this.policyAttributes;
        }

        @Override
        public final Builder policyAttributes(Collection<PolicyAttribute> policyAttributes) {
            this.policyAttributes = PolicyAttributesCopier.copy(policyAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyAttributes(PolicyAttribute ... policyAttributes) {
            this.policyAttributes(Arrays.asList(policyAttributes));
            return this;
        }

        public final void setPolicyAttributes(Collection<PolicyAttribute> policyAttributes) {
            this.policyAttributes = PolicyAttributesCopier.copy(policyAttributes);
        }

        public CreateLoadBalancerPolicyRequest build() {
            return new CreateLoadBalancerPolicyRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateLoadBalancerPolicyRequest> {
        public Builder loadBalancerName(String var1);

        public Builder policyName(String var1);

        public Builder policyTypeName(String var1);

        public Builder policyAttributes(Collection<PolicyAttribute> var1);

        public Builder policyAttributes(PolicyAttribute ... var1);
    }
}

