/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.model.BackendServerDescription;
import software.amazon.awssdk.services.elasticloadbalancing.model.Instance;
import software.amazon.awssdk.services.elasticloadbalancing.model.ListenerDescription;
import software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerDescription;
import software.amazon.awssdk.services.elasticloadbalancing.transform.BackendServerDescriptionUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.HealthCheckUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.InstanceUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.ListenerDescriptionUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.PoliciesUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.SourceSecurityGroupUnmarshaller;

public class LoadBalancerDescriptionUnmarshaller
implements Unmarshaller<LoadBalancerDescription, StaxUnmarshallerContext> {
    private static LoadBalancerDescriptionUnmarshaller INSTANCE;

    public LoadBalancerDescription unmarshall(StaxUnmarshallerContext context) throws Exception {
        LoadBalancerDescription.Builder loadBalancerDescription;
        block25: {
            loadBalancerDescription = LoadBalancerDescription.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<ListenerDescription> listenerDescriptions = null;
            ArrayList<BackendServerDescription> backendServerDescriptions = null;
            ArrayList<String> availabilityZones = null;
            ArrayList<String> subnets = null;
            ArrayList<Instance> instances = null;
            ArrayList<String> securityGroups = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    loadBalancerDescription.listenerDescriptions(listenerDescriptions);
                    loadBalancerDescription.backendServerDescriptions(backendServerDescriptions);
                    loadBalancerDescription.availabilityZones(availabilityZones);
                    loadBalancerDescription.subnets(subnets);
                    loadBalancerDescription.instances(instances);
                    loadBalancerDescription.securityGroups(securityGroups);
                    break block25;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("LoadBalancerName", targetDepth)) {
                        loadBalancerDescription.loadBalancerName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("DNSName", targetDepth)) {
                        loadBalancerDescription.dnsName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("CanonicalHostedZoneName", targetDepth)) {
                        loadBalancerDescription.canonicalHostedZoneName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("CanonicalHostedZoneNameID", targetDepth)) {
                        loadBalancerDescription.canonicalHostedZoneNameID(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ListenerDescriptions", targetDepth)) {
                        listenerDescriptions = new ArrayList<ListenerDescription>();
                        continue;
                    }
                    if (context.testExpression("ListenerDescriptions/member", targetDepth)) {
                        listenerDescriptions.add(ListenerDescriptionUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Policies", targetDepth)) {
                        loadBalancerDescription.policies(PoliciesUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("BackendServerDescriptions", targetDepth)) {
                        backendServerDescriptions = new ArrayList<BackendServerDescription>();
                        continue;
                    }
                    if (context.testExpression("BackendServerDescriptions/member", targetDepth)) {
                        backendServerDescriptions.add(BackendServerDescriptionUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("AvailabilityZones", targetDepth)) {
                        availabilityZones = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("AvailabilityZones/member", targetDepth)) {
                        availabilityZones.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Subnets", targetDepth)) {
                        subnets = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("Subnets/member", targetDepth)) {
                        subnets.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("VPCId", targetDepth)) {
                        loadBalancerDescription.vpcId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Instances", targetDepth)) {
                        instances = new ArrayList<Instance>();
                        continue;
                    }
                    if (context.testExpression("Instances/member", targetDepth)) {
                        instances.add(InstanceUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("HealthCheck", targetDepth)) {
                        loadBalancerDescription.healthCheck(HealthCheckUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("SourceSecurityGroup", targetDepth)) {
                        loadBalancerDescription.sourceSecurityGroup(SourceSecurityGroupUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("SecurityGroups", targetDepth)) {
                        securityGroups = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("SecurityGroups/member", targetDepth)) {
                        securityGroups.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("CreatedTime", targetDepth)) {
                        loadBalancerDescription.createdTime(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("Scheme", targetDepth)) continue;
                    loadBalancerDescription.scheme(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            loadBalancerDescription.listenerDescriptions(listenerDescriptions);
            loadBalancerDescription.backendServerDescriptions(backendServerDescriptions);
            loadBalancerDescription.availabilityZones(availabilityZones);
            loadBalancerDescription.subnets(subnets);
            loadBalancerDescription.instances(instances);
            loadBalancerDescription.securityGroups(securityGroups);
        }
        return (LoadBalancerDescription)loadBalancerDescription.build();
    }

    public static LoadBalancerDescriptionUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LoadBalancerDescriptionUnmarshaller();
        }
        return INSTANCE;
    }
}

