/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.AvailabilityZonesCopier;
import software.amazon.awssdk.services.elasticloadbalancing.model.Listener;
import software.amazon.awssdk.services.elasticloadbalancing.model.ListenersCopier;
import software.amazon.awssdk.services.elasticloadbalancing.model.SecurityGroupsCopier;
import software.amazon.awssdk.services.elasticloadbalancing.model.SubnetsCopier;
import software.amazon.awssdk.services.elasticloadbalancing.model.Tag;
import software.amazon.awssdk.services.elasticloadbalancing.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateLoadBalancerRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateLoadBalancerRequest> {
    private final String loadBalancerName;
    private final List<Listener> listeners;
    private final List<String> availabilityZones;
    private final List<String> subnets;
    private final List<String> securityGroups;
    private final String scheme;
    private final List<Tag> tags;

    private CreateLoadBalancerRequest(BuilderImpl builder) {
        this.loadBalancerName = builder.loadBalancerName;
        this.listeners = builder.listeners;
        this.availabilityZones = builder.availabilityZones;
        this.subnets = builder.subnets;
        this.securityGroups = builder.securityGroups;
        this.scheme = builder.scheme;
        this.tags = builder.tags;
    }

    public String loadBalancerName() {
        return this.loadBalancerName;
    }

    public List<Listener> listeners() {
        return this.listeners;
    }

    public List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public List<String> subnets() {
        return this.subnets;
    }

    public List<String> securityGroups() {
        return this.securityGroups;
    }

    public String scheme() {
        return this.scheme;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.loadBalancerName() == null ? 0 : this.loadBalancerName().hashCode());
        hashCode = 31 * hashCode + (this.listeners() == null ? 0 : this.listeners().hashCode());
        hashCode = 31 * hashCode + (this.availabilityZones() == null ? 0 : this.availabilityZones().hashCode());
        hashCode = 31 * hashCode + (this.subnets() == null ? 0 : this.subnets().hashCode());
        hashCode = 31 * hashCode + (this.securityGroups() == null ? 0 : this.securityGroups().hashCode());
        hashCode = 31 * hashCode + (this.scheme() == null ? 0 : this.scheme().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLoadBalancerRequest)) {
            return false;
        }
        CreateLoadBalancerRequest other = (CreateLoadBalancerRequest)((Object)obj);
        if (other.loadBalancerName() == null ^ this.loadBalancerName() == null) {
            return false;
        }
        if (other.loadBalancerName() != null && !other.loadBalancerName().equals(this.loadBalancerName())) {
            return false;
        }
        if (other.listeners() == null ^ this.listeners() == null) {
            return false;
        }
        if (other.listeners() != null && !other.listeners().equals(this.listeners())) {
            return false;
        }
        if (other.availabilityZones() == null ^ this.availabilityZones() == null) {
            return false;
        }
        if (other.availabilityZones() != null && !other.availabilityZones().equals(this.availabilityZones())) {
            return false;
        }
        if (other.subnets() == null ^ this.subnets() == null) {
            return false;
        }
        if (other.subnets() != null && !other.subnets().equals(this.subnets())) {
            return false;
        }
        if (other.securityGroups() == null ^ this.securityGroups() == null) {
            return false;
        }
        if (other.securityGroups() != null && !other.securityGroups().equals(this.securityGroups())) {
            return false;
        }
        if (other.scheme() == null ^ this.scheme() == null) {
            return false;
        }
        if (other.scheme() != null && !other.scheme().equals(this.scheme())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        return other.tags() == null || other.tags().equals(this.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.loadBalancerName() != null) {
            sb.append("LoadBalancerName: ").append(this.loadBalancerName()).append(",");
        }
        if (this.listeners() != null) {
            sb.append("Listeners: ").append(this.listeners()).append(",");
        }
        if (this.availabilityZones() != null) {
            sb.append("AvailabilityZones: ").append(this.availabilityZones()).append(",");
        }
        if (this.subnets() != null) {
            sb.append("Subnets: ").append(this.subnets()).append(",");
        }
        if (this.securityGroups() != null) {
            sb.append("SecurityGroups: ").append(this.securityGroups()).append(",");
        }
        if (this.scheme() != null) {
            sb.append("Scheme: ").append(this.scheme()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String loadBalancerName;
        private List<Listener> listeners;
        private List<String> availabilityZones;
        private List<String> subnets;
        private List<String> securityGroups;
        private String scheme;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLoadBalancerRequest model) {
            this.setLoadBalancerName(model.loadBalancerName);
            this.setListeners(model.listeners);
            this.setAvailabilityZones(model.availabilityZones);
            this.setSubnets(model.subnets);
            this.setSecurityGroups(model.securityGroups);
            this.setScheme(model.scheme);
            this.setTags(model.tags);
        }

        public final String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        public final Collection<Listener> getListeners() {
            return this.listeners;
        }

        @Override
        public final Builder listeners(Collection<Listener> listeners) {
            this.listeners = ListenersCopier.copy(listeners);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listeners(Listener ... listeners) {
            this.listeners(Arrays.asList(listeners));
            return this;
        }

        public final void setListeners(Collection<Listener> listeners) {
            this.listeners = ListenersCopier.copy(listeners);
        }

        @SafeVarargs
        public final void setListeners(Listener ... listeners) {
            this.listeners(Arrays.asList(listeners));
        }

        public final Collection<String> getAvailabilityZones() {
            return this.availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
        }

        @SafeVarargs
        public final void setAvailabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
        }

        public final Collection<String> getSubnets() {
            return this.subnets;
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = SubnetsCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String ... subnets) {
            this.subnets(Arrays.asList(subnets));
            return this;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = SubnetsCopier.copy(subnets);
        }

        @SafeVarargs
        public final void setSubnets(String ... subnets) {
            this.subnets(Arrays.asList(subnets));
        }

        public final Collection<String> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
        }

        @SafeVarargs
        public final void setSecurityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
        }

        public final String getScheme() {
            return this.scheme;
        }

        @Override
        public final Builder scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        public final void setScheme(String scheme) {
            this.scheme = scheme;
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
        }

        public CreateLoadBalancerRequest build() {
            return new CreateLoadBalancerRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateLoadBalancerRequest> {
        public Builder loadBalancerName(String var1);

        public Builder listeners(Collection<Listener> var1);

        public Builder listeners(Listener ... var1);

        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder subnets(Collection<String> var1);

        public Builder subnets(String ... var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder scheme(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);
    }
}

