/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.services.elasticache.ElastiCacheAsyncClient;
import software.amazon.awssdk.services.elasticache.model.AddTagsToResourceRequest;
import software.amazon.awssdk.services.elasticache.model.AddTagsToResourceResponse;
import software.amazon.awssdk.services.elasticache.model.ApiCallRateForCustomerExceededException;
import software.amazon.awssdk.services.elasticache.model.AuthorizationAlreadyExistsException;
import software.amazon.awssdk.services.elasticache.model.AuthorizationNotFoundException;
import software.amazon.awssdk.services.elasticache.model.AuthorizeCacheSecurityGroupIngressRequest;
import software.amazon.awssdk.services.elasticache.model.AuthorizeCacheSecurityGroupIngressResponse;
import software.amazon.awssdk.services.elasticache.model.BatchApplyUpdateActionRequest;
import software.amazon.awssdk.services.elasticache.model.BatchApplyUpdateActionResponse;
import software.amazon.awssdk.services.elasticache.model.BatchStopUpdateActionRequest;
import software.amazon.awssdk.services.elasticache.model.BatchStopUpdateActionResponse;
import software.amazon.awssdk.services.elasticache.model.CacheClusterAlreadyExistsException;
import software.amazon.awssdk.services.elasticache.model.CacheClusterNotFoundException;
import software.amazon.awssdk.services.elasticache.model.CacheParameterGroupAlreadyExistsException;
import software.amazon.awssdk.services.elasticache.model.CacheParameterGroupNotFoundException;
import software.amazon.awssdk.services.elasticache.model.CacheParameterGroupQuotaExceededException;
import software.amazon.awssdk.services.elasticache.model.CacheSecurityGroupAlreadyExistsException;
import software.amazon.awssdk.services.elasticache.model.CacheSecurityGroupNotFoundException;
import software.amazon.awssdk.services.elasticache.model.CacheSecurityGroupQuotaExceededException;
import software.amazon.awssdk.services.elasticache.model.CacheSubnetGroupAlreadyExistsException;
import software.amazon.awssdk.services.elasticache.model.CacheSubnetGroupInUseException;
import software.amazon.awssdk.services.elasticache.model.CacheSubnetGroupNotFoundException;
import software.amazon.awssdk.services.elasticache.model.CacheSubnetGroupQuotaExceededException;
import software.amazon.awssdk.services.elasticache.model.CacheSubnetQuotaExceededException;
import software.amazon.awssdk.services.elasticache.model.ClusterQuotaForCustomerExceededException;
import software.amazon.awssdk.services.elasticache.model.CopySnapshotRequest;
import software.amazon.awssdk.services.elasticache.model.CopySnapshotResponse;
import software.amazon.awssdk.services.elasticache.model.CreateCacheClusterRequest;
import software.amazon.awssdk.services.elasticache.model.CreateCacheClusterResponse;
import software.amazon.awssdk.services.elasticache.model.CreateCacheParameterGroupRequest;
import software.amazon.awssdk.services.elasticache.model.CreateCacheParameterGroupResponse;
import software.amazon.awssdk.services.elasticache.model.CreateCacheSecurityGroupRequest;
import software.amazon.awssdk.services.elasticache.model.CreateCacheSecurityGroupResponse;
import software.amazon.awssdk.services.elasticache.model.CreateCacheSubnetGroupRequest;
import software.amazon.awssdk.services.elasticache.model.CreateCacheSubnetGroupResponse;
import software.amazon.awssdk.services.elasticache.model.CreateReplicationGroupRequest;
import software.amazon.awssdk.services.elasticache.model.CreateReplicationGroupResponse;
import software.amazon.awssdk.services.elasticache.model.CreateSnapshotRequest;
import software.amazon.awssdk.services.elasticache.model.CreateSnapshotResponse;
import software.amazon.awssdk.services.elasticache.model.DecreaseReplicaCountRequest;
import software.amazon.awssdk.services.elasticache.model.DecreaseReplicaCountResponse;
import software.amazon.awssdk.services.elasticache.model.DeleteCacheClusterRequest;
import software.amazon.awssdk.services.elasticache.model.DeleteCacheClusterResponse;
import software.amazon.awssdk.services.elasticache.model.DeleteCacheParameterGroupRequest;
import software.amazon.awssdk.services.elasticache.model.DeleteCacheParameterGroupResponse;
import software.amazon.awssdk.services.elasticache.model.DeleteCacheSecurityGroupRequest;
import software.amazon.awssdk.services.elasticache.model.DeleteCacheSecurityGroupResponse;
import software.amazon.awssdk.services.elasticache.model.DeleteCacheSubnetGroupRequest;
import software.amazon.awssdk.services.elasticache.model.DeleteCacheSubnetGroupResponse;
import software.amazon.awssdk.services.elasticache.model.DeleteReplicationGroupRequest;
import software.amazon.awssdk.services.elasticache.model.DeleteReplicationGroupResponse;
import software.amazon.awssdk.services.elasticache.model.DeleteSnapshotRequest;
import software.amazon.awssdk.services.elasticache.model.DeleteSnapshotResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheEngineVersionsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheEngineVersionsResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheParameterGroupsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheParameterGroupsResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheParametersRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheParametersResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheSecurityGroupsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheSecurityGroupsResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeEngineDefaultParametersRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeEngineDefaultParametersResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeEventsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeEventsResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeServiceUpdatesRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeServiceUpdatesResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeSnapshotsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeSnapshotsResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeUpdateActionsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeUpdateActionsResponse;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheException;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheRequest;
import software.amazon.awssdk.services.elasticache.model.IncreaseReplicaCountRequest;
import software.amazon.awssdk.services.elasticache.model.IncreaseReplicaCountResponse;
import software.amazon.awssdk.services.elasticache.model.InsufficientCacheClusterCapacityException;
import software.amazon.awssdk.services.elasticache.model.InvalidArnException;
import software.amazon.awssdk.services.elasticache.model.InvalidCacheClusterStateException;
import software.amazon.awssdk.services.elasticache.model.InvalidCacheParameterGroupStateException;
import software.amazon.awssdk.services.elasticache.model.InvalidCacheSecurityGroupStateException;
import software.amazon.awssdk.services.elasticache.model.InvalidKmsKeyException;
import software.amazon.awssdk.services.elasticache.model.InvalidParameterCombinationException;
import software.amazon.awssdk.services.elasticache.model.InvalidParameterValueException;
import software.amazon.awssdk.services.elasticache.model.InvalidReplicationGroupStateException;
import software.amazon.awssdk.services.elasticache.model.InvalidSnapshotStateException;
import software.amazon.awssdk.services.elasticache.model.InvalidSubnetException;
import software.amazon.awssdk.services.elasticache.model.InvalidVpcNetworkStateException;
import software.amazon.awssdk.services.elasticache.model.ListAllowedNodeTypeModificationsRequest;
import software.amazon.awssdk.services.elasticache.model.ListAllowedNodeTypeModificationsResponse;
import software.amazon.awssdk.services.elasticache.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.elasticache.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.elasticache.model.ModifyCacheClusterRequest;
import software.amazon.awssdk.services.elasticache.model.ModifyCacheClusterResponse;
import software.amazon.awssdk.services.elasticache.model.ModifyCacheParameterGroupRequest;
import software.amazon.awssdk.services.elasticache.model.ModifyCacheParameterGroupResponse;
import software.amazon.awssdk.services.elasticache.model.ModifyCacheSubnetGroupRequest;
import software.amazon.awssdk.services.elasticache.model.ModifyCacheSubnetGroupResponse;
import software.amazon.awssdk.services.elasticache.model.ModifyReplicationGroupRequest;
import software.amazon.awssdk.services.elasticache.model.ModifyReplicationGroupResponse;
import software.amazon.awssdk.services.elasticache.model.ModifyReplicationGroupShardConfigurationRequest;
import software.amazon.awssdk.services.elasticache.model.ModifyReplicationGroupShardConfigurationResponse;
import software.amazon.awssdk.services.elasticache.model.NoOperationException;
import software.amazon.awssdk.services.elasticache.model.NodeGroupNotFoundException;
import software.amazon.awssdk.services.elasticache.model.NodeGroupsPerReplicationGroupQuotaExceededException;
import software.amazon.awssdk.services.elasticache.model.NodeQuotaForClusterExceededException;
import software.amazon.awssdk.services.elasticache.model.NodeQuotaForCustomerExceededException;
import software.amazon.awssdk.services.elasticache.model.PurchaseReservedCacheNodesOfferingRequest;
import software.amazon.awssdk.services.elasticache.model.PurchaseReservedCacheNodesOfferingResponse;
import software.amazon.awssdk.services.elasticache.model.RebootCacheClusterRequest;
import software.amazon.awssdk.services.elasticache.model.RebootCacheClusterResponse;
import software.amazon.awssdk.services.elasticache.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.services.elasticache.model.RemoveTagsFromResourceResponse;
import software.amazon.awssdk.services.elasticache.model.ReplicationGroupAlreadyExistsException;
import software.amazon.awssdk.services.elasticache.model.ReplicationGroupNotFoundException;
import software.amazon.awssdk.services.elasticache.model.ReservedCacheNodeAlreadyExistsException;
import software.amazon.awssdk.services.elasticache.model.ReservedCacheNodeNotFoundException;
import software.amazon.awssdk.services.elasticache.model.ReservedCacheNodeQuotaExceededException;
import software.amazon.awssdk.services.elasticache.model.ReservedCacheNodesOfferingNotFoundException;
import software.amazon.awssdk.services.elasticache.model.ResetCacheParameterGroupRequest;
import software.amazon.awssdk.services.elasticache.model.ResetCacheParameterGroupResponse;
import software.amazon.awssdk.services.elasticache.model.RevokeCacheSecurityGroupIngressRequest;
import software.amazon.awssdk.services.elasticache.model.RevokeCacheSecurityGroupIngressResponse;
import software.amazon.awssdk.services.elasticache.model.ServiceLinkedRoleNotFoundException;
import software.amazon.awssdk.services.elasticache.model.ServiceUpdateNotFoundException;
import software.amazon.awssdk.services.elasticache.model.SnapshotAlreadyExistsException;
import software.amazon.awssdk.services.elasticache.model.SnapshotFeatureNotSupportedException;
import software.amazon.awssdk.services.elasticache.model.SnapshotNotFoundException;
import software.amazon.awssdk.services.elasticache.model.SnapshotQuotaExceededException;
import software.amazon.awssdk.services.elasticache.model.SubnetInUseException;
import software.amazon.awssdk.services.elasticache.model.TagNotFoundException;
import software.amazon.awssdk.services.elasticache.model.TagQuotaPerResourceExceededException;
import software.amazon.awssdk.services.elasticache.model.TestFailoverNotAvailableException;
import software.amazon.awssdk.services.elasticache.model.TestFailoverRequest;
import software.amazon.awssdk.services.elasticache.model.TestFailoverResponse;
import software.amazon.awssdk.services.elasticache.paginators.DescribeCacheClustersPublisher;
import software.amazon.awssdk.services.elasticache.paginators.DescribeCacheEngineVersionsPublisher;
import software.amazon.awssdk.services.elasticache.paginators.DescribeCacheParameterGroupsPublisher;
import software.amazon.awssdk.services.elasticache.paginators.DescribeCacheParametersPublisher;
import software.amazon.awssdk.services.elasticache.paginators.DescribeCacheSecurityGroupsPublisher;
import software.amazon.awssdk.services.elasticache.paginators.DescribeCacheSubnetGroupsPublisher;
import software.amazon.awssdk.services.elasticache.paginators.DescribeEngineDefaultParametersPublisher;
import software.amazon.awssdk.services.elasticache.paginators.DescribeEventsPublisher;
import software.amazon.awssdk.services.elasticache.paginators.DescribeReplicationGroupsPublisher;
import software.amazon.awssdk.services.elasticache.paginators.DescribeReservedCacheNodesOfferingsPublisher;
import software.amazon.awssdk.services.elasticache.paginators.DescribeReservedCacheNodesPublisher;
import software.amazon.awssdk.services.elasticache.paginators.DescribeServiceUpdatesPublisher;
import software.amazon.awssdk.services.elasticache.paginators.DescribeSnapshotsPublisher;
import software.amazon.awssdk.services.elasticache.paginators.DescribeUpdateActionsPublisher;
import software.amazon.awssdk.services.elasticache.transform.AddTagsToResourceRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.AuthorizeCacheSecurityGroupIngressRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.BatchApplyUpdateActionRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.BatchStopUpdateActionRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.CopySnapshotRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.CreateCacheClusterRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.CreateCacheParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.CreateCacheSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.CreateCacheSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.CreateReplicationGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.CreateSnapshotRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DecreaseReplicaCountRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DeleteCacheClusterRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DeleteCacheParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DeleteCacheSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DeleteCacheSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DeleteReplicationGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DeleteSnapshotRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeCacheClustersRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeCacheEngineVersionsRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeCacheParameterGroupsRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeCacheParametersRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeCacheSecurityGroupsRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeCacheSubnetGroupsRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeEngineDefaultParametersRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeEventsRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeReplicationGroupsRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeReservedCacheNodesOfferingsRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeReservedCacheNodesRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeServiceUpdatesRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeUpdateActionsRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.IncreaseReplicaCountRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.ListAllowedNodeTypeModificationsRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.ModifyCacheClusterRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.ModifyCacheParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.ModifyCacheSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.ModifyReplicationGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.ModifyReplicationGroupShardConfigurationRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.PurchaseReservedCacheNodesOfferingRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.RebootCacheClusterRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.RemoveTagsFromResourceRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.ResetCacheParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.RevokeCacheSecurityGroupIngressRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.TestFailoverRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultElastiCacheAsyncClient
implements ElastiCacheAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultElastiCacheAsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final AwsQueryProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultElastiCacheAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init();
    }

    public final String serviceName() {
        return "elasticache";
    }

    @Override
    public CompletableFuture<AddTagsToResourceResponse> addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AddTagsToResourceResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddTagsToResource").withMarshaller((Marshaller)new AddTagsToResourceRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addTagsToResourceRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AuthorizeCacheSecurityGroupIngressResponse> authorizeCacheSecurityGroupIngress(AuthorizeCacheSecurityGroupIngressRequest authorizeCacheSecurityGroupIngressRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AuthorizeCacheSecurityGroupIngressResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AuthorizeCacheSecurityGroupIngress").withMarshaller((Marshaller)new AuthorizeCacheSecurityGroupIngressRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)authorizeCacheSecurityGroupIngressRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchApplyUpdateActionResponse> batchApplyUpdateAction(BatchApplyUpdateActionRequest batchApplyUpdateActionRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(BatchApplyUpdateActionResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchApplyUpdateAction").withMarshaller((Marshaller)new BatchApplyUpdateActionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchApplyUpdateActionRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchStopUpdateActionResponse> batchStopUpdateAction(BatchStopUpdateActionRequest batchStopUpdateActionRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(BatchStopUpdateActionResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchStopUpdateAction").withMarshaller((Marshaller)new BatchStopUpdateActionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchStopUpdateActionRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CopySnapshotResponse> copySnapshot(CopySnapshotRequest copySnapshotRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CopySnapshotResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CopySnapshot").withMarshaller((Marshaller)new CopySnapshotRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)copySnapshotRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateCacheClusterResponse> createCacheCluster(CreateCacheClusterRequest createCacheClusterRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateCacheClusterResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCacheCluster").withMarshaller((Marshaller)new CreateCacheClusterRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createCacheClusterRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateCacheParameterGroupResponse> createCacheParameterGroup(CreateCacheParameterGroupRequest createCacheParameterGroupRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateCacheParameterGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCacheParameterGroup").withMarshaller((Marshaller)new CreateCacheParameterGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createCacheParameterGroupRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateCacheSecurityGroupResponse> createCacheSecurityGroup(CreateCacheSecurityGroupRequest createCacheSecurityGroupRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateCacheSecurityGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCacheSecurityGroup").withMarshaller((Marshaller)new CreateCacheSecurityGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createCacheSecurityGroupRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateCacheSubnetGroupResponse> createCacheSubnetGroup(CreateCacheSubnetGroupRequest createCacheSubnetGroupRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateCacheSubnetGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCacheSubnetGroup").withMarshaller((Marshaller)new CreateCacheSubnetGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createCacheSubnetGroupRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateReplicationGroupResponse> createReplicationGroup(CreateReplicationGroupRequest createReplicationGroupRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateReplicationGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateReplicationGroup").withMarshaller((Marshaller)new CreateReplicationGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createReplicationGroupRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateSnapshotResponse> createSnapshot(CreateSnapshotRequest createSnapshotRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateSnapshotResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSnapshot").withMarshaller((Marshaller)new CreateSnapshotRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createSnapshotRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DecreaseReplicaCountResponse> decreaseReplicaCount(DecreaseReplicaCountRequest decreaseReplicaCountRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DecreaseReplicaCountResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DecreaseReplicaCount").withMarshaller((Marshaller)new DecreaseReplicaCountRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)decreaseReplicaCountRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteCacheClusterResponse> deleteCacheCluster(DeleteCacheClusterRequest deleteCacheClusterRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteCacheClusterResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCacheCluster").withMarshaller((Marshaller)new DeleteCacheClusterRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteCacheClusterRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteCacheParameterGroupResponse> deleteCacheParameterGroup(DeleteCacheParameterGroupRequest deleteCacheParameterGroupRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteCacheParameterGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCacheParameterGroup").withMarshaller((Marshaller)new DeleteCacheParameterGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteCacheParameterGroupRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteCacheSecurityGroupResponse> deleteCacheSecurityGroup(DeleteCacheSecurityGroupRequest deleteCacheSecurityGroupRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteCacheSecurityGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCacheSecurityGroup").withMarshaller((Marshaller)new DeleteCacheSecurityGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteCacheSecurityGroupRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteCacheSubnetGroupResponse> deleteCacheSubnetGroup(DeleteCacheSubnetGroupRequest deleteCacheSubnetGroupRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteCacheSubnetGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCacheSubnetGroup").withMarshaller((Marshaller)new DeleteCacheSubnetGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteCacheSubnetGroupRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteReplicationGroupResponse> deleteReplicationGroup(DeleteReplicationGroupRequest deleteReplicationGroupRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteReplicationGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteReplicationGroup").withMarshaller((Marshaller)new DeleteReplicationGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteReplicationGroupRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteSnapshotResponse> deleteSnapshot(DeleteSnapshotRequest deleteSnapshotRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteSnapshotResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSnapshot").withMarshaller((Marshaller)new DeleteSnapshotRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteSnapshotRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeCacheClustersResponse> describeCacheClusters(DescribeCacheClustersRequest describeCacheClustersRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeCacheClustersResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCacheClusters").withMarshaller((Marshaller)new DescribeCacheClustersRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeCacheClustersRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeCacheClustersPublisher describeCacheClustersPaginator(DescribeCacheClustersRequest describeCacheClustersRequest) {
        return new DescribeCacheClustersPublisher(this, this.applyPaginatorUserAgent(describeCacheClustersRequest));
    }

    @Override
    public CompletableFuture<DescribeCacheEngineVersionsResponse> describeCacheEngineVersions(DescribeCacheEngineVersionsRequest describeCacheEngineVersionsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeCacheEngineVersionsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCacheEngineVersions").withMarshaller((Marshaller)new DescribeCacheEngineVersionsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeCacheEngineVersionsRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeCacheEngineVersionsPublisher describeCacheEngineVersionsPaginator(DescribeCacheEngineVersionsRequest describeCacheEngineVersionsRequest) {
        return new DescribeCacheEngineVersionsPublisher(this, this.applyPaginatorUserAgent(describeCacheEngineVersionsRequest));
    }

    @Override
    public CompletableFuture<DescribeCacheParameterGroupsResponse> describeCacheParameterGroups(DescribeCacheParameterGroupsRequest describeCacheParameterGroupsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeCacheParameterGroupsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCacheParameterGroups").withMarshaller((Marshaller)new DescribeCacheParameterGroupsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeCacheParameterGroupsRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeCacheParameterGroupsPublisher describeCacheParameterGroupsPaginator(DescribeCacheParameterGroupsRequest describeCacheParameterGroupsRequest) {
        return new DescribeCacheParameterGroupsPublisher(this, this.applyPaginatorUserAgent(describeCacheParameterGroupsRequest));
    }

    @Override
    public CompletableFuture<DescribeCacheParametersResponse> describeCacheParameters(DescribeCacheParametersRequest describeCacheParametersRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeCacheParametersResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCacheParameters").withMarshaller((Marshaller)new DescribeCacheParametersRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeCacheParametersRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeCacheParametersPublisher describeCacheParametersPaginator(DescribeCacheParametersRequest describeCacheParametersRequest) {
        return new DescribeCacheParametersPublisher(this, this.applyPaginatorUserAgent(describeCacheParametersRequest));
    }

    @Override
    public CompletableFuture<DescribeCacheSecurityGroupsResponse> describeCacheSecurityGroups(DescribeCacheSecurityGroupsRequest describeCacheSecurityGroupsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeCacheSecurityGroupsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCacheSecurityGroups").withMarshaller((Marshaller)new DescribeCacheSecurityGroupsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeCacheSecurityGroupsRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeCacheSecurityGroupsPublisher describeCacheSecurityGroupsPaginator(DescribeCacheSecurityGroupsRequest describeCacheSecurityGroupsRequest) {
        return new DescribeCacheSecurityGroupsPublisher(this, this.applyPaginatorUserAgent(describeCacheSecurityGroupsRequest));
    }

    @Override
    public CompletableFuture<DescribeCacheSubnetGroupsResponse> describeCacheSubnetGroups(DescribeCacheSubnetGroupsRequest describeCacheSubnetGroupsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeCacheSubnetGroupsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCacheSubnetGroups").withMarshaller((Marshaller)new DescribeCacheSubnetGroupsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeCacheSubnetGroupsRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeCacheSubnetGroupsPublisher describeCacheSubnetGroupsPaginator(DescribeCacheSubnetGroupsRequest describeCacheSubnetGroupsRequest) {
        return new DescribeCacheSubnetGroupsPublisher(this, this.applyPaginatorUserAgent(describeCacheSubnetGroupsRequest));
    }

    @Override
    public CompletableFuture<DescribeEngineDefaultParametersResponse> describeEngineDefaultParameters(DescribeEngineDefaultParametersRequest describeEngineDefaultParametersRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEngineDefaultParametersResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEngineDefaultParameters").withMarshaller((Marshaller)new DescribeEngineDefaultParametersRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEngineDefaultParametersRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeEngineDefaultParametersPublisher describeEngineDefaultParametersPaginator(DescribeEngineDefaultParametersRequest describeEngineDefaultParametersRequest) {
        return new DescribeEngineDefaultParametersPublisher(this, this.applyPaginatorUserAgent(describeEngineDefaultParametersRequest));
    }

    @Override
    public CompletableFuture<DescribeEventsResponse> describeEvents(DescribeEventsRequest describeEventsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEventsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEvents").withMarshaller((Marshaller)new DescribeEventsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEventsRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeEventsPublisher describeEventsPaginator(DescribeEventsRequest describeEventsRequest) {
        return new DescribeEventsPublisher(this, this.applyPaginatorUserAgent(describeEventsRequest));
    }

    @Override
    public CompletableFuture<DescribeReplicationGroupsResponse> describeReplicationGroups(DescribeReplicationGroupsRequest describeReplicationGroupsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeReplicationGroupsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReplicationGroups").withMarshaller((Marshaller)new DescribeReplicationGroupsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeReplicationGroupsRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeReplicationGroupsPublisher describeReplicationGroupsPaginator(DescribeReplicationGroupsRequest describeReplicationGroupsRequest) {
        return new DescribeReplicationGroupsPublisher(this, this.applyPaginatorUserAgent(describeReplicationGroupsRequest));
    }

    @Override
    public CompletableFuture<DescribeReservedCacheNodesResponse> describeReservedCacheNodes(DescribeReservedCacheNodesRequest describeReservedCacheNodesRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeReservedCacheNodesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReservedCacheNodes").withMarshaller((Marshaller)new DescribeReservedCacheNodesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeReservedCacheNodesRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeReservedCacheNodesOfferingsResponse> describeReservedCacheNodesOfferings(DescribeReservedCacheNodesOfferingsRequest describeReservedCacheNodesOfferingsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeReservedCacheNodesOfferingsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReservedCacheNodesOfferings").withMarshaller((Marshaller)new DescribeReservedCacheNodesOfferingsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeReservedCacheNodesOfferingsRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeReservedCacheNodesOfferingsPublisher describeReservedCacheNodesOfferingsPaginator(DescribeReservedCacheNodesOfferingsRequest describeReservedCacheNodesOfferingsRequest) {
        return new DescribeReservedCacheNodesOfferingsPublisher(this, this.applyPaginatorUserAgent(describeReservedCacheNodesOfferingsRequest));
    }

    @Override
    public DescribeReservedCacheNodesPublisher describeReservedCacheNodesPaginator(DescribeReservedCacheNodesRequest describeReservedCacheNodesRequest) {
        return new DescribeReservedCacheNodesPublisher(this, this.applyPaginatorUserAgent(describeReservedCacheNodesRequest));
    }

    @Override
    public CompletableFuture<DescribeServiceUpdatesResponse> describeServiceUpdates(DescribeServiceUpdatesRequest describeServiceUpdatesRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeServiceUpdatesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeServiceUpdates").withMarshaller((Marshaller)new DescribeServiceUpdatesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeServiceUpdatesRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeServiceUpdatesPublisher describeServiceUpdatesPaginator(DescribeServiceUpdatesRequest describeServiceUpdatesRequest) {
        return new DescribeServiceUpdatesPublisher(this, this.applyPaginatorUserAgent(describeServiceUpdatesRequest));
    }

    @Override
    public CompletableFuture<DescribeSnapshotsResponse> describeSnapshots(DescribeSnapshotsRequest describeSnapshotsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeSnapshotsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSnapshots").withMarshaller((Marshaller)new DescribeSnapshotsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeSnapshotsRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeSnapshotsPublisher describeSnapshotsPaginator(DescribeSnapshotsRequest describeSnapshotsRequest) {
        return new DescribeSnapshotsPublisher(this, this.applyPaginatorUserAgent(describeSnapshotsRequest));
    }

    @Override
    public CompletableFuture<DescribeUpdateActionsResponse> describeUpdateActions(DescribeUpdateActionsRequest describeUpdateActionsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeUpdateActionsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeUpdateActions").withMarshaller((Marshaller)new DescribeUpdateActionsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeUpdateActionsRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeUpdateActionsPublisher describeUpdateActionsPaginator(DescribeUpdateActionsRequest describeUpdateActionsRequest) {
        return new DescribeUpdateActionsPublisher(this, this.applyPaginatorUserAgent(describeUpdateActionsRequest));
    }

    @Override
    public CompletableFuture<IncreaseReplicaCountResponse> increaseReplicaCount(IncreaseReplicaCountRequest increaseReplicaCountRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(IncreaseReplicaCountResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("IncreaseReplicaCount").withMarshaller((Marshaller)new IncreaseReplicaCountRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)increaseReplicaCountRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListAllowedNodeTypeModificationsResponse> listAllowedNodeTypeModifications(ListAllowedNodeTypeModificationsRequest listAllowedNodeTypeModificationsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListAllowedNodeTypeModificationsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAllowedNodeTypeModifications").withMarshaller((Marshaller)new ListAllowedNodeTypeModificationsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAllowedNodeTypeModificationsRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListTagsForResourceResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyCacheClusterResponse> modifyCacheCluster(ModifyCacheClusterRequest modifyCacheClusterRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyCacheClusterResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyCacheCluster").withMarshaller((Marshaller)new ModifyCacheClusterRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyCacheClusterRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyCacheParameterGroupResponse> modifyCacheParameterGroup(ModifyCacheParameterGroupRequest modifyCacheParameterGroupRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyCacheParameterGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyCacheParameterGroup").withMarshaller((Marshaller)new ModifyCacheParameterGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyCacheParameterGroupRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyCacheSubnetGroupResponse> modifyCacheSubnetGroup(ModifyCacheSubnetGroupRequest modifyCacheSubnetGroupRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyCacheSubnetGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyCacheSubnetGroup").withMarshaller((Marshaller)new ModifyCacheSubnetGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyCacheSubnetGroupRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyReplicationGroupResponse> modifyReplicationGroup(ModifyReplicationGroupRequest modifyReplicationGroupRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyReplicationGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyReplicationGroup").withMarshaller((Marshaller)new ModifyReplicationGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyReplicationGroupRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyReplicationGroupShardConfigurationResponse> modifyReplicationGroupShardConfiguration(ModifyReplicationGroupShardConfigurationRequest modifyReplicationGroupShardConfigurationRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyReplicationGroupShardConfigurationResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyReplicationGroupShardConfiguration").withMarshaller((Marshaller)new ModifyReplicationGroupShardConfigurationRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyReplicationGroupShardConfigurationRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PurchaseReservedCacheNodesOfferingResponse> purchaseReservedCacheNodesOffering(PurchaseReservedCacheNodesOfferingRequest purchaseReservedCacheNodesOfferingRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(PurchaseReservedCacheNodesOfferingResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PurchaseReservedCacheNodesOffering").withMarshaller((Marshaller)new PurchaseReservedCacheNodesOfferingRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)purchaseReservedCacheNodesOfferingRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RebootCacheClusterResponse> rebootCacheCluster(RebootCacheClusterRequest rebootCacheClusterRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RebootCacheClusterResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RebootCacheCluster").withMarshaller((Marshaller)new RebootCacheClusterRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)rebootCacheClusterRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RemoveTagsFromResourceResponse> removeTagsFromResource(RemoveTagsFromResourceRequest removeTagsFromResourceRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RemoveTagsFromResourceResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveTagsFromResource").withMarshaller((Marshaller)new RemoveTagsFromResourceRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removeTagsFromResourceRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ResetCacheParameterGroupResponse> resetCacheParameterGroup(ResetCacheParameterGroupRequest resetCacheParameterGroupRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ResetCacheParameterGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResetCacheParameterGroup").withMarshaller((Marshaller)new ResetCacheParameterGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)resetCacheParameterGroupRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RevokeCacheSecurityGroupIngressResponse> revokeCacheSecurityGroupIngress(RevokeCacheSecurityGroupIngressRequest revokeCacheSecurityGroupIngressRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RevokeCacheSecurityGroupIngressResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RevokeCacheSecurityGroupIngress").withMarshaller((Marshaller)new RevokeCacheSecurityGroupIngressRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)revokeCacheSecurityGroupIngressRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TestFailoverResponse> testFailover(TestFailoverRequest testFailoverRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(TestFailoverResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TestFailover").withMarshaller((Marshaller)new TestFailoverRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)testFailoverRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    public void close() {
        this.clientHandler.close();
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("CacheSubnetGroupNotFoundFault").exceptionBuilderSupplier(CacheSubnetGroupNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SubnetInUse").exceptionBuilderSupplier(SubnetInUseException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CacheClusterAlreadyExists").exceptionBuilderSupplier(CacheClusterAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CacheSecurityGroupAlreadyExists").exceptionBuilderSupplier(CacheSecurityGroupAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidCacheSecurityGroupState").exceptionBuilderSupplier(InvalidCacheSecurityGroupStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("QuotaExceeded.CacheSecurityGroup").exceptionBuilderSupplier(CacheSecurityGroupQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CacheParameterGroupQuotaExceeded").exceptionBuilderSupplier(CacheParameterGroupQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReservedCacheNodesOfferingNotFound").exceptionBuilderSupplier(ReservedCacheNodesOfferingNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CacheParameterGroupAlreadyExists").exceptionBuilderSupplier(CacheParameterGroupAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidARN").exceptionBuilderSupplier(InvalidArnException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").exceptionBuilderSupplier(InvalidKmsKeyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CacheParameterGroupNotFound").exceptionBuilderSupplier(CacheParameterGroupNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NodeGroupNotFoundFault").exceptionBuilderSupplier(NodeGroupNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientCacheClusterCapacity").exceptionBuilderSupplier(InsufficientCacheClusterCapacityException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReservedCacheNodeNotFound").exceptionBuilderSupplier(ReservedCacheNodeNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CacheSubnetGroupInUse").exceptionBuilderSupplier(CacheSubnetGroupInUseException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReplicationGroupNotFoundFault").exceptionBuilderSupplier(ReplicationGroupNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSubnet").exceptionBuilderSupplier(InvalidSubnetException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoOperationFault").exceptionBuilderSupplier(NoOperationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NodeGroupsPerReplicationGroupQuotaExceeded").exceptionBuilderSupplier(NodeGroupsPerReplicationGroupQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReservedCacheNodeQuotaExceeded").exceptionBuilderSupplier(ReservedCacheNodeQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReservedCacheNodeAlreadyExists").exceptionBuilderSupplier(ReservedCacheNodeAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CacheClusterNotFound").exceptionBuilderSupplier(CacheClusterNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidParameterValue").exceptionBuilderSupplier(InvalidParameterValueException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidReplicationGroupState").exceptionBuilderSupplier(InvalidReplicationGroupStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceeded").exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TagNotFound").exceptionBuilderSupplier(TagNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceeded").exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceeded").exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceeded").exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidCacheClusterState").exceptionBuilderSupplier(InvalidCacheClusterStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CacheSubnetQuotaExceededFault").exceptionBuilderSupplier(CacheSubnetQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SnapshotFeatureNotSupportedFault").exceptionBuilderSupplier(SnapshotFeatureNotSupportedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSnapshotState").exceptionBuilderSupplier(InvalidSnapshotStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CacheSubnetGroupAlreadyExists").exceptionBuilderSupplier(CacheSubnetGroupAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CacheSubnetGroupQuotaExceeded").exceptionBuilderSupplier(CacheSubnetGroupQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReplicationGroupAlreadyExists").exceptionBuilderSupplier(ReplicationGroupAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidParameterCombination").exceptionBuilderSupplier(InvalidParameterCombinationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").exceptionBuilderSupplier(SnapshotNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CacheSecurityGroupNotFound").exceptionBuilderSupplier(CacheSecurityGroupNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidCacheParameterGroupState").exceptionBuilderSupplier(InvalidCacheParameterGroupStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AuthorizationAlreadyExists").exceptionBuilderSupplier(AuthorizationAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AuthorizationNotFound").exceptionBuilderSupplier(AuthorizationNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(ElastiCacheException::builder).build();
    }

    private <T extends ElastiCacheRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.9.21").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((ElastiCacheRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

