/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticache.ElastiCacheAsyncClient;
import software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesResponse;
import software.amazon.awssdk.services.elasticache.model.ReservedCacheNode;

public class DescribeReservedCacheNodesPublisher
implements SdkPublisher<DescribeReservedCacheNodesResponse> {
    private final ElastiCacheAsyncClient client;
    private final DescribeReservedCacheNodesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeReservedCacheNodesPublisher(ElastiCacheAsyncClient client, DescribeReservedCacheNodesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeReservedCacheNodesPublisher(ElastiCacheAsyncClient client, DescribeReservedCacheNodesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeReservedCacheNodesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeReservedCacheNodesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ReservedCacheNode> reservedCacheNodes() {
        Function<DescribeReservedCacheNodesResponse, Iterator> getIterator = response -> {
            if (response != null && response.reservedCacheNodes() != null) {
                return response.reservedCacheNodes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeReservedCacheNodesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final DescribeReservedCacheNodesPublisher resume(DescribeReservedCacheNodesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeReservedCacheNodesPublisher(this.client, (DescribeReservedCacheNodesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeReservedCacheNodesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeReservedCacheNodesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeReservedCacheNodesResponseFetcher
    implements AsyncPageFetcher<DescribeReservedCacheNodesResponse> {
        private DescribeReservedCacheNodesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReservedCacheNodesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeReservedCacheNodesResponse> nextPage(DescribeReservedCacheNodesResponse previousPage) {
            if (previousPage == null) {
                return DescribeReservedCacheNodesPublisher.this.client.describeReservedCacheNodes(DescribeReservedCacheNodesPublisher.this.firstRequest);
            }
            return DescribeReservedCacheNodesPublisher.this.client.describeReservedCacheNodes((DescribeReservedCacheNodesRequest)((Object)DescribeReservedCacheNodesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

