/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticache.model.NodeGroupConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NodeSnapshot
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NodeSnapshot> {
    private static final SdkField<String> CACHE_CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NodeSnapshot.getter(NodeSnapshot::cacheClusterId)).setter(NodeSnapshot.setter(Builder::cacheClusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheClusterId").build()}).build();
    private static final SdkField<String> NODE_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NodeSnapshot.getter(NodeSnapshot::nodeGroupId)).setter(NodeSnapshot.setter(Builder::nodeGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeGroupId").build()}).build();
    private static final SdkField<String> CACHE_NODE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NodeSnapshot.getter(NodeSnapshot::cacheNodeId)).setter(NodeSnapshot.setter(Builder::cacheNodeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeId").build()}).build();
    private static final SdkField<NodeGroupConfiguration> NODE_GROUP_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(NodeSnapshot.getter(NodeSnapshot::nodeGroupConfiguration)).setter(NodeSnapshot.setter(Builder::nodeGroupConfiguration)).constructor(NodeGroupConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeGroupConfiguration").build()}).build();
    private static final SdkField<String> CACHE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NodeSnapshot.getter(NodeSnapshot::cacheSize)).setter(NodeSnapshot.setter(Builder::cacheSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSize").build()}).build();
    private static final SdkField<Instant> CACHE_NODE_CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(NodeSnapshot.getter(NodeSnapshot::cacheNodeCreateTime)).setter(NodeSnapshot.setter(Builder::cacheNodeCreateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeCreateTime").build()}).build();
    private static final SdkField<Instant> SNAPSHOT_CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(NodeSnapshot.getter(NodeSnapshot::snapshotCreateTime)).setter(NodeSnapshot.setter(Builder::snapshotCreateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotCreateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHE_CLUSTER_ID_FIELD, NODE_GROUP_ID_FIELD, CACHE_NODE_ID_FIELD, NODE_GROUP_CONFIGURATION_FIELD, CACHE_SIZE_FIELD, CACHE_NODE_CREATE_TIME_FIELD, SNAPSHOT_CREATE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String cacheClusterId;
    private final String nodeGroupId;
    private final String cacheNodeId;
    private final NodeGroupConfiguration nodeGroupConfiguration;
    private final String cacheSize;
    private final Instant cacheNodeCreateTime;
    private final Instant snapshotCreateTime;

    private NodeSnapshot(BuilderImpl builder) {
        this.cacheClusterId = builder.cacheClusterId;
        this.nodeGroupId = builder.nodeGroupId;
        this.cacheNodeId = builder.cacheNodeId;
        this.nodeGroupConfiguration = builder.nodeGroupConfiguration;
        this.cacheSize = builder.cacheSize;
        this.cacheNodeCreateTime = builder.cacheNodeCreateTime;
        this.snapshotCreateTime = builder.snapshotCreateTime;
    }

    public String cacheClusterId() {
        return this.cacheClusterId;
    }

    public String nodeGroupId() {
        return this.nodeGroupId;
    }

    public String cacheNodeId() {
        return this.cacheNodeId;
    }

    public NodeGroupConfiguration nodeGroupConfiguration() {
        return this.nodeGroupConfiguration;
    }

    public String cacheSize() {
        return this.cacheSize;
    }

    public Instant cacheNodeCreateTime() {
        return this.cacheNodeCreateTime;
    }

    public Instant snapshotCreateTime() {
        return this.snapshotCreateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheNodeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeGroupConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheNodeCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotCreateTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeSnapshot)) {
            return false;
        }
        NodeSnapshot other = (NodeSnapshot)obj;
        return Objects.equals(this.cacheClusterId(), other.cacheClusterId()) && Objects.equals(this.nodeGroupId(), other.nodeGroupId()) && Objects.equals(this.cacheNodeId(), other.cacheNodeId()) && Objects.equals(this.nodeGroupConfiguration(), other.nodeGroupConfiguration()) && Objects.equals(this.cacheSize(), other.cacheSize()) && Objects.equals(this.cacheNodeCreateTime(), other.cacheNodeCreateTime()) && Objects.equals(this.snapshotCreateTime(), other.snapshotCreateTime());
    }

    public String toString() {
        return ToString.builder((String)"NodeSnapshot").add("CacheClusterId", (Object)this.cacheClusterId()).add("NodeGroupId", (Object)this.nodeGroupId()).add("CacheNodeId", (Object)this.cacheNodeId()).add("NodeGroupConfiguration", (Object)this.nodeGroupConfiguration()).add("CacheSize", (Object)this.cacheSize()).add("CacheNodeCreateTime", (Object)this.cacheNodeCreateTime()).add("SnapshotCreateTime", (Object)this.snapshotCreateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CacheClusterId": {
                return Optional.ofNullable(clazz.cast(this.cacheClusterId()));
            }
            case "NodeGroupId": {
                return Optional.ofNullable(clazz.cast(this.nodeGroupId()));
            }
            case "CacheNodeId": {
                return Optional.ofNullable(clazz.cast(this.cacheNodeId()));
            }
            case "NodeGroupConfiguration": {
                return Optional.ofNullable(clazz.cast(this.nodeGroupConfiguration()));
            }
            case "CacheSize": {
                return Optional.ofNullable(clazz.cast(this.cacheSize()));
            }
            case "CacheNodeCreateTime": {
                return Optional.ofNullable(clazz.cast(this.cacheNodeCreateTime()));
            }
            case "SnapshotCreateTime": {
                return Optional.ofNullable(clazz.cast(this.snapshotCreateTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NodeSnapshot, T> g) {
        return obj -> g.apply((NodeSnapshot)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String cacheClusterId;
        private String nodeGroupId;
        private String cacheNodeId;
        private NodeGroupConfiguration nodeGroupConfiguration;
        private String cacheSize;
        private Instant cacheNodeCreateTime;
        private Instant snapshotCreateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeSnapshot model) {
            this.cacheClusterId(model.cacheClusterId);
            this.nodeGroupId(model.nodeGroupId);
            this.cacheNodeId(model.cacheNodeId);
            this.nodeGroupConfiguration(model.nodeGroupConfiguration);
            this.cacheSize(model.cacheSize);
            this.cacheNodeCreateTime(model.cacheNodeCreateTime);
            this.snapshotCreateTime(model.snapshotCreateTime);
        }

        public final String getCacheClusterId() {
            return this.cacheClusterId;
        }

        @Override
        public final Builder cacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
            return this;
        }

        public final void setCacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
        }

        public final String getNodeGroupId() {
            return this.nodeGroupId;
        }

        @Override
        public final Builder nodeGroupId(String nodeGroupId) {
            this.nodeGroupId = nodeGroupId;
            return this;
        }

        public final void setNodeGroupId(String nodeGroupId) {
            this.nodeGroupId = nodeGroupId;
        }

        public final String getCacheNodeId() {
            return this.cacheNodeId;
        }

        @Override
        public final Builder cacheNodeId(String cacheNodeId) {
            this.cacheNodeId = cacheNodeId;
            return this;
        }

        public final void setCacheNodeId(String cacheNodeId) {
            this.cacheNodeId = cacheNodeId;
        }

        public final NodeGroupConfiguration.Builder getNodeGroupConfiguration() {
            return this.nodeGroupConfiguration != null ? this.nodeGroupConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder nodeGroupConfiguration(NodeGroupConfiguration nodeGroupConfiguration) {
            this.nodeGroupConfiguration = nodeGroupConfiguration;
            return this;
        }

        public final void setNodeGroupConfiguration(NodeGroupConfiguration.BuilderImpl nodeGroupConfiguration) {
            this.nodeGroupConfiguration = nodeGroupConfiguration != null ? nodeGroupConfiguration.build() : null;
        }

        public final String getCacheSize() {
            return this.cacheSize;
        }

        @Override
        public final Builder cacheSize(String cacheSize) {
            this.cacheSize = cacheSize;
            return this;
        }

        public final void setCacheSize(String cacheSize) {
            this.cacheSize = cacheSize;
        }

        public final Instant getCacheNodeCreateTime() {
            return this.cacheNodeCreateTime;
        }

        @Override
        public final Builder cacheNodeCreateTime(Instant cacheNodeCreateTime) {
            this.cacheNodeCreateTime = cacheNodeCreateTime;
            return this;
        }

        public final void setCacheNodeCreateTime(Instant cacheNodeCreateTime) {
            this.cacheNodeCreateTime = cacheNodeCreateTime;
        }

        public final Instant getSnapshotCreateTime() {
            return this.snapshotCreateTime;
        }

        @Override
        public final Builder snapshotCreateTime(Instant snapshotCreateTime) {
            this.snapshotCreateTime = snapshotCreateTime;
            return this;
        }

        public final void setSnapshotCreateTime(Instant snapshotCreateTime) {
            this.snapshotCreateTime = snapshotCreateTime;
        }

        public NodeSnapshot build() {
            return new NodeSnapshot(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NodeSnapshot> {
        public Builder cacheClusterId(String var1);

        public Builder nodeGroupId(String var1);

        public Builder cacheNodeId(String var1);

        public Builder nodeGroupConfiguration(NodeGroupConfiguration var1);

        default public Builder nodeGroupConfiguration(Consumer<NodeGroupConfiguration.Builder> nodeGroupConfiguration) {
            return this.nodeGroupConfiguration((NodeGroupConfiguration)((NodeGroupConfiguration.Builder)NodeGroupConfiguration.builder().applyMutation(nodeGroupConfiguration)).build());
        }

        public Builder cacheSize(String var1);

        public Builder cacheNodeCreateTime(Instant var1);

        public Builder snapshotCreateTime(Instant var1);
    }
}

