/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticache.ElastiCacheClient;
import software.amazon.awssdk.services.elasticache.internal.UserAgentUtils;
import software.amazon.awssdk.services.elasticache.model.DescribeGlobalReplicationGroupsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeGlobalReplicationGroupsResponse;
import software.amazon.awssdk.services.elasticache.model.GlobalReplicationGroup;

public class DescribeGlobalReplicationGroupsIterable
implements SdkIterable<DescribeGlobalReplicationGroupsResponse> {
    private final ElastiCacheClient client;
    private final DescribeGlobalReplicationGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeGlobalReplicationGroupsIterable(ElastiCacheClient client, DescribeGlobalReplicationGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeGlobalReplicationGroupsResponseFetcher();
    }

    public Iterator<DescribeGlobalReplicationGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<GlobalReplicationGroup> globalReplicationGroups() {
        Function<DescribeGlobalReplicationGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.globalReplicationGroups() != null) {
                return response.globalReplicationGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeGlobalReplicationGroupsResponseFetcher
    implements SyncPageFetcher<DescribeGlobalReplicationGroupsResponse> {
        private DescribeGlobalReplicationGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeGlobalReplicationGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeGlobalReplicationGroupsResponse nextPage(DescribeGlobalReplicationGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeGlobalReplicationGroupsIterable.this.client.describeGlobalReplicationGroups(DescribeGlobalReplicationGroupsIterable.this.firstRequest);
            }
            return DescribeGlobalReplicationGroupsIterable.this.client.describeGlobalReplicationGroups((DescribeGlobalReplicationGroupsRequest)((Object)DescribeGlobalReplicationGroupsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

