/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.eks.model.ArgoCdAwsIdcConfigResponse;
import software.amazon.awssdk.services.eks.model.ArgoCdNetworkAccessConfigResponse;
import software.amazon.awssdk.services.eks.model.ArgoCdRoleMapping;
import software.amazon.awssdk.services.eks.model.ArgoCdRoleMappingListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ArgoCdConfigResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ArgoCdConfigResponse> {
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespace").getter(ArgoCdConfigResponse.getter(ArgoCdConfigResponse::namespace)).setter(ArgoCdConfigResponse.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()}).build();
    private static final SdkField<ArgoCdAwsIdcConfigResponse> AWS_IDC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("awsIdc").getter(ArgoCdConfigResponse.getter(ArgoCdConfigResponse::awsIdc)).setter(ArgoCdConfigResponse.setter(Builder::awsIdc)).constructor(ArgoCdAwsIdcConfigResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsIdc").build()}).build();
    private static final SdkField<List<ArgoCdRoleMapping>> RBAC_ROLE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("rbacRoleMappings").getter(ArgoCdConfigResponse.getter(ArgoCdConfigResponse::rbacRoleMappings)).setter(ArgoCdConfigResponse.setter(Builder::rbacRoleMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rbacRoleMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ArgoCdRoleMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ArgoCdNetworkAccessConfigResponse> NETWORK_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("networkAccess").getter(ArgoCdConfigResponse.getter(ArgoCdConfigResponse::networkAccess)).setter(ArgoCdConfigResponse.setter(Builder::networkAccess)).constructor(ArgoCdNetworkAccessConfigResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkAccess").build()}).build();
    private static final SdkField<String> SERVER_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serverUrl").getter(ArgoCdConfigResponse.getter(ArgoCdConfigResponse::serverUrl)).setter(ArgoCdConfigResponse.setter(Builder::serverUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_FIELD, AWS_IDC_FIELD, RBAC_ROLE_MAPPINGS_FIELD, NETWORK_ACCESS_FIELD, SERVER_URL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ArgoCdConfigResponse.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String namespace;
    private final ArgoCdAwsIdcConfigResponse awsIdc;
    private final List<ArgoCdRoleMapping> rbacRoleMappings;
    private final ArgoCdNetworkAccessConfigResponse networkAccess;
    private final String serverUrl;

    private ArgoCdConfigResponse(BuilderImpl builder) {
        this.namespace = builder.namespace;
        this.awsIdc = builder.awsIdc;
        this.rbacRoleMappings = builder.rbacRoleMappings;
        this.networkAccess = builder.networkAccess;
        this.serverUrl = builder.serverUrl;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final ArgoCdAwsIdcConfigResponse awsIdc() {
        return this.awsIdc;
    }

    public final boolean hasRbacRoleMappings() {
        return this.rbacRoleMappings != null && !(this.rbacRoleMappings instanceof SdkAutoConstructList);
    }

    public final List<ArgoCdRoleMapping> rbacRoleMappings() {
        return this.rbacRoleMappings;
    }

    public final ArgoCdNetworkAccessConfigResponse networkAccess() {
        return this.networkAccess;
    }

    public final String serverUrl() {
        return this.serverUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsIdc());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRbacRoleMappings() ? this.rbacRoleMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.networkAccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverUrl());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArgoCdConfigResponse)) {
            return false;
        }
        ArgoCdConfigResponse other = (ArgoCdConfigResponse)obj;
        return Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.awsIdc(), other.awsIdc()) && this.hasRbacRoleMappings() == other.hasRbacRoleMappings() && Objects.equals(this.rbacRoleMappings(), other.rbacRoleMappings()) && Objects.equals(this.networkAccess(), other.networkAccess()) && Objects.equals(this.serverUrl(), other.serverUrl());
    }

    public final String toString() {
        return ToString.builder((String)"ArgoCdConfigResponse").add("Namespace", (Object)this.namespace()).add("AwsIdc", (Object)this.awsIdc()).add("RbacRoleMappings", this.hasRbacRoleMappings() ? this.rbacRoleMappings() : null).add("NetworkAccess", (Object)this.networkAccess()).add("ServerUrl", (Object)this.serverUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "awsIdc": {
                return Optional.ofNullable(clazz.cast(this.awsIdc()));
            }
            case "rbacRoleMappings": {
                return Optional.ofNullable(clazz.cast(this.rbacRoleMappings()));
            }
            case "networkAccess": {
                return Optional.ofNullable(clazz.cast(this.networkAccess()));
            }
            case "serverUrl": {
                return Optional.ofNullable(clazz.cast(this.serverUrl()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("namespace", NAMESPACE_FIELD);
        map.put("awsIdc", AWS_IDC_FIELD);
        map.put("rbacRoleMappings", RBAC_ROLE_MAPPINGS_FIELD);
        map.put("networkAccess", NETWORK_ACCESS_FIELD);
        map.put("serverUrl", SERVER_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ArgoCdConfigResponse, T> g) {
        return obj -> g.apply((ArgoCdConfigResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String namespace;
        private ArgoCdAwsIdcConfigResponse awsIdc;
        private List<ArgoCdRoleMapping> rbacRoleMappings = DefaultSdkAutoConstructList.getInstance();
        private ArgoCdNetworkAccessConfigResponse networkAccess;
        private String serverUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(ArgoCdConfigResponse model) {
            this.namespace(model.namespace);
            this.awsIdc(model.awsIdc);
            this.rbacRoleMappings(model.rbacRoleMappings);
            this.networkAccess(model.networkAccess);
            this.serverUrl(model.serverUrl);
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final ArgoCdAwsIdcConfigResponse.Builder getAwsIdc() {
            return this.awsIdc != null ? this.awsIdc.toBuilder() : null;
        }

        public final void setAwsIdc(ArgoCdAwsIdcConfigResponse.BuilderImpl awsIdc) {
            this.awsIdc = awsIdc != null ? awsIdc.build() : null;
        }

        @Override
        public final Builder awsIdc(ArgoCdAwsIdcConfigResponse awsIdc) {
            this.awsIdc = awsIdc;
            return this;
        }

        public final List<ArgoCdRoleMapping.Builder> getRbacRoleMappings() {
            List<ArgoCdRoleMapping.Builder> result = ArgoCdRoleMappingListCopier.copyToBuilder(this.rbacRoleMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRbacRoleMappings(Collection<ArgoCdRoleMapping.BuilderImpl> rbacRoleMappings) {
            this.rbacRoleMappings = ArgoCdRoleMappingListCopier.copyFromBuilder(rbacRoleMappings);
        }

        @Override
        public final Builder rbacRoleMappings(Collection<ArgoCdRoleMapping> rbacRoleMappings) {
            this.rbacRoleMappings = ArgoCdRoleMappingListCopier.copy(rbacRoleMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rbacRoleMappings(ArgoCdRoleMapping ... rbacRoleMappings) {
            this.rbacRoleMappings(Arrays.asList(rbacRoleMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rbacRoleMappings(Consumer<ArgoCdRoleMapping.Builder> ... rbacRoleMappings) {
            this.rbacRoleMappings(Stream.of(rbacRoleMappings).map(c -> (ArgoCdRoleMapping)((ArgoCdRoleMapping.Builder)ArgoCdRoleMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ArgoCdNetworkAccessConfigResponse.Builder getNetworkAccess() {
            return this.networkAccess != null ? this.networkAccess.toBuilder() : null;
        }

        public final void setNetworkAccess(ArgoCdNetworkAccessConfigResponse.BuilderImpl networkAccess) {
            this.networkAccess = networkAccess != null ? networkAccess.build() : null;
        }

        @Override
        public final Builder networkAccess(ArgoCdNetworkAccessConfigResponse networkAccess) {
            this.networkAccess = networkAccess;
            return this;
        }

        public final String getServerUrl() {
            return this.serverUrl;
        }

        public final void setServerUrl(String serverUrl) {
            this.serverUrl = serverUrl;
        }

        @Override
        public final Builder serverUrl(String serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        public ArgoCdConfigResponse build() {
            return new ArgoCdConfigResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ArgoCdConfigResponse> {
        public Builder namespace(String var1);

        public Builder awsIdc(ArgoCdAwsIdcConfigResponse var1);

        default public Builder awsIdc(Consumer<ArgoCdAwsIdcConfigResponse.Builder> awsIdc) {
            return this.awsIdc((ArgoCdAwsIdcConfigResponse)((ArgoCdAwsIdcConfigResponse.Builder)ArgoCdAwsIdcConfigResponse.builder().applyMutation(awsIdc)).build());
        }

        public Builder rbacRoleMappings(Collection<ArgoCdRoleMapping> var1);

        public Builder rbacRoleMappings(ArgoCdRoleMapping ... var1);

        public Builder rbacRoleMappings(Consumer<ArgoCdRoleMapping.Builder> ... var1);

        public Builder networkAccess(ArgoCdNetworkAccessConfigResponse var1);

        default public Builder networkAccess(Consumer<ArgoCdNetworkAccessConfigResponse.Builder> networkAccess) {
            return this.networkAccess((ArgoCdNetworkAccessConfigResponse)((ArgoCdNetworkAccessConfigResponse.Builder)ArgoCdNetworkAccessConfigResponse.builder().applyMutation(networkAccess)).build());
        }

        public Builder serverUrl(String var1);
    }
}

