/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.eks.model.ComputeConfigRequest;
import software.amazon.awssdk.services.eks.model.EksRequest;
import software.amazon.awssdk.services.eks.model.KubernetesNetworkConfigRequest;
import software.amazon.awssdk.services.eks.model.Logging;
import software.amazon.awssdk.services.eks.model.RemoteNetworkConfigRequest;
import software.amazon.awssdk.services.eks.model.StorageConfigRequest;
import software.amazon.awssdk.services.eks.model.UpdateAccessConfigRequest;
import software.amazon.awssdk.services.eks.model.UpgradePolicyRequest;
import software.amazon.awssdk.services.eks.model.VpcConfigRequest;
import software.amazon.awssdk.services.eks.model.ZonalShiftConfigRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateClusterConfigRequest
extends EksRequest
implements ToCopyableBuilder<Builder, UpdateClusterConfigRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateClusterConfigRequest.getter(UpdateClusterConfigRequest::name)).setter(UpdateClusterConfigRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()}).build();
    private static final SdkField<VpcConfigRequest> RESOURCES_VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resourcesVpcConfig").getter(UpdateClusterConfigRequest.getter(UpdateClusterConfigRequest::resourcesVpcConfig)).setter(UpdateClusterConfigRequest.setter(Builder::resourcesVpcConfig)).constructor(VpcConfigRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourcesVpcConfig").build()}).build();
    private static final SdkField<Logging> LOGGING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logging").getter(UpdateClusterConfigRequest.getter(UpdateClusterConfigRequest::logging)).setter(UpdateClusterConfigRequest.setter(Builder::logging)).constructor(Logging::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logging").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(UpdateClusterConfigRequest.getter(UpdateClusterConfigRequest::clientRequestToken)).setter(UpdateClusterConfigRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<UpdateAccessConfigRequest> ACCESS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("accessConfig").getter(UpdateClusterConfigRequest.getter(UpdateClusterConfigRequest::accessConfig)).setter(UpdateClusterConfigRequest.setter(Builder::accessConfig)).constructor(UpdateAccessConfigRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessConfig").build()}).build();
    private static final SdkField<UpgradePolicyRequest> UPGRADE_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("upgradePolicy").getter(UpdateClusterConfigRequest.getter(UpdateClusterConfigRequest::upgradePolicy)).setter(UpdateClusterConfigRequest.setter(Builder::upgradePolicy)).constructor(UpgradePolicyRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upgradePolicy").build()}).build();
    private static final SdkField<ZonalShiftConfigRequest> ZONAL_SHIFT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("zonalShiftConfig").getter(UpdateClusterConfigRequest.getter(UpdateClusterConfigRequest::zonalShiftConfig)).setter(UpdateClusterConfigRequest.setter(Builder::zonalShiftConfig)).constructor(ZonalShiftConfigRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zonalShiftConfig").build()}).build();
    private static final SdkField<ComputeConfigRequest> COMPUTE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("computeConfig").getter(UpdateClusterConfigRequest.getter(UpdateClusterConfigRequest::computeConfig)).setter(UpdateClusterConfigRequest.setter(Builder::computeConfig)).constructor(ComputeConfigRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeConfig").build()}).build();
    private static final SdkField<KubernetesNetworkConfigRequest> KUBERNETES_NETWORK_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("kubernetesNetworkConfig").getter(UpdateClusterConfigRequest.getter(UpdateClusterConfigRequest::kubernetesNetworkConfig)).setter(UpdateClusterConfigRequest.setter(Builder::kubernetesNetworkConfig)).constructor(KubernetesNetworkConfigRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kubernetesNetworkConfig").build()}).build();
    private static final SdkField<StorageConfigRequest> STORAGE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("storageConfig").getter(UpdateClusterConfigRequest.getter(UpdateClusterConfigRequest::storageConfig)).setter(UpdateClusterConfigRequest.setter(Builder::storageConfig)).constructor(StorageConfigRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageConfig").build()}).build();
    private static final SdkField<RemoteNetworkConfigRequest> REMOTE_NETWORK_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("remoteNetworkConfig").getter(UpdateClusterConfigRequest.getter(UpdateClusterConfigRequest::remoteNetworkConfig)).setter(UpdateClusterConfigRequest.setter(Builder::remoteNetworkConfig)).constructor(RemoteNetworkConfigRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteNetworkConfig").build()}).build();
    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("deletionProtection").getter(UpdateClusterConfigRequest.getter(UpdateClusterConfigRequest::deletionProtection)).setter(UpdateClusterConfigRequest.setter(Builder::deletionProtection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletionProtection").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, RESOURCES_VPC_CONFIG_FIELD, LOGGING_FIELD, CLIENT_REQUEST_TOKEN_FIELD, ACCESS_CONFIG_FIELD, UPGRADE_POLICY_FIELD, ZONAL_SHIFT_CONFIG_FIELD, COMPUTE_CONFIG_FIELD, KUBERNETES_NETWORK_CONFIG_FIELD, STORAGE_CONFIG_FIELD, REMOTE_NETWORK_CONFIG_FIELD, DELETION_PROTECTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateClusterConfigRequest.memberNameToFieldInitializer();
    private final String name;
    private final VpcConfigRequest resourcesVpcConfig;
    private final Logging logging;
    private final String clientRequestToken;
    private final UpdateAccessConfigRequest accessConfig;
    private final UpgradePolicyRequest upgradePolicy;
    private final ZonalShiftConfigRequest zonalShiftConfig;
    private final ComputeConfigRequest computeConfig;
    private final KubernetesNetworkConfigRequest kubernetesNetworkConfig;
    private final StorageConfigRequest storageConfig;
    private final RemoteNetworkConfigRequest remoteNetworkConfig;
    private final Boolean deletionProtection;

    private UpdateClusterConfigRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.resourcesVpcConfig = builder.resourcesVpcConfig;
        this.logging = builder.logging;
        this.clientRequestToken = builder.clientRequestToken;
        this.accessConfig = builder.accessConfig;
        this.upgradePolicy = builder.upgradePolicy;
        this.zonalShiftConfig = builder.zonalShiftConfig;
        this.computeConfig = builder.computeConfig;
        this.kubernetesNetworkConfig = builder.kubernetesNetworkConfig;
        this.storageConfig = builder.storageConfig;
        this.remoteNetworkConfig = builder.remoteNetworkConfig;
        this.deletionProtection = builder.deletionProtection;
    }

    public final String name() {
        return this.name;
    }

    public final VpcConfigRequest resourcesVpcConfig() {
        return this.resourcesVpcConfig;
    }

    public final Logging logging() {
        return this.logging;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final UpdateAccessConfigRequest accessConfig() {
        return this.accessConfig;
    }

    public final UpgradePolicyRequest upgradePolicy() {
        return this.upgradePolicy;
    }

    public final ZonalShiftConfigRequest zonalShiftConfig() {
        return this.zonalShiftConfig;
    }

    public final ComputeConfigRequest computeConfig() {
        return this.computeConfig;
    }

    public final KubernetesNetworkConfigRequest kubernetesNetworkConfig() {
        return this.kubernetesNetworkConfig;
    }

    public final StorageConfigRequest storageConfig() {
        return this.storageConfig;
    }

    public final RemoteNetworkConfigRequest remoteNetworkConfig() {
        return this.remoteNetworkConfig;
    }

    public final Boolean deletionProtection() {
        return this.deletionProtection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourcesVpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.logging());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.upgradePolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.zonalShiftConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.kubernetesNetworkConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteNetworkConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionProtection());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateClusterConfigRequest)) {
            return false;
        }
        UpdateClusterConfigRequest other = (UpdateClusterConfigRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.resourcesVpcConfig(), other.resourcesVpcConfig()) && Objects.equals(this.logging(), other.logging()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.accessConfig(), other.accessConfig()) && Objects.equals(this.upgradePolicy(), other.upgradePolicy()) && Objects.equals(this.zonalShiftConfig(), other.zonalShiftConfig()) && Objects.equals(this.computeConfig(), other.computeConfig()) && Objects.equals(this.kubernetesNetworkConfig(), other.kubernetesNetworkConfig()) && Objects.equals(this.storageConfig(), other.storageConfig()) && Objects.equals(this.remoteNetworkConfig(), other.remoteNetworkConfig()) && Objects.equals(this.deletionProtection(), other.deletionProtection());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateClusterConfigRequest").add("Name", (Object)this.name()).add("ResourcesVpcConfig", (Object)this.resourcesVpcConfig()).add("Logging", (Object)this.logging()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("AccessConfig", (Object)this.accessConfig()).add("UpgradePolicy", (Object)this.upgradePolicy()).add("ZonalShiftConfig", (Object)this.zonalShiftConfig()).add("ComputeConfig", (Object)this.computeConfig()).add("KubernetesNetworkConfig", (Object)this.kubernetesNetworkConfig()).add("StorageConfig", (Object)this.storageConfig()).add("RemoteNetworkConfig", (Object)this.remoteNetworkConfig()).add("DeletionProtection", (Object)this.deletionProtection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "resourcesVpcConfig": {
                return Optional.ofNullable(clazz.cast(this.resourcesVpcConfig()));
            }
            case "logging": {
                return Optional.ofNullable(clazz.cast(this.logging()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "accessConfig": {
                return Optional.ofNullable(clazz.cast(this.accessConfig()));
            }
            case "upgradePolicy": {
                return Optional.ofNullable(clazz.cast(this.upgradePolicy()));
            }
            case "zonalShiftConfig": {
                return Optional.ofNullable(clazz.cast(this.zonalShiftConfig()));
            }
            case "computeConfig": {
                return Optional.ofNullable(clazz.cast(this.computeConfig()));
            }
            case "kubernetesNetworkConfig": {
                return Optional.ofNullable(clazz.cast(this.kubernetesNetworkConfig()));
            }
            case "storageConfig": {
                return Optional.ofNullable(clazz.cast(this.storageConfig()));
            }
            case "remoteNetworkConfig": {
                return Optional.ofNullable(clazz.cast(this.remoteNetworkConfig()));
            }
            case "deletionProtection": {
                return Optional.ofNullable(clazz.cast(this.deletionProtection()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("resourcesVpcConfig", RESOURCES_VPC_CONFIG_FIELD);
        map.put("logging", LOGGING_FIELD);
        map.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("accessConfig", ACCESS_CONFIG_FIELD);
        map.put("upgradePolicy", UPGRADE_POLICY_FIELD);
        map.put("zonalShiftConfig", ZONAL_SHIFT_CONFIG_FIELD);
        map.put("computeConfig", COMPUTE_CONFIG_FIELD);
        map.put("kubernetesNetworkConfig", KUBERNETES_NETWORK_CONFIG_FIELD);
        map.put("storageConfig", STORAGE_CONFIG_FIELD);
        map.put("remoteNetworkConfig", REMOTE_NETWORK_CONFIG_FIELD);
        map.put("deletionProtection", DELETION_PROTECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateClusterConfigRequest, T> g) {
        return obj -> g.apply((UpdateClusterConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EksRequest.BuilderImpl
    implements Builder {
        private String name;
        private VpcConfigRequest resourcesVpcConfig;
        private Logging logging;
        private String clientRequestToken;
        private UpdateAccessConfigRequest accessConfig;
        private UpgradePolicyRequest upgradePolicy;
        private ZonalShiftConfigRequest zonalShiftConfig;
        private ComputeConfigRequest computeConfig;
        private KubernetesNetworkConfigRequest kubernetesNetworkConfig;
        private StorageConfigRequest storageConfig;
        private RemoteNetworkConfigRequest remoteNetworkConfig;
        private Boolean deletionProtection;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateClusterConfigRequest model) {
            super(model);
            this.name(model.name);
            this.resourcesVpcConfig(model.resourcesVpcConfig);
            this.logging(model.logging);
            this.clientRequestToken(model.clientRequestToken);
            this.accessConfig(model.accessConfig);
            this.upgradePolicy(model.upgradePolicy);
            this.zonalShiftConfig(model.zonalShiftConfig);
            this.computeConfig(model.computeConfig);
            this.kubernetesNetworkConfig(model.kubernetesNetworkConfig);
            this.storageConfig(model.storageConfig);
            this.remoteNetworkConfig(model.remoteNetworkConfig);
            this.deletionProtection(model.deletionProtection);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final VpcConfigRequest.Builder getResourcesVpcConfig() {
            return this.resourcesVpcConfig != null ? this.resourcesVpcConfig.toBuilder() : null;
        }

        public final void setResourcesVpcConfig(VpcConfigRequest.BuilderImpl resourcesVpcConfig) {
            this.resourcesVpcConfig = resourcesVpcConfig != null ? resourcesVpcConfig.build() : null;
        }

        @Override
        public final Builder resourcesVpcConfig(VpcConfigRequest resourcesVpcConfig) {
            this.resourcesVpcConfig = resourcesVpcConfig;
            return this;
        }

        public final Logging.Builder getLogging() {
            return this.logging != null ? this.logging.toBuilder() : null;
        }

        public final void setLogging(Logging.BuilderImpl logging) {
            this.logging = logging != null ? logging.build() : null;
        }

        @Override
        public final Builder logging(Logging logging) {
            this.logging = logging;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final UpdateAccessConfigRequest.Builder getAccessConfig() {
            return this.accessConfig != null ? this.accessConfig.toBuilder() : null;
        }

        public final void setAccessConfig(UpdateAccessConfigRequest.BuilderImpl accessConfig) {
            this.accessConfig = accessConfig != null ? accessConfig.build() : null;
        }

        @Override
        public final Builder accessConfig(UpdateAccessConfigRequest accessConfig) {
            this.accessConfig = accessConfig;
            return this;
        }

        public final UpgradePolicyRequest.Builder getUpgradePolicy() {
            return this.upgradePolicy != null ? this.upgradePolicy.toBuilder() : null;
        }

        public final void setUpgradePolicy(UpgradePolicyRequest.BuilderImpl upgradePolicy) {
            this.upgradePolicy = upgradePolicy != null ? upgradePolicy.build() : null;
        }

        @Override
        public final Builder upgradePolicy(UpgradePolicyRequest upgradePolicy) {
            this.upgradePolicy = upgradePolicy;
            return this;
        }

        public final ZonalShiftConfigRequest.Builder getZonalShiftConfig() {
            return this.zonalShiftConfig != null ? this.zonalShiftConfig.toBuilder() : null;
        }

        public final void setZonalShiftConfig(ZonalShiftConfigRequest.BuilderImpl zonalShiftConfig) {
            this.zonalShiftConfig = zonalShiftConfig != null ? zonalShiftConfig.build() : null;
        }

        @Override
        public final Builder zonalShiftConfig(ZonalShiftConfigRequest zonalShiftConfig) {
            this.zonalShiftConfig = zonalShiftConfig;
            return this;
        }

        public final ComputeConfigRequest.Builder getComputeConfig() {
            return this.computeConfig != null ? this.computeConfig.toBuilder() : null;
        }

        public final void setComputeConfig(ComputeConfigRequest.BuilderImpl computeConfig) {
            this.computeConfig = computeConfig != null ? computeConfig.build() : null;
        }

        @Override
        public final Builder computeConfig(ComputeConfigRequest computeConfig) {
            this.computeConfig = computeConfig;
            return this;
        }

        public final KubernetesNetworkConfigRequest.Builder getKubernetesNetworkConfig() {
            return this.kubernetesNetworkConfig != null ? this.kubernetesNetworkConfig.toBuilder() : null;
        }

        public final void setKubernetesNetworkConfig(KubernetesNetworkConfigRequest.BuilderImpl kubernetesNetworkConfig) {
            this.kubernetesNetworkConfig = kubernetesNetworkConfig != null ? kubernetesNetworkConfig.build() : null;
        }

        @Override
        public final Builder kubernetesNetworkConfig(KubernetesNetworkConfigRequest kubernetesNetworkConfig) {
            this.kubernetesNetworkConfig = kubernetesNetworkConfig;
            return this;
        }

        public final StorageConfigRequest.Builder getStorageConfig() {
            return this.storageConfig != null ? this.storageConfig.toBuilder() : null;
        }

        public final void setStorageConfig(StorageConfigRequest.BuilderImpl storageConfig) {
            this.storageConfig = storageConfig != null ? storageConfig.build() : null;
        }

        @Override
        public final Builder storageConfig(StorageConfigRequest storageConfig) {
            this.storageConfig = storageConfig;
            return this;
        }

        public final RemoteNetworkConfigRequest.Builder getRemoteNetworkConfig() {
            return this.remoteNetworkConfig != null ? this.remoteNetworkConfig.toBuilder() : null;
        }

        public final void setRemoteNetworkConfig(RemoteNetworkConfigRequest.BuilderImpl remoteNetworkConfig) {
            this.remoteNetworkConfig = remoteNetworkConfig != null ? remoteNetworkConfig.build() : null;
        }

        @Override
        public final Builder remoteNetworkConfig(RemoteNetworkConfigRequest remoteNetworkConfig) {
            this.remoteNetworkConfig = remoteNetworkConfig;
            return this;
        }

        public final Boolean getDeletionProtection() {
            return this.deletionProtection;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateClusterConfigRequest build() {
            return new UpdateClusterConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateClusterConfigRequest> {
        public Builder name(String var1);

        public Builder resourcesVpcConfig(VpcConfigRequest var1);

        default public Builder resourcesVpcConfig(Consumer<VpcConfigRequest.Builder> resourcesVpcConfig) {
            return this.resourcesVpcConfig((VpcConfigRequest)((VpcConfigRequest.Builder)VpcConfigRequest.builder().applyMutation(resourcesVpcConfig)).build());
        }

        public Builder logging(Logging var1);

        default public Builder logging(Consumer<Logging.Builder> logging) {
            return this.logging((Logging)((Logging.Builder)Logging.builder().applyMutation(logging)).build());
        }

        public Builder clientRequestToken(String var1);

        public Builder accessConfig(UpdateAccessConfigRequest var1);

        default public Builder accessConfig(Consumer<UpdateAccessConfigRequest.Builder> accessConfig) {
            return this.accessConfig((UpdateAccessConfigRequest)((UpdateAccessConfigRequest.Builder)UpdateAccessConfigRequest.builder().applyMutation(accessConfig)).build());
        }

        public Builder upgradePolicy(UpgradePolicyRequest var1);

        default public Builder upgradePolicy(Consumer<UpgradePolicyRequest.Builder> upgradePolicy) {
            return this.upgradePolicy((UpgradePolicyRequest)((UpgradePolicyRequest.Builder)UpgradePolicyRequest.builder().applyMutation(upgradePolicy)).build());
        }

        public Builder zonalShiftConfig(ZonalShiftConfigRequest var1);

        default public Builder zonalShiftConfig(Consumer<ZonalShiftConfigRequest.Builder> zonalShiftConfig) {
            return this.zonalShiftConfig((ZonalShiftConfigRequest)((ZonalShiftConfigRequest.Builder)ZonalShiftConfigRequest.builder().applyMutation(zonalShiftConfig)).build());
        }

        public Builder computeConfig(ComputeConfigRequest var1);

        default public Builder computeConfig(Consumer<ComputeConfigRequest.Builder> computeConfig) {
            return this.computeConfig((ComputeConfigRequest)((ComputeConfigRequest.Builder)ComputeConfigRequest.builder().applyMutation(computeConfig)).build());
        }

        public Builder kubernetesNetworkConfig(KubernetesNetworkConfigRequest var1);

        default public Builder kubernetesNetworkConfig(Consumer<KubernetesNetworkConfigRequest.Builder> kubernetesNetworkConfig) {
            return this.kubernetesNetworkConfig((KubernetesNetworkConfigRequest)((KubernetesNetworkConfigRequest.Builder)KubernetesNetworkConfigRequest.builder().applyMutation(kubernetesNetworkConfig)).build());
        }

        public Builder storageConfig(StorageConfigRequest var1);

        default public Builder storageConfig(Consumer<StorageConfigRequest.Builder> storageConfig) {
            return this.storageConfig((StorageConfigRequest)((StorageConfigRequest.Builder)StorageConfigRequest.builder().applyMutation(storageConfig)).build());
        }

        public Builder remoteNetworkConfig(RemoteNetworkConfigRequest var1);

        default public Builder remoteNetworkConfig(Consumer<RemoteNetworkConfigRequest.Builder> remoteNetworkConfig) {
            return this.remoteNetworkConfig((RemoteNetworkConfigRequest)((RemoteNetworkConfigRequest.Builder)RemoteNetworkConfigRequest.builder().applyMutation(remoteNetworkConfig)).build());
        }

        public Builder deletionProtection(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

