/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.eks.model.AccessScope;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociatedAccessPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssociatedAccessPolicy> {
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyArn").getter(AssociatedAccessPolicy.getter(AssociatedAccessPolicy::policyArn)).setter(AssociatedAccessPolicy.setter(Builder::policyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyArn").build()}).build();
    private static final SdkField<AccessScope> ACCESS_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("accessScope").getter(AssociatedAccessPolicy.getter(AssociatedAccessPolicy::accessScope)).setter(AssociatedAccessPolicy.setter(Builder::accessScope)).constructor(AccessScope::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessScope").build()}).build();
    private static final SdkField<Instant> ASSOCIATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("associatedAt").getter(AssociatedAccessPolicy.getter(AssociatedAccessPolicy::associatedAt)).setter(AssociatedAccessPolicy.setter(Builder::associatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedAt").build()}).build();
    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("modifiedAt").getter(AssociatedAccessPolicy.getter(AssociatedAccessPolicy::modifiedAt)).setter(AssociatedAccessPolicy.setter(Builder::modifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ARN_FIELD, ACCESS_SCOPE_FIELD, ASSOCIATED_AT_FIELD, MODIFIED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssociatedAccessPolicy.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String policyArn;
    private final AccessScope accessScope;
    private final Instant associatedAt;
    private final Instant modifiedAt;

    private AssociatedAccessPolicy(BuilderImpl builder) {
        this.policyArn = builder.policyArn;
        this.accessScope = builder.accessScope;
        this.associatedAt = builder.associatedAt;
        this.modifiedAt = builder.modifiedAt;
    }

    public final String policyArn() {
        return this.policyArn;
    }

    public final AccessScope accessScope() {
        return this.accessScope;
    }

    public final Instant associatedAt() {
        return this.associatedAt;
    }

    public final Instant modifiedAt() {
        return this.modifiedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessScope());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociatedAccessPolicy)) {
            return false;
        }
        AssociatedAccessPolicy other = (AssociatedAccessPolicy)obj;
        return Objects.equals(this.policyArn(), other.policyArn()) && Objects.equals(this.accessScope(), other.accessScope()) && Objects.equals(this.associatedAt(), other.associatedAt()) && Objects.equals(this.modifiedAt(), other.modifiedAt());
    }

    public final String toString() {
        return ToString.builder((String)"AssociatedAccessPolicy").add("PolicyArn", (Object)this.policyArn()).add("AccessScope", (Object)this.accessScope()).add("AssociatedAt", (Object)this.associatedAt()).add("ModifiedAt", (Object)this.modifiedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyArn": {
                return Optional.ofNullable(clazz.cast(this.policyArn()));
            }
            case "accessScope": {
                return Optional.ofNullable(clazz.cast(this.accessScope()));
            }
            case "associatedAt": {
                return Optional.ofNullable(clazz.cast(this.associatedAt()));
            }
            case "modifiedAt": {
                return Optional.ofNullable(clazz.cast(this.modifiedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("policyArn", POLICY_ARN_FIELD);
        map.put("accessScope", ACCESS_SCOPE_FIELD);
        map.put("associatedAt", ASSOCIATED_AT_FIELD);
        map.put("modifiedAt", MODIFIED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociatedAccessPolicy, T> g) {
        return obj -> g.apply((AssociatedAccessPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String policyArn;
        private AccessScope accessScope;
        private Instant associatedAt;
        private Instant modifiedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociatedAccessPolicy model) {
            this.policyArn(model.policyArn);
            this.accessScope(model.accessScope);
            this.associatedAt(model.associatedAt);
            this.modifiedAt(model.modifiedAt);
        }

        public final String getPolicyArn() {
            return this.policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final AccessScope.Builder getAccessScope() {
            return this.accessScope != null ? this.accessScope.toBuilder() : null;
        }

        public final void setAccessScope(AccessScope.BuilderImpl accessScope) {
            this.accessScope = accessScope != null ? accessScope.build() : null;
        }

        @Override
        public final Builder accessScope(AccessScope accessScope) {
            this.accessScope = accessScope;
            return this;
        }

        public final Instant getAssociatedAt() {
            return this.associatedAt;
        }

        public final void setAssociatedAt(Instant associatedAt) {
            this.associatedAt = associatedAt;
        }

        @Override
        public final Builder associatedAt(Instant associatedAt) {
            this.associatedAt = associatedAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return this.modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public AssociatedAccessPolicy build() {
            return new AssociatedAccessPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssociatedAccessPolicy> {
        public Builder policyArn(String var1);

        public Builder accessScope(AccessScope var1);

        default public Builder accessScope(Consumer<AccessScope.Builder> accessScope) {
            return this.accessScope((AccessScope)((AccessScope.Builder)AccessScope.builder().applyMutation(accessScope)).build());
        }

        public Builder associatedAt(Instant var1);

        public Builder modifiedAt(Instant var1);
    }
}

